/*
 * Decompiled with CFR 0.152.
 */
package gtf.robocode.opponent;

import gtf.robocode.Point;
import gtf.robocode.Reading;
import gtf.robocode.opponent.Opponent;

class CircularOpponent
extends Opponent {
    Reading[] readings = new Reading[2];

    CircularOpponent(String name) {
        super(name);
    }

    public Point getLastPosition() {
        return new Point(this.readings[1].getTime(), this.readings[1].getX(), this.readings[1].getY());
    }

    public synchronized Point getPredictedPosition(double time) {
        double turnRate;
        double speed = this.readings[1].getSpeed();
        double dt = time - (double)this.readings[1].getTime();
        if (this.readings[0] == null) {
            double headingChange = 0.0;
            turnRate = 0.0;
        } else {
            double headingChange = this.readings[1].getHeadingRadians() - this.readings[0].getHeadingRadians();
            turnRate = headingChange / (double)(this.readings[1].getTime() - this.readings[0].getTime());
        }
        if (Math.abs(turnRate) < 1.0E-4) {
            return new Point(time, this.readings[1].getX() + speed * dt * Math.sin(this.readings[1].getHeadingRadians()), this.readings[1].getY() + speed * dt * Math.cos(this.readings[1].getHeadingRadians()));
        }
        double radius = speed / turnRate;
        double centreX = this.readings[1].getX() + radius * Math.cos(this.readings[1].getHeadingRadians());
        double centreY = this.readings[1].getY() - radius * Math.sin(this.readings[1].getHeadingRadians());
        double theta = this.readings[1].getHeadingRadians() + turnRate * (time - (double)this.readings[1].getTime());
        return new Point(time, centreX - radius * Math.cos(theta), centreY + radius * Math.sin(theta));
    }

    synchronized void addReading(Reading reading) {
        this.readings[0] = this.readings[1];
        this.readings[1] = reading;
    }
}

