/*
 * Decompiled with CFR 0.152.
 */
package br2;

import MGAM.BotMaster;
import MGAM.Enemy;
import MGAM.FWUtils;
import MGAM.Movement;
import br2.MD_AStarNode;
import br2.MD_Bullet;
import br2.MD_ShootSmart;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import robocode.util.Utils;

public class MD_MoveDodgeBullets
extends Movement {
    Point2D.Double finalDestination;
    Point2D.Double nextDestination;
    MD_ShootSmart m_smartGun;
    public Vector<MD_Bullet> mBulletsToDodge;
    public Vector<MD_AStarNode> m_ANodes;
    Point2D.Double testPos;
    boolean mFirstMove;
    boolean m_pickNewDir;
    public int m_gridCount = 20;
    public int m_gridPixelSize;

    public MD_MoveDodgeBullets(BotMaster bot, MD_ShootSmart smartGun) {
        super(bot);
        this.m_smartGun = smartGun;
        this.mFirstMove = true;
        this.m_pickNewDir = true;
    }

    @Override
    public void initialize() {
        this.finalDestination = new Point2D.Double(0.0, 0.0);
        this.nextDestination = new Point2D.Double(0.0, 0.0);
        this.testPos = new Point2D.Double(0.0, 0.0);
        this.mBulletsToDodge = new Vector();
        this.m_ANodes = new Vector();
        this.m_gridPixelSize = (int)(this.bot.getBattleFieldWidth() / (double)this.m_gridCount);
        for (int row = 0; row < this.m_gridCount; ++row) {
            for (int column = 0; column < this.m_gridCount; ++column) {
                MD_AStarNode n = new MD_AStarNode(row, column, this.m_gridPixelSize, this.m_gridCount);
                this.m_ANodes.add(n);
            }
        }
    }

    @Override
    public void move() {
        this.addDangerToNodes();
        this.chooseFinalDestination();
        if (this.finalDestination.x >= 0.0) {
            Point2D.Double currentLocation = new Point2D.Double(this.bot.self.dX, this.bot.self.dY);
            this.doAStar(currentLocation);
            double angle = Utils.normalRelativeAngle((double)(FWUtils.absoluteBearing(currentLocation, this.nextDestination) - this.bot.getHeadingRadians()));
            double turnAngle = Math.atan(Math.tan(angle));
            this.bot.setTurnRightRadians(turnAngle);
            this.bot.setAhead(currentLocation.distance(this.nextDestination) * (double)(angle == turnAngle ? 1 : -1));
        }
    }

    public void addDangerToNodes() {
        int i;
        for (i = 0; i < this.m_ANodes.size(); ++i) {
            this.m_ANodes.get((int)i).m_G_dangerCost = 0.0;
        }
        this.mBulletsToDodge.clear();
        for (i = 0; i < this.m_smartGun.mBullets.size(); ++i) {
            MD_Bullet bullet = this.m_smartGun.mBullets.get(i);
            if (!bullet.m_isEnemyBullet) continue;
            Point2D.Double pos = bullet.getBulletLocation();
            MD_AStarNode currNode = this.getNode(pos);
            if (currNode != null) {
                this.addDangerHeatBullet(currNode, bullet.m_power);
            }
            for (int shotPredict = 0; shotPredict < 4; ++shotPredict) {
                double vecX = pos.x + Math.sin(bullet.m_fireAngle) * (double)this.m_gridPixelSize;
                double vecY = pos.y + Math.cos(bullet.m_fireAngle) * (double)this.m_gridPixelSize;
                pos.setLocation(vecX, vecY);
                currNode = this.getNode(pos);
                if (currNode == null) continue;
                this.addDangerHeatBullet(currNode, bullet.m_power);
            }
            this.mBulletsToDodge.add(bullet);
        }
        for (Enemy target : BotMaster.enemies.values()) {
            MD_AStarNode currNode;
            if (target.bDead || (currNode = this.getNode(new Point2D.Double(target.dX, target.dY))) == null) continue;
            this.addDangerHeatBot(currNode, 4.0);
        }
    }

    public void addDangerHeatBullet(MD_AStarNode currNode, double power) {
        currNode.m_G_dangerCost += 10.0 * power;
        int row = currNode.m_row;
        int column = currNode.m_column;
        for (int rowOff = -1; rowOff <= 1; ++rowOff) {
            for (int colOff = -1; colOff <= 1; ++colOff) {
                if (rowOff == 0 && colOff == 0 || !this.validRC(row + rowOff, column + colOff)) continue;
                MD_AStarNode neigbor = this.m_ANodes.get((row + rowOff) * this.m_gridCount + (column + colOff));
                neigbor.m_G_dangerCost += 6.0 * power;
            }
        }
    }

    public void addDangerHeatBot(MD_AStarNode currNode, double power) {
        currNode.m_G_dangerCost += 10.0 * power;
        int row = currNode.m_row;
        int column = currNode.m_column;
        for (int rowOff = -2; rowOff <= 2; ++rowOff) {
            for (int colOff = -2; colOff <= 2; ++colOff) {
                if (rowOff == 0 && colOff == 0 || !this.validRC(row + rowOff, column + colOff)) continue;
                double off = Math.abs(rowOff) + Math.abs(colOff);
                double factor = (4.0 - off) / 3.0 * 0.5 + 0.5;
                MD_AStarNode neigbor = this.m_ANodes.get((row + rowOff) * this.m_gridCount + (column + colOff));
                neigbor.m_G_dangerCost += 8.0 * power * factor;
            }
        }
    }

    public MD_AStarNode getNode(Point2D.Double location) {
        if (location.x < 0.0 || location.y < 0.0) {
            return null;
        }
        Point2D.Double normalizedLoc = new Point2D.Double(location.x / BotMaster.battlefieldWidth, location.y / BotMaster.battlefieldHeight);
        int row = (int)Math.floor(normalizedLoc.y * (double)this.m_gridCount);
        int column = (int)Math.floor(normalizedLoc.x * (double)this.m_gridCount);
        if (row >= this.m_gridCount) {
            row = this.m_gridCount - 1;
        }
        if (column >= this.m_gridCount) {
            column = this.m_gridCount - 1;
        }
        return this.m_ANodes.get(row * this.m_gridCount + column);
    }

    public void doAStar(Point2D.Double currentLocation) {
        int i;
        MD_AStarNode currNode = this.getNode(currentLocation);
        MD_AStarNode destNode = this.getNode(this.finalDestination);
        if (currNode.m_finalDestination) {
            this.m_pickNewDir = true;
            for (int i2 = 0; i2 < this.m_ANodes.size(); ++i2) {
                this.m_ANodes.get((int)i2).m_finalDestination = false;
            }
            return;
        }
        if (!currNode.m_startLocation) {
            for (i = 0; i < this.m_ANodes.size(); ++i) {
                this.m_ANodes.get((int)i).m_startLocation = false;
            }
            currNode.m_startLocation = true;
        }
        if (!destNode.m_finalDestination) {
            for (i = 0; i < this.m_ANodes.size(); ++i) {
                this.m_ANodes.get((int)i).m_finalDestination = false;
            }
            destNode.m_finalDestination = true;
            this.calculateHValue(destNode.m_row, destNode.m_column);
        }
        TreeMap<Integer, MD_AStarNode> openList = new TreeMap<Integer, MD_AStarNode>();
        TreeMap<Integer, MD_AStarNode> closedList = new TreeMap<Integer, MD_AStarNode>();
        boolean keepLooping = true;
        currNode.m_G_movementCost = 0.0;
        MD_AStarNode currProcessingNode = currNode;
        int loopCount = 0;
        while (keepLooping) {
            if (loopCount > this.m_gridCount * this.m_gridCount + this.m_gridCount) {
                System.out.println("fail sauce");
                break;
            }
            ++loopCount;
            closedList.put(currProcessingNode.m_index, currProcessingNode);
            int row = currProcessingNode.m_row;
            int column = currProcessingNode.m_column;
            boolean foundDestination = false;
            block4: for (int rowOff = -1; rowOff <= 1; ++rowOff) {
                for (int colOff = -1; colOff <= 1; ++colOff) {
                    if (rowOff == 0 && colOff == 0 || !this.validRC(row + rowOff, column + colOff)) continue;
                    MD_AStarNode nextNode = this.m_ANodes.get((row + rowOff) * this.m_gridCount + (column + colOff));
                    if (nextNode.m_index == destNode.m_index) {
                        foundDestination = true;
                        nextNode.m_parent = currProcessingNode;
                        continue block4;
                    }
                    if (closedList.containsKey(nextNode.m_index) || openList.containsKey(nextNode.m_index)) continue;
                    openList.put(nextNode.m_index, nextNode);
                    nextNode.m_parent = currProcessingNode;
                    nextNode.m_G_movementCost = rowOff == 0 || colOff == 0 ? 10.0 + currProcessingNode.m_G_movementCost + nextNode.m_G_dangerCost + nextNode.m_G_edgeCost : 7.0 + currProcessingNode.m_G_movementCost + nextNode.m_G_dangerCost + nextNode.m_G_edgeCost;
                    nextNode.m_F_sum = nextNode.m_G_movementCost + nextNode.m_H_heuristic;
                }
            }
            if (foundDestination) {
                keepLooping = false;
                continue;
            }
            MD_AStarNode cheapest = (MD_AStarNode)openList.get(openList.firstKey());
            double cheapestCost = 9.9999999E7;
            for (Map.Entry entry : openList.entrySet()) {
                if (!(((MD_AStarNode)entry.getValue()).m_F_sum < cheapestCost)) continue;
                cheapest = (MD_AStarNode)entry.getValue();
                cheapestCost = ((MD_AStarNode)entry.getValue()).m_F_sum;
            }
            currProcessingNode = cheapest;
            closedList.put(cheapest.m_index, cheapest);
            openList.remove(cheapest.m_index);
        }
        MD_AStarNode pathNode = destNode;
        for (int oopsCounter = 0; !pathNode.m_parent.m_startLocation && oopsCounter <= 110; ++oopsCounter) {
            pathNode = pathNode.m_parent;
        }
        this.nextDestination.setLocation(pathNode.getNodeCenter());
    }

    public boolean validRC(int r, int c) {
        return r >= 0 && r < this.m_gridCount && c >= 0 && c < this.m_gridCount;
    }

    public void calculateHValue(int destRow, int destColumn) {
        for (int row = 0; row < this.m_gridCount; ++row) {
            for (int column = 0; column < this.m_gridCount; ++column) {
                double distance;
                this.m_ANodes.get((int)(row * this.m_gridCount + column)).m_H_heuristic = distance = (double)(Math.abs(destRow - row) + Math.abs(destColumn - column));
            }
        }
    }

    public void chooseFinalDestination() {
        if (this.bot.getTurnRemaining() == 0.0 && this.bot.getDistanceRemaining() == 0.0) {
            this.m_pickNewDir = true;
        } else if (this.mFirstMove) {
            Point2D.Double cLoc = new Point2D.Double(this.bot.self.dX, this.bot.self.dY);
            double normalizedX = cLoc.getX() / BotMaster.battlefieldWidth;
            double normalizedY = cLoc.getY() / BotMaster.battlefieldHeight;
            double minRange = 0.11;
            if (normalizedX < minRange || normalizedX > 1.0 - minRange || normalizedY < minRange || normalizedY > 1.0 - minRange) {
                this.m_pickNewDir = true;
                this.mFirstMove = false;
            }
        } else if (Math.random() > 0.95) {
            this.m_pickNewDir = true;
        }
        if (this.m_pickNewDir) {
            this.m_pickNewDir = false;
            double LL = 1.0;
            double LR = 1.0;
            double UL = 1.0;
            double UR = 1.0;
            double edgeFactor = 0.1;
            double inFactor = 3.0;
            for (Enemy target : BotMaster.enemies.values()) {
                if (target.bDead) continue;
                if (target.dX < this.bot.getX()) {
                    if (target.dY < this.bot.getY()) {
                        LL += inFactor;
                        LR += edgeFactor;
                        UL += edgeFactor;
                        continue;
                    }
                    UL += inFactor;
                    UR += edgeFactor;
                    LL += edgeFactor;
                    continue;
                }
                if (target.dY < this.bot.getY()) {
                    LR += inFactor;
                    LL += edgeFactor;
                    UR += edgeFactor;
                    continue;
                }
                UR += inFactor;
                UL += edgeFactor;
                LR += edgeFactor;
            }
            LL *= Math.random();
            LR *= Math.random();
            UL *= Math.random();
            UR *= Math.random();
            Point2D.Double currentLocation = new Point2D.Double(this.bot.self.dX, this.bot.self.dY);
            double normalizedX = currentLocation.getX() / BotMaster.battlefieldWidth;
            double normalizedY = currentLocation.getY() / BotMaster.battlefieldHeight;
            double minRange = 0.11;
            if (normalizedX < minRange) {
                LL *= 10.0;
                UL *= 10.0;
            } else if (normalizedX > 1.0 - minRange) {
                LR *= 10.0;
                UR *= 10.0;
            }
            if (normalizedY < minRange) {
                LR *= 10.0;
                LL *= 10.0;
            } else if (normalizedY > 1.0 - minRange) {
                UR *= 10.0;
                UL *= 10.0;
            }
            int pixelOffset = (int)((double)this.m_gridPixelSize * 1.5);
            double minCount = UL;
            this.finalDestination.setLocation(pixelOffset, BotMaster.battlefieldHeight);
            if (UR < minCount) {
                this.finalDestination.setLocation(BotMaster.battlefieldWidth - (double)pixelOffset, BotMaster.battlefieldHeight - (double)pixelOffset);
                minCount = UR;
            }
            if (LR < minCount) {
                minCount = LR;
                this.finalDestination.setLocation(BotMaster.battlefieldWidth - (double)pixelOffset, pixelOffset);
            }
            if (LL < minCount) {
                minCount = LL;
                this.finalDestination.setLocation(pixelOffset, pixelOffset);
            }
        }
    }

    @Override
    public void onPaint(Graphics2D g) {
        g.setColor(new Color(0, 255, 0, 128));
        g.drawLine((int)this.bot.self.dX, (int)this.bot.self.dY, (int)this.finalDestination.x, (int)this.finalDestination.y);
        g.drawLine((int)this.bot.self.dX, (int)this.bot.self.dY, (int)this.nextDestination.x, (int)this.nextDestination.y);
        for (int i = 0; i < this.mBulletsToDodge.size(); ++i) {
            Point2D.Double pos = this.mBulletsToDodge.get(i).getBulletLocation();
            g.fill(new Ellipse2D.Double((int)pos.x - 25, (int)pos.y - 25, 50.0, 50.0));
        }
        Point2D.Double normalizedDest = new Point2D.Double(this.finalDestination.x / BotMaster.battlefieldWidth, this.finalDestination.y / BotMaster.battlefieldHeight);
        int destRow = (int)Math.floor(normalizedDest.y * (double)this.m_gridCount);
        int destColum = (int)Math.floor(normalizedDest.x * (double)this.m_gridCount);
        if (destRow >= this.m_gridCount) {
            destRow = this.m_gridCount - 1;
        }
        if (destColum >= this.m_gridCount) {
            destColum = this.m_gridCount - 1;
        }
        MD_AStarNode destNode = this.m_ANodes.get(destRow * this.m_gridCount + destColum);
        destNode.onPaintPath(g);
        MD_AStarNode currNode = destNode.m_parent;
        for (int oopsCounter = 0; !currNode.m_startLocation && oopsCounter <= 110; ++oopsCounter) {
            currNode.onPaintPath(g);
            currNode = currNode.m_parent;
        }
        for (int i = 0; i < this.m_ANodes.size(); ++i) {
            this.m_ANodes.get(i).onPaintDanger(g);
        }
    }
}

