/*
 * Decompiled with CFR 0.152.
 */
package rampancy.util.data.kdTree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import rampancy.util.data.kdTree.KDPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KDNearestSearch<T extends KDPoint> {
    public T target;
    public int k;
    public List<T> nearestNeighbors;
    public ArrayList<Double> distances;
    public double furthestDistance;

    public KDNearestSearch(T target, int k) {
        this.k = k;
        this.target = target;
        this.nearestNeighbors = new ArrayList<T>();
        this.distances = new ArrayList();
        this.furthestDistance = -1.0;
    }

    public boolean attemptToAdd(T candidate) {
        double dist = ((KDPoint)candidate).distanceTo((KDPoint)this.target);
        if (this.nearestNeighbors.size() < this.k) {
            this.nearestNeighbors.add(candidate);
            this.furthestDistance = Math.max(dist, this.furthestDistance);
            return true;
        }
        if (dist < this.furthestDistance) {
            this.furthestDistance = (this.furthestDistance - dist) / 2.0;
            this.nearestNeighbors.add(candidate);
            return true;
        }
        return false;
    }

    public boolean canTraverse(T candidate) {
        return this.nearestNeighbors.size() < this.k || ((KDPoint)candidate).distanceTo((KDPoint)this.target) <= this.furthestDistance;
    }

    public List<T> getNearestNeighbors() {
        this.sortNeighbors();
        return this.nearestNeighbors.subList(0, Math.min(this.nearestNeighbors.size(), this.k));
    }

    private void sortNeighbors() {
        Collections.sort(this.nearestNeighbors, new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                double dist2;
                double dist1 = ((KDPoint)o1).distanceTo((KDPoint)KDNearestSearch.this.target);
                if (dist1 == (dist2 = ((KDPoint)o2).distanceTo((KDPoint)KDNearestSearch.this.target))) {
                    return 0;
                }
                if (dist1 < dist2) {
                    return -1;
                }
                return 1;
            }
        });
    }
}

