/*
 * Decompiled with CFR 0.152.
 */
package deo.virtual;

import deo.virtual.Util;

class BulletData {
    protected String name;
    protected double originX;
    protected double originY;
    protected double power;
    protected long time;
    protected double robotX;
    protected double robotY;
    protected double robotHeading;
    protected int robotVelocity;
    protected int robotAcceleration;
    protected double distance;
    protected double angle;
    protected double maxGuessFactorAngle;
    protected boolean active;
    protected boolean powerGuessed;

    public BulletData(String s, double d, double d1, double d2, boolean flag, double d3, double d4, double d5, int i, int j, long l) {
        this.name = s;
        this.originX = d;
        this.originY = d1;
        this.power = d2;
        this.powerGuessed = flag;
        this.robotX = d3;
        this.robotY = d4;
        this.robotHeading = d5;
        this.robotVelocity = i;
        this.robotAcceleration = j;
        this.time = l;
        this.distance = Util.distance(this.originX, this.originY, this.robotX, this.robotY);
        this.angle = Util.direction(this.originX, this.originY, this.robotX, this.robotY);
        this.maxGuessFactorAngle = Math.toDegrees(Math.asin(8.0 / (20.0 - 3.0 * this.power)));
        double d6 = this.robotVelocity >= 0 ? this.robotHeading : this.robotHeading + 180.0;
        if (Math.abs(Util.relativeAngle(this.angle + 90.0, d6)) > 90.0) {
            this.maxGuessFactorAngle *= -1.0;
        }
        this.active = true;
    }

    public void adapt(double d) {
        this.power = d;
        this.maxGuessFactorAngle = Math.toDegrees(Math.asin(8.0 / (20.0 - 3.0 * this.power)));
        double d2 = this.robotVelocity >= 0 ? this.robotHeading : this.robotHeading + 180.0;
        if (Math.abs(Util.relativeAngle(this.angle + 90.0, d2)) > 90.0) {
            this.maxGuessFactorAngle *= -1.0;
        }
    }

    public final String getName() {
        return this.name;
    }

    public final double getOriginX() {
        return this.originX;
    }

    public final double getOriginY() {
        return this.originY;
    }

    public final double getDistance() {
        return this.distance;
    }

    public final double getAngle() {
        return this.angle;
    }

    public final double getPower() {
        return this.power;
    }

    public final double getSpeed() {
        return 20.0 - 3.0 * this.power;
    }

    public final double getRobotX() {
        return this.robotX;
    }

    public final double getRobotY() {
        return this.robotY;
    }

    public final double getRobotHeading() {
        return this.robotHeading;
    }

    public final int getRobotVelocity() {
        return this.robotVelocity;
    }

    public final int getRobotAcceleration() {
        return this.robotAcceleration;
    }

    public final long getTime() {
        return this.time;
    }

    public final double getGuessFactor(double d) {
        return Util.confine(Util.relativeAngle(this.angle, d) / this.maxGuessFactorAngle, -1.0, 1.0);
    }

    public final double getHeading(double d) {
        return this.angle + d * this.maxGuessFactorAngle;
    }

    public final double getGuessFactor(double d, double d1) {
        return this.getGuessFactor(Util.direction(this.originX, this.originY, d, d1));
    }

    public final boolean isActive() {
        return this.active;
    }

    public final boolean isPowerGuessed() {
        return this.powerGuessed;
    }

    public final void deactivate() {
        this.active = false;
    }
}

