/*
 * Decompiled with CFR 0.152.
 */
package eskimo.micro;

import java.awt.Color;
import java.util.Random;
import robocode.AdvancedRobot;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class Echo
extends AdvancedRobot {
    double enemy_energy = 100.0;
    double min_wall_dist = 50.0;
    double run_dist = 40.0;

    public void run() {
        this.setColors(Color.WHITE, Color.BLACK, Color.BLACK);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustRadarForRobotTurn(true);
        this.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
        while (true) {
            this.scan();
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        Random rand = new Random();
        int doit = rand.nextInt(20);
        if (this.enemy_energy - e.getEnergy() > 0.3) {
            this.setAhead(this.run_dist);
        } else if (doit <= 2) {
            this.setAhead(this.run_dist);
        }
        double radarTurn = this.getHeadingRadians() + e.getBearingRadians() - this.getRadarHeadingRadians();
        this.setTurnRadarRightRadians(Utils.normalRelativeAngle((double)radarTurn));
        double gunTurn = this.getRadarHeadingRadians() - this.getGunHeadingRadians();
        this.setTurnGunRadians(gunTurn);
        double bodyTurn = this.getRadarHeadingRadians() - this.getHeadingRadians() - 1.5707963267948966;
        bodyTurn = this.getTurnFromWall() >= 0.0 ? this.getTurnFromWall() - this.getHeadingRadians() : this.getRadarHeadingRadians() - this.getHeadingRadians() - 1.5707963267948966;
        this.setTurnRadians(bodyTurn);
        double power = 0.0;
        power = e.getDistance() > 500.0 ? 1.0 : (e.getDistance() > 200.0 ? 2.0 : 3.0);
        this.setFire(power);
        this.enemy_energy = e.getEnergy();
    }

    private void setTurnRadians(double rad) {
        if ((rad %= Math.PI * 2) > Math.PI) {
            rad -= Math.PI * 2;
        }
        if (rad < -Math.PI) {
            rad += Math.PI * 2;
        }
        if (rad == 0.0) {
            return;
        }
        if (rad > 0.0) {
            this.setTurnRightRadians(rad);
        } else {
            this.setTurnLeftRadians(-rad);
        }
    }

    private double setTurnGunRadians(double rad) {
        if ((rad %= Math.PI * 2) > Math.PI) {
            rad -= Math.PI * 2;
        }
        if (rad < -Math.PI) {
            rad += Math.PI * 2;
        }
        if (rad == 0.0) {
            return 0.0;
        }
        if (rad > 0.0) {
            this.setTurnGunRightRadians(rad);
        } else {
            this.setTurnGunLeftRadians(-rad);
        }
        return Math.abs(rad);
    }

    private double getTurnFromWall() {
        if (this.getX() < this.min_wall_dist) {
            return 1.5707963267948966;
        }
        if (this.getY() < this.min_wall_dist) {
            return 0.0;
        }
        if (this.getBattleFieldWidth() - this.getX() < this.min_wall_dist) {
            return 4.71238898038469;
        }
        if (this.getBattleFieldHeight() - this.getY() < this.min_wall_dist) {
            return Math.PI;
        }
        return -1.0;
    }
}

