/*
 * Decompiled with CFR 0.152.
 */
package alk.lap.strategy.analysis;

import alk.lap.LoudAndProud;
import alk.lap.bothandling.Gunner;
import alk.lap.strategy.AtomicMove;
import alk.lap.strategy.PatternBase;
import alk.lap.strategy.ScanDatabase;
import alk.lap.strategy.analysis.HitAngleStatistic;
import alk.lap.strategy.analysis.HitDistanceStatistic;
import alk.lap.strategy.analysis.TargetStrategyStatistic;
import alk.lap.strategy.analysis.VirtualHitHistory;
import alk.lap.strategy.targetting.TargetStrategy;
import alk.lap.utils.DVektor;
import alk.lap.utils.RollingHistory;
import java.awt.Color;
import java.lang.reflect.Field;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalystsDatabase {
    public static double THRESHOLD_NEAR_FAR = 320.0;
    private static final int HIT_HISTORY_SIZE = 2;
    private static final int HIT_HISTORY_MAXCOUNT = 30;
    private RollingHistory<VirtualHitHistory> virtualHitHistory = new RollingHistory(2);
    private RollingHistory<VirtualHitHistory> virtualHitHistoryFar = new RollingHistory(2);
    private static final int ANGLE_HISTORY_SIZE = 35;
    private RollingHistory<HitAngleStatistic> enemyHitAngleStatNear = new RollingHistory(35);
    private RollingHistory<HitAngleStatistic> enemyHitAngleStatFar = new RollingHistory(35);
    public RollingHistory<HitAngleStatistic> proudHitAngleStat = new RollingHistory(35);
    private static final int CONT_ANGLE_HISTORY_SIZE = 3;
    private static final int CONT_HIT_MAXCOUNT = 1500;
    public RollingHistory<HitAngleStatistic> enemyContinousHitAngleStatNear = new RollingHistory(3);
    public RollingHistory<HitAngleStatistic> enemyContinousHitAngleStatFar = new RollingHistory(3);
    public RollingHistory<HitAngleStatistic> proudContinousHitAngleStat = new RollingHistory(3);
    private static final int DIST_HISTORY_SIZE = 40;
    public RollingHistory<HitDistanceStatistic> enemyDistStat = new RollingHistory(40);
    public RollingHistory<HitDistanceStatistic> proudDistStat = new RollingHistory(40);
    private static final int TSTRAT_HISTORY_SIZE = 10;
    private RollingHistory<TargetStrategyStatistic> heuristicEnemyTargetStrategyStat = new RollingHistory(10);
    private RollingHistory<TargetStrategyStatistic> moveBasedEnemyTargetStrategyStat = new RollingHistory(10);
    private ScanDatabase scanBase = new ScanDatabase();
    private PatternBase patternBase = new PatternBase();
    public long deltaTsWithNoStdDev = 0L;
    public long deltaTsWithStdDev = 0L;
    public double velocitystdDev = -1.0;
    public double velocityAvg = -1.0;
    public double moveLengthAvg = -1.0;
    public double movedurationAvg = -1.0;
    private LoudAndProud proud;
    public int rounds_won = 0;
    public int rounds_lost = 0;

    public double ratioOfConstMovement() {
        return (double)this.deltaTsWithNoStdDev / (double)(this.deltaTsWithNoStdDev + this.deltaTsWithStdDev);
    }

    public RollingHistory<HitAngleStatistic> getEnemyHitAngleStat(double distanceAtFiring) {
        return distanceAtFiring > THRESHOLD_NEAR_FAR ? this.enemyHitAngleStatFar : this.enemyHitAngleStatNear;
    }

    public void incrementEnemyHitAngleAtBearing(double bearing, double distanceAtFiring) {
        this.getEnemyHitAngleStat(distanceAtFiring).current().incAtBearing(bearing);
    }

    public void incrementProudHitAngleAtBearing(double bearing) {
        this.proudHitAngleStat.current().incAtBearing(bearing);
    }

    public RollingHistory<HitAngleStatistic> getEnemyContHitAngleStat(double distanceAtFiring) {
        return distanceAtFiring > THRESHOLD_NEAR_FAR ? this.enemyContinousHitAngleStatFar : this.enemyContinousHitAngleStatNear;
    }

    public void incrementContEnemyHitAngleAtBearing(double bearing, double distanceAtFiring) {
        RollingHistory<HitAngleStatistic> stat = this.getEnemyContHitAngleStat(distanceAtFiring);
        stat.current().incAtBearing(bearing);
        if (stat.current().count > 1500) {
            stat.newIteration(new HitAngleStatistic());
        }
    }

    public void incrementContProudHitAngleAtBearing(double bearing) {
        this.proudContinousHitAngleStat.current().incAtBearing(bearing);
        if (this.proudContinousHitAngleStat.current().count > 1500) {
            this.proudContinousHitAngleStat.newIteration(new HitAngleStatistic());
        }
    }

    public StatMax getBestAngleto(RollingHistory<HitAngleStatistic> angleStatHist, double intervalSize) {
        int maxScore = 0;
        int maxBearingSegment = 0;
        int bearing_segment = 0;
        while (bearing_segment < 120) {
            int sum = this.getAngleScore(HitAngleStatistic.angleOf(bearing_segment), angleStatHist, intervalSize);
            if (sum > maxScore) {
                maxScore = sum;
                maxBearingSegment = bearing_segment;
            }
            ++bearing_segment;
        }
        return new StatMax(HitAngleStatistic.angleOf(maxBearingSegment), (double)maxScore);
    }

    public StatMax getBestAngleOnSide(RollingHistory<HitAngleStatistic> angleStatHist, double dir, double intervalSize) {
        int maxScore = 0;
        int fromSegment = dir <= 0.0 ? 0 : 60;
        int toSegment = dir < 0.0 ? 60 : 120;
        int maxBearingSegment = fromSegment;
        int bearing_segment = fromSegment;
        while (bearing_segment < toSegment) {
            int score = this.getAngleScore(HitAngleStatistic.angleOf(bearing_segment), angleStatHist, intervalSize);
            if (score > maxScore) {
                maxScore = score;
                maxBearingSegment = bearing_segment;
            }
            ++bearing_segment;
        }
        return new StatMax(HitAngleStatistic.angleOf(maxBearingSegment), (double)maxScore);
    }

    public int getAngleScore(double angle, RollingHistory<HitAngleStatistic> angleStatHist, double intervalSize) {
        int sum = 0;
        for (HitAngleStatistic statistic : angleStatHist) {
            sum += statistic.getHitsAt(angle, intervalSize);
        }
        return sum;
    }

    public void newRound(LoudAndProud proud) {
        this.proud = proud;
        this.scanBase.newRound(proud);
        this.patternBase.newRound(proud);
        this.enemyHitAngleStatNear.newIteration(new HitAngleStatistic());
        this.enemyHitAngleStatFar.newIteration(new HitAngleStatistic());
        this.proudHitAngleStat.newIteration(new HitAngleStatistic());
        if (this.enemyDistStat.size() > 0) {
            proud.log("DistHist=" + this.enemyDistStat.current().getCount());
        }
        this.enemyDistStat.newIteration(new HitDistanceStatistic());
        this.proudDistStat.newIteration(new HitDistanceStatistic());
        this.heuristicEnemyTargetStrategyStat.newIteration(new TargetStrategyStatistic(proud));
        this.moveBasedEnemyTargetStrategyStat.newIteration(new TargetStrategyStatistic(proud));
        if (proud.getRoundNum() == 0) {
            this.enemyContinousHitAngleStatNear.newIteration(new HitAngleStatistic());
            this.enemyContinousHitAngleStatFar.newIteration(new HitAngleStatistic());
            this.proudContinousHitAngleStat.newIteration(new HitAngleStatistic());
            this.virtualHitHistory.newIteration(new VirtualHitHistory());
            this.virtualHitHistoryFar.newIteration(new VirtualHitHistory());
            this.incrementHitForEnemyStrategy(proud.getStrategicLead().getCurrentGunner().getTargetStrategy(), 1);
        }
    }

    public StatMax getBestTargetStrategy(double enemyDistance) {
        StatMax max = new StatMax(null, 0.0);
        for (Gunner gunner : this.proud.getStrategicLead().allGunners()) {
            String stratName = gunner.getTargetStrategy().describe();
            double damage = this.getDamageOfStrategy(gunner.getTargetStrategy(), enemyDistance);
            if (!(damage > max.score)) continue;
            max.name = stratName;
            max.score = damage;
        }
        return max;
    }

    public RollingHistory<VirtualHitHistory> getVirtualHitHistory(double initialDistance) {
        return this.virtualHitHistoryFar;
    }

    public void incrementHit(String strategyName, double initialDistance) {
        RollingHistory<VirtualHitHistory> hist = this.getVirtualHitHistory(initialDistance);
        hist.current().incrementHit(strategyName);
        if (hist.current().getCount() > 30) {
            hist.newIteration(new VirtualHitHistory());
        }
    }

    public double getDamageOfStrategy(TargetStrategy strat, double initialDistance) {
        double power;
        int sum = 0;
        for (VirtualHitHistory statistic : this.getVirtualHitHistory(initialDistance)) {
            sum += statistic.getHitCount(strat.describe());
        }
        double damage = 4.0 * power + ((power = strat.getFireEnergy()) > 1.0 ? 2.0 * (power - 1.0) : 0.0);
        double energyGain = 3.0 * power;
        double energyLoose = power;
        double normingFactor = 16.0 / (10.0 + 2.0 * power);
        return normingFactor * (double)sum * (damage + energyGain - energyLoose);
    }

    TargetStrategyStatistic currentEnemyStratStat(TargetStrategy.StrategyType type) {
        if (type == TargetStrategy.StrategyType.Heuristic) {
            return this.heuristicEnemyTargetStrategyStat.current();
        }
        return this.moveBasedEnemyTargetStrategyStat.current();
    }

    public void incrementHitForEnemyStrategy(TargetStrategy t, int count) {
        this.currentEnemyStratStat(t.getType()).incHit(t, 1);
    }

    public void rewardAvoiding() {
        TargetStrategyStatistic.StrategyCount[] maxStrat = this.getEnemyMostProbableTargetStrat();
        int i = 0;
        while (i < Math.min(maxStrat.length, 2)) {
            TargetStrategyStatistic.StrategyCount cfr_ignored_0 = maxStrat[i];
            ++i;
        }
    }

    public int getEnemyTargetHitCount(TargetStrategy strat) {
        int sum = 0;
        RollingHistory<TargetStrategyStatistic> stat = null;
        stat = strat.getType() == TargetStrategy.StrategyType.Heuristic ? this.heuristicEnemyTargetStrategyStat : this.moveBasedEnemyTargetStrategyStat;
        for (TargetStrategyStatistic statistic : stat) {
            sum += statistic.getCount((String)strat.describe()).hitCount;
        }
        return sum;
    }

    public TargetStrategyStatistic.StrategyCount[] getEnemyMostProbableTargetStrat() {
        TreeSet<TargetStrategyStatistic.StrategyCount> countsHeuristic = new TreeSet<TargetStrategyStatistic.StrategyCount>();
        TreeSet<TargetStrategyStatistic.StrategyCount> countsMove = new TreeSet<TargetStrategyStatistic.StrategyCount>();
        TargetStrategy[] targetStrategyArray = this.proud.getTacticLead().getEnemyTargetStrategies();
        int n = 0;
        int n2 = targetStrategyArray.length;
        while (n < n2) {
            TargetStrategy strat = targetStrategyArray[n];
            TargetStrategyStatistic.StrategyCount strategyCount = new TargetStrategyStatistic.StrategyCount(strat);
            strategyCount.hitCount = this.getEnemyTargetHitCount(strat);
            if (strat.getType() == TargetStrategy.StrategyType.Heuristic) {
                countsHeuristic.add(strategyCount);
            } else {
                countsMove.add(strategyCount);
            }
            ++n;
        }
        TargetStrategyStatistic.StrategyCount[] result = null;
        int resultSize = Math.min(3, countsHeuristic.size() + countsMove.size());
        result = new TargetStrategyStatistic.StrategyCount[resultSize];
        int i = 0;
        if (countsHeuristic.size() > 0) {
            result[i] = (TargetStrategyStatistic.StrategyCount)countsHeuristic.first();
            countsHeuristic.remove(result[i]);
            ++i;
        }
        if (countsMove.size() > 0) {
            result[i] = (TargetStrategyStatistic.StrategyCount)countsMove.first();
            countsMove.remove(result[i]);
            ++i;
        }
        if (countsHeuristic.size() == 0) {
            if (countsMove.size() > 0) {
                result[i] = (TargetStrategyStatistic.StrategyCount)countsMove.first();
                countsMove.remove(result[i]);
                ++i;
            }
        } else if (countsMove.size() == 0) {
            if (countsHeuristic.size() > 0) {
                result[i] = (TargetStrategyStatistic.StrategyCount)countsHeuristic.first();
                countsHeuristic.remove(result[i]);
                ++i;
            }
        } else {
            TargetStrategyStatistic.StrategyCount heurSecond = (TargetStrategyStatistic.StrategyCount)countsHeuristic.first();
            TargetStrategyStatistic.StrategyCount moveSecond = (TargetStrategyStatistic.StrategyCount)countsMove.first();
            result[i] = heurSecond.hitCount >= moveSecond.hitCount ? heurSecond : moveSecond;
        }
        return result;
    }

    public void incrementEnemyHitDistance(double d) {
        this.enemyDistStat.current().incAtDistance(d);
    }

    public StatMax getMostLikelyDistance(RollingHistory<HitDistanceStatistic> hitDistanceStatistic, double dir) {
        StatMax max = new StatMax(0.0, 0.0);
        int fromSegment = dir <= 0.0 ? 0 : 53;
        int toSegment = dir >= 0.0 ? 106 : 53;
        int dist_segment = fromSegment;
        while (dist_segment < toSegment) {
            double dist = HitDistanceStatistic.distanceOf(dist_segment);
            int score = this.getDistanceScore(dist, hitDistanceStatistic);
            if ((double)score > max.score) {
                max.score = score;
                max.value = dist;
            }
            ++dist_segment;
        }
        return max;
    }

    int getDistanceScore(double dist, RollingHistory<HitDistanceStatistic> hitDistanceStatistic) {
        int sum = 0;
        for (HitDistanceStatistic statistic : hitDistanceStatistic) {
            sum += statistic.getHitsAt(dist);
        }
        return sum;
    }

    public void paint(LoudAndProud proud) {
    }

    private void paintRoundScore() {
        double startX = this.proud.getBattleFieldWidth() / 2.0;
        double startY = this.proud.getBattleFieldHeight() - 40.0;
        int barHeight = 16;
        int maxScore = Math.max(this.rounds_lost, this.rounds_won);
        double scaleToMax = maxScore == 0 ? 0.0 : (double)Math.min(maxScore, 100) / (double)maxScore;
        this.proud.getVc().drawRect(new DVektor(startX, startY + (double)barHeight + 1.0), new DVektor(startX + (double)this.rounds_won * scaleToMax, startY + 1.0 + (double)(2 * barHeight)), "" + this.rounds_won, Color.green);
        this.proud.getVc().drawRect(new DVektor(startX, startY), new DVektor(startX + (double)this.rounds_lost * scaleToMax, startY + (double)barHeight), "" + this.rounds_lost, Color.red);
    }

    public String toString() {
        Field[] allFields = this.getClass().getDeclaredFields();
        StringBuffer fieldsAndContent = new StringBuffer();
        int i = 0;
        while (i < allFields.length) {
            Field field = allFields[i];
            fieldsAndContent.append(String.valueOf(field.getName()) + "=");
            Class<?> type = field.getType();
            try {
                if (type.isPrimitive() && type == Double.TYPE) {
                    fieldsAndContent.append(LoudAndProud.printStaticDouble(field.getDouble(this)));
                } else if (field.getName().equals("virtualHitHistory")) {
                    fieldsAndContent.append(VirtualHitHistory.printHitStat());
                } else {
                    fieldsAndContent.append(field.get(this));
                }
            }
            catch (IllegalArgumentException e) {
                fieldsAndContent.append("<not accessible>");
            }
            catch (IllegalAccessException e) {
                fieldsAndContent.append("<not accessible>");
            }
            fieldsAndContent.append(";\n");
            ++i;
        }
        return fieldsAndContent.toString();
    }

    public String toCSVHead() {
        return "'dT with no StdDev', 'dT with StdDev''ratio','vStdDev', 'vAvg'";
    }

    public String toCSV() {
        return this.deltaTsWithNoStdDev + "," + "," + LoudAndProud.printStaticDouble(this.ratioOfConstMovement()) + "," + LoudAndProud.printStaticDouble(this.velocitystdDev) + "," + LoudAndProud.printStaticDouble(this.velocityAvg);
    }

    public ScanDatabase getScanBase() {
        return this.scanBase;
    }

    public void addAtomicMove(AtomicMove atomicMove) {
        this.patternBase.addAtomicMove(atomicMove);
    }

    public PatternBase getPatternBase() {
        return this.patternBase;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StatMax
    implements Comparable<StatMax> {
        public double value;
        public String name;
        public double score;

        public StatMax(double value, double score) {
            this.value = value;
            this.score = score;
        }

        public StatMax(String name, double score) {
            this.name = name;
            this.score = score;
        }

        @Override
        public int compareTo(StatMax o) {
            return this.score > o.score ? 1 : -1;
        }
    }
}

