/*
 * Decompiled with CFR 0.152.
 */
package wiki;

import java.awt.Color;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayDeque;
import robocode.AdvancedRobot;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class BasicBulletShielder
extends AdvancedRobot {
    ArrayDeque<Double> pastAngles = new ArrayDeque();
    static final double BULLET_START_POWER = 0.15;
    Point2D lastPosition = null;
    double lastEnemyEnergy = 100.0;
    double lastMoveDistance = 0.0;
    double aimAngle = 0.0;
    double firePower = 0.15;
    long fireOnTick = 0L;
    static final int[] TIME_TO_MOVE = new int[]{1, 1, 2, 2, 3, 3, 4, 4, 4};
    static final int[] MAX_MOVE_DIST = new int[]{1, 1, 3, 5, 8};

    public void run() {
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setAllColors(Color.WHITE);
        this.turnRadarRightRadians(Double.POSITIVE_INFINITY);
        while (true) {
            this.scan();
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        double angleToEnemy = this.getHeadingRadians() + e.getBearingRadians();
        Point2D enemyPosition = this.project(this.getPosition(), angleToEnemy, e.getDistance());
        this.pastAngles.addFirst(angleToEnemy);
        if (this.pastAngles.size() > 3) {
            this.pastAngles.removeLast();
        }
        long time = this.getTime();
        this.setTurnRadarRightRadians(1.9 * Utils.normalRelativeAngle((double)(angleToEnemy - this.getRadarHeadingRadians())));
        double enemyEnergy = e.getEnergy();
        double deltaEnergy = this.lastEnemyEnergy - enemyEnergy;
        this.lastEnemyEnergy = enemyEnergy;
        if (deltaEnergy > 0.0 && deltaEnergy <= 3.0) {
            double bulletAngle = this.pastAngles.getLast() + Math.PI;
            double bulletSpeed = Rules.getBulletSpeed((double)deltaEnergy);
            int minTimeTillNextFire = (int)(Rules.getGunHeat((double)deltaEnergy) / this.getGunCoolingRate());
            int maxTestDistance = this.getMaxMoveDistanceForTime(minTimeTillNextFire / 2);
            double bestDeviation = Double.POSITIVE_INFINITY;
            double myBulletSpeed = Rules.getBulletSpeed((double)0.15);
            int move = -maxTestDistance;
            while (move <= maxTestDistance) {
                if (move != 0) {
                    double dB;
                    double deviation;
                    Point2D myFirePosition = this.getMoveEnd(move);
                    long timeToMove = TIME_TO_MOVE[Math.abs(move)];
                    Point2D bulletStart = this.project(this.lastPosition, bulletAngle, bulletSpeed * (double)(timeToMove + 1L));
                    Point2D target = this.intercept(myFirePosition, myBulletSpeed, bulletStart, bulletAngle, bulletSpeed);
                    double eGoalTime = Math.ceil(bulletStart.distance(target) / bulletSpeed);
                    target = this.project(bulletStart, bulletAngle, (eGoalTime - 0.5) * bulletSpeed);
                    double myGunAim = this.angleFromTo(myFirePosition, target);
                    Line2D.Double eLine = new Line2D.Double(this.project(bulletStart, bulletAngle, bulletSpeed * (eGoalTime - 1.0)), this.project(bulletStart, bulletAngle, bulletSpeed * eGoalTime));
                    double myTargetTime = myFirePosition.distance(target) / myBulletSpeed;
                    double myGoalTime = Math.ceil(myTargetTime);
                    Line2D.Double myLine = new Line2D.Double(this.project(myFirePosition, myGunAim, myBulletSpeed * (myGoalTime - 1.0)), this.project(myFirePosition, myGunAim, myBulletSpeed * myGoalTime));
                    if (myLine.intersectsLine(eLine) && (deviation = (dB = myTargetTime - (myGoalTime - 0.5)) * dB) < bestDeviation) {
                        bestDeviation = deviation;
                        this.lastMoveDistance = move;
                        this.fireOnTick = time + timeToMove;
                        double goalSpeed = myFirePosition.distance(target) / (myGoalTime - 0.5);
                        this.firePower = Math.max(0.1, Math.min((20.0 - goalSpeed) / 3.0, 0.2));
                        this.aimAngle = myGunAim;
                        this.setTurnRightRadians(0.0);
                        this.setAhead(this.lastMoveDistance);
                    }
                }
                ++move;
            }
        }
        if (enemyEnergy <= 0.0) {
            this.setFire(0.1);
        }
        if (time == this.fireOnTick) {
            this.setFire(this.firePower);
        }
        if (time == this.fireOnTick + 1L) {
            this.setAhead(-this.lastMoveDistance);
        }
        if (time > this.fireOnTick && this.getDistanceRemaining() == 0.0) {
            this.aimAngle = angleToEnemy;
            this.setTurnRightRadians(Utils.normalRelativeAngle((double)(angleToEnemy + 1.5707963267948966 - 0.7853981633974483 - this.getHeadingRadians())));
        }
        this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(this.aimAngle - this.getGunHeadingRadians())));
        this.lastPosition = enemyPosition;
    }

    public void onBulletHit(BulletHitEvent e) {
        this.lastEnemyEnergy -= Rules.getBulletDamage((double)e.getBullet().getPower());
    }

    public void onHitByBullet(HitByBulletEvent e) {
        this.lastEnemyEnergy += Rules.getBulletHitBonus((double)e.getPower());
    }

    public int getMaxMoveDistanceForTime(int time) {
        if (time >= MAX_MOVE_DIST.length) {
            return MAX_MOVE_DIST[MAX_MOVE_DIST.length - 1];
        }
        return MAX_MOVE_DIST[time];
    }

    public Point2D getMoveEnd(double distance) {
        return this.project(this.getPosition(), this.getHeadingRadians(), distance);
    }

    public Point2D getPosition() {
        return new Point2D.Double(this.getX(), this.getY());
    }

    public Point2D project(Point2D start, double angle, double length) {
        return new Point2D.Double(start.getX() + Math.sin(angle) * length, start.getY() + Math.cos(angle) * length);
    }

    public Point2D intercept(Point2D pos, double vel, Point2D tPos, double tHeading, double tVel) {
        double tVelX = Math.sin(tHeading) * tVel;
        double tVelY = Math.cos(tHeading) * tVel;
        double relX = tPos.getX() - pos.getX();
        double relY = tPos.getY() - pos.getY();
        double b = relX * tVelX + relY * tVelY;
        double a = vel * vel - tVel * tVel;
        b = (b + Math.sqrt(b * b + a * (relX * relX + relY * relY))) / a;
        return new Point2D.Double(tVelX * b + tPos.getX(), tVelY * b + tPos.getY());
    }

    public double angleFromTo(Point2D a, Point2D b) {
        return Math.atan2(b.getX() - a.getX(), b.getY() - a.getY());
    }
}

