/*
 * Decompiled with CFR 0.152.
 */
package agd.util;

import agd.predict.Trackable;
import agd.util.AdvancedRobotAdapter;
import agd.util.Coord;
import agd.util.Enemy;
import agd.util.RobotInformation;
import agd.util.TargetSelectionStrategy;
import agd.util.World;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import robocode.RobotDeathEvent;

public class CleverTargetSelector
extends AdvancedRobotAdapter
implements TargetSelectionStrategy {
    RobotInformation ri;
    Enemy currentTarget = null;

    public CleverTargetSelector(RobotInformation ri) {
        this.ri = ri;
        EventListener eventListener = new EventListener();
        ri.addListener(eventListener);
    }

    public Enemy getTarget() {
        Enemy oldTarget = this.currentTarget;
        Set disabled = this.getDisabledEnemies();
        double gunHeat = World.getAdvancedRobot().getGunHeat();
        double coolingRate = World.getAdvancedRobot().getGunCoolingRate();
        if (this.currentTarget == null || !(gunHeat / coolingRate < 2.0)) {
            if (disabled.size() > 0) {
                Iterator i = disabled.iterator();
                this.currentTarget = (Enemy)i.next();
                if (World.isDebug() && this.currentTarget != oldTarget) {
                    System.out.println("Targeting disabled robot " + this.currentTarget);
                }
            } else {
                TreeSet enemiesByDistance = new TreeSet(new Trackable.DistanceComparator(this.ri.getPosition()));
                enemiesByDistance.addAll(this.ri.getEnemies().values());
                if (enemiesByDistance.size() != 0) {
                    if (this.selectVeryCloseEnemies(enemiesByDistance)) {
                        if (World.isDebug()) {
                            if (oldTarget != null && oldTarget != this.currentTarget) {
                                System.out.println("Abandoned targeting " + oldTarget + " in favour of " + this.currentTarget + " because it's very close.");
                            } else if (oldTarget == null) {
                                System.out.println("Targeting " + this.currentTarget + " because it's very close.");
                            }
                        }
                    } else {
                        Coord ourPos = this.ri.getPosition();
                        Enemy closest = (Enemy)enemiesByDistance.first();
                        double closestDistance = closest.getPosition().distanceTo(ourPos);
                        if (this.currentTarget == null || closestDistance < this.currentTarget.getPosition().distanceTo(ourPos) * 0.75) {
                            double maxDistance = closestDistance * 1.25;
                            SortedSet candidates = this.selectClosestCandidatesByEnergy(enemiesByDistance, maxDistance);
                            this.currentTarget = (Enemy)candidates.first();
                            if (World.isDebug()) {
                                System.out.println("Selecting " + this.currentTarget + " as weakest new target from " + candidates.size() + " candidates");
                            }
                        }
                    }
                }
            }
        }
        return this.currentTarget;
    }

    private SortedSet selectClosestCandidatesByEnergy(SortedSet enemiesByDistance, double maxDistance) {
        TreeSet<Enemy> closeByEnergy = new TreeSet<Enemy>(new Enemy.EnergyComparator());
        boolean done = false;
        Iterator i = enemiesByDistance.iterator();
        while (i.hasNext() && !done) {
            Enemy e = (Enemy)i.next();
            if (e.getPosition().distanceTo(this.ri.getPosition()) < maxDistance) {
                closeByEnergy.add(e);
                continue;
            }
            done = true;
        }
        return closeByEnergy;
    }

    private boolean selectVeryCloseEnemies(SortedSet enemiesByDistance) {
        boolean selected = false;
        Iterator i = enemiesByDistance.iterator();
        SortedSet veryCloseEnemies = this.selectClosestCandidatesByEnergy(enemiesByDistance, 150.0);
        if (veryCloseEnemies.size() > 0) {
            selected = true;
            this.currentTarget = (Enemy)veryCloseEnemies.first();
        }
        return selected;
    }

    private void selectDisabledEnemy() {
    }

    private Set getDisabledEnemies() {
        HashSet<Enemy> disabled = new HashSet<Enemy>();
        Iterator i = this.ri.getEnemies().values().iterator();
        while (i.hasNext()) {
            Enemy e = (Enemy)i.next();
            if (e.getEnergy() != 0.0 || e.getBulletsInFlight().size() >= 2) continue;
            disabled.add(e);
        }
        return disabled;
    }

    class EventListener
    extends AdvancedRobotAdapter {
        EventListener() {
        }

        public void onRobotDeath(RobotDeathEvent rde) {
            if (CleverTargetSelector.this.currentTarget != null && rde.getName().equals(CleverTargetSelector.this.currentTarget.getName())) {
                CleverTargetSelector.this.currentTarget = null;
            }
        }
    }
}

