/*
 * Decompiled with CFR 0.152.
 */
package agd.util;

import agd.util.AdvancedRobotAdapter;
import agd.util.Compass;
import agd.util.Coord;
import agd.util.Navigation;
import agd.util.NavigationStrategy;
import agd.util.Navigator;
import agd.util.RobotInformation;
import robocode.HitRobotEvent;

public class WiggleGoto
extends AdvancedRobotAdapter
implements NavigationStrategy {
    Coord destination = null;
    RobotInformation robot = null;
    boolean finished = false;
    NavigationStrategy nextStrategy = null;
    Navigator navigator = null;
    double acceptableRange = 20.0;

    public WiggleGoto(RobotInformation r, Coord destination) {
        this.robot = r;
        this.destination = destination;
    }

    public void discard() {
    }

    public void setDestination(Coord dest) {
        this.finished = false;
        this.destination = dest;
    }

    public String toString() {
        return "WiggleGoto { within " + this.acceptableRange + " of " + this.destination + "}";
    }

    public void setAcceptableRange(double r) {
        this.acceptableRange = r;
    }

    public WiggleGoto(RobotInformation r, Coord destination, Navigator n, NavigationStrategy strat) {
        this.robot = r;
        this.destination = destination;
        this.navigator = n;
        this.nextStrategy = strat;
    }

    public void onHitRobot(HitRobotEvent hre) {
    }

    public Navigation navigate() {
        Navigation navinfo = new Navigation();
        Coord ourPos = this.robot.getPosition();
        if (!this.finished && ourPos.distanceTo(this.destination) < this.acceptableRange) {
            this.finished = true;
        }
        if (!this.finished) {
            Compass ourHeading = new Compass(this.robot.getAdvancedRobot().getHeading());
            Compass requiredHeading = ourPos.headingTo(this.destination);
            double bearing = ourHeading.bearingTo(requiredHeading);
            double direction = 1.0;
            if (bearing > 90.0) {
                direction = -1.0;
                bearing -= 180.0;
            } else if (bearing < -90.0) {
                direction = -1.0;
                bearing += 180.0;
            }
            double distance = ourPos.distanceTo(this.destination);
            navinfo = new Navigation(new Double(direction * distance), new Double(bearing));
            if (distance < 200.0 && Math.abs(bearing) > 45.0) {
                navinfo.setMaxVelocity(1.0 + distance / 28.0);
            } else {
                navinfo.setMaxVelocity(8.0);
            }
        } else if (this.navigator != null && this.nextStrategy != null) {
            this.navigator.setNavigationStrategy(this.nextStrategy);
            navinfo = this.nextStrategy.navigate();
        }
        return navinfo;
    }

    public boolean isDone() {
        return this.finished;
    }
}

