/*
 * Decompiled with CFR 0.152.
 */
package pedersen.opponent;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import pedersen.core.Foundation;
import pedersen.debug.Debug;
import pedersen.opponent.Target;
import pedersen.opponent.TargetBase;
import pedersen.opponent.TargetStandardImpl;
import pedersen.opponent.profile.TargetMovementChallengeImpl;
import pedersen.opponent.profile.TargetMovementFullThrottleImpl;
import pedersen.opponent.profile.TargetMovementGridImpl2;
import pedersen.opponent.profile.TargetMovementRambotDefenseImpl;
import pedersen.opponent.profile.TargetMovementRambotOffenseImpl;
import pedersen.opponent.profile.TargetMovementTangoImpl3;
import pedersen.opponent.profile.TargetMovementWaypointImpl1a;
import pedersen.opponent.profile.TargetMovementWaypointImpl1b;
import pedersen.opponent.profile.TargetMovementWaypointImpl2;
import pedersen.opponent.profile.TargetTargetingChallengeImpl;

public class TargetFactory {
    private static int targetCount = 0;
    public static final TargetFactory singleton = new TargetFactory();
    private final List ramOffenseTargets = new ArrayList();
    private final List ramDefenseTargets = new ArrayList();
    private final List waypoint1aTargets = new ArrayList();
    private final List waypoint1bTargets = new ArrayList();
    private final List waypoint2Targets = new ArrayList();
    private final List tango3Targets = new ArrayList();
    private final List fullThrottleTargets = new ArrayList();
    private final List gridTargets = new ArrayList();
    private final List targetingChallengeTargets = new ArrayList();
    private final List movementChallengeTargets = new ArrayList();

    private TargetFactory() {
        this.targetingChallengeTargets.add("cjm.Chalk 1.2TC");
        this.targetingChallengeTargets.add("cx.mini,Cigarete 1.31TC");
        this.targetingChallengeTargets.add("davidalves.net.DuelistMicro 1.22TC");
        this.targetingChallengeTargets.add("dft.Cyanide 1.80.bTC");
        this.targetingChallengeTargets.add("gh.GrubbmGrb 1.1.3TC");
        this.targetingChallengeTargets.add("kawigi.sbf.FloodMini 1.4TC");
        this.targetingChallengeTargets.add("pedersen.Butterfly 2.0");
        this.targetingChallengeTargets.add("pez.rumble.CassiusClay 1.9996bTC");
        this.targetingChallengeTargets.add("stefw.Tigger 0.0.23TC");
        this.targetingChallengeTargets.add("wiki.etc.RandomMovementBot 1.0");
        this.movementChallengeTargets.add("abc.tron3.Shadow 3.66MC");
        this.movementChallengeTargets.add("cjm.Che 1.2MC");
        this.movementChallengeTargets.add("kawigi.sbf.FloodHT 0.9.2MC");
        this.movementChallengeTargets.add("pez.rumble.CassiusClay 1.9996bMC");
        this.movementChallengeTargets.add("wiki.challenge.WaveSurfingChallengeBotA 1.0");
        this.movementChallengeTargets.add("wiki.challenge.WaveSurfingChallengeBotB 1.1");
        this.movementChallengeTargets.add("wiki.challenge.WaveSurfingChallengeBotC 1.0");
        this.ramDefenseTargets.add("bayen.UbaRamLT");
        this.ramDefenseTargets.add("bbo.RamboT");
        this.ramDefenseTargets.add("demetrix.nano.SledgeHammer");
        this.ramDefenseTargets.add("gh.micro.GrubbmThree");
        this.ramDefenseTargets.add("kc.micro.rammer.MaxRisk");
        this.ramDefenseTargets.add("mz.NanoDeath");
        this.ramDefenseTargets.add("pedersen.Banzai");
        this.ramDefenseTargets.add("pmc.SniperBot");
        this.ramDefenseTargets.add("radnor.RamRod");
        this.ramDefenseTargets.add("stelo.Lifestealer");
        this.ramDefenseTargets.add("wiki.micro.ARAMtocles");
        this.waypoint1aTargets.add("caimano.Furia_Ceca");
        this.waypoint1aTargets.add("cjk.Merkava 0.2.0");
        this.waypoint1aTargets.add("dans.Cinnamon");
        this.waypoint1aTargets.add("jcs.Autobot");
        this.waypoint1aTargets.add("kawigi.micro.Shiz");
        this.waypoint1aTargets.add("krillr.mega.Phyche 0.0.2");
        this.waypoint1aTargets.add("myl.micro.NekoNinja");
        this.waypoint1aTargets.add("repositorio.NanoStep");
        this.waypoint1aTargets.add("sgp.nano.FurryLeech");
        this.waypoint1bTargets.add("dcs.Eater_of_Worlds Mini 1.0");
        this.waypoint1bTargets.add("dks.MicroDanMK2");
        this.waypoint1bTargets.add("et.Predator");
        this.waypoint1bTargets.add("geep.mini.GPBotB");
        this.waypoint1bTargets.add("krillr.mega.Phyche 0.0.3");
        this.waypoint1bTargets.add("lrem.Spectre");
        this.waypoint1bTargets.add("myl.micro.Predator");
        this.waypoint1bTargets.add("myl.micro.Troodon");
        this.waypoint1bTargets.add("rz.SmallDevil");
        this.waypoint1bTargets.add("synnalagma.test.MiniNeural");
        this.waypoint1bTargets.add("tobe.mini.Charon");
        this.waypoint2Targets.add("pmc.SniperBot");
        this.waypoint2Targets.add("zen.Lindada");
        this.tango3Targets.add("alex.Diabolo");
        this.tango3Targets.add("amk.jointstrike.JointStrike");
        this.tango3Targets.add("amk.ShizzleStiX.ShizzleStiX");
        this.tango3Targets.add("bayen.UbaMicro");
        this.tango3Targets.add("bigpete.Stewie");
        this.tango3Targets.add("csm.NthGeneration");
        this.tango3Targets.add("deewiant.Anomaly");
        this.tango3Targets.add("dft.Freddie");
        this.tango3Targets.add("demetrix.nano.Neutrino");
        this.tango3Targets.add("dummy.micro.Sparrow");
        this.tango3Targets.add("fm.claire");
        this.tango3Targets.add("frag.FragBot");
        this.tango3Targets.add("franzor.Lizt");
        this.tango3Targets.add("gg.Wolverine");
        this.tango3Targets.add("hirataatsushi.Neo");
        this.tango3Targets.add("japs.Sjonniebot");
        this.tango3Targets.add("jaw.Mouse");
        this.tango3Targets.add("jaybot.adv.bots.JayBot");
        this.tango3Targets.add("joe.ADinosaur");
        this.tango3Targets.add("lion.Kresnanano");
        this.tango3Targets.add("lk.nano.Avesnar");
        this.tango3Targets.add("lorneswork.Predator");
        this.tango3Targets.add("md.November");
        this.tango3Targets.add("mld.DustBunny");
        this.tango3Targets.add("mrm.MightyMoose");
        this.tango3Targets.add("myl.nano.KomoriNinja");
        this.tango3Targets.add("mz.Adept 2.65");
        this.tango3Targets.add("mz.AdeptBSB 1.03");
        this.tango3Targets.add("mz.Movement");
        this.tango3Targets.add("mz.NanoGod");
        this.tango3Targets.add("ndn.DyslexicMonkey");
        this.tango3Targets.add("oa.weak.FlyMk1");
        this.tango3Targets.add("pe.minimelee.SandboxMiniMelee");
        this.tango3Targets.add("pez.nano.Icarus");
        this.tango3Targets.add("pfvicm.Sobieski");
        this.tango3Targets.add("pla.Memnoch");
        this.tango3Targets.add("pulsar.PulsarNano");
        this.tango3Targets.add("ratosh.Nobo");
        this.tango3Targets.add("rfj.Sunburn");
        this.tango3Targets.add("ruc.nano.Zealot");
        this.tango3Targets.add("rz.Artist");
        this.tango3Targets.add("sgp.MadHatter");
        this.tango3Targets.add("sigterm.Sigterm");
        this.tango3Targets.add("stelo.RamTrackSurfer");
        this.tango3Targets.add("stelo.Wang");
        this.tango3Targets.add("strider.Festis");
        this.tango3Targets.add("takeBot.SpinSpiral");
        this.tango3Targets.add("takeBot.WeavingWiggle");
        this.tango3Targets.add("taqho.taqbot");
        this.tango3Targets.add("toz.Gnome");
        this.tango3Targets.add("wiki.nano.DevilFISH");
        this.tango3Targets.add("wiki.nano.RaikoNano");
        this.fullThrottleTargets.add("davidalves.net.DuelistNano");
        this.fullThrottleTargets.add("dummy.micro.HummingBird");
        this.fullThrottleTargets.add("krillr.mini.JointStrike");
        this.fullThrottleTargets.add("non.mega.NaN");
        this.fullThrottleTargets.add("ntw.Sighup");
        this.fullThrottleTargets.add("ph.Thinker");
        this.fullThrottleTargets.add("vft.Hrist");
        this.gridTargets.add("asm.Statistas");
        this.gridTargets.add("bndl.LostLion");
        this.gridTargets.add("brainfade.Fallen");
        this.gridTargets.add("davidalves.net.DuelistMicro 1.22");
        this.gridTargets.add("davidalves.net.DuelistMicroMkII 1.1");
        this.gridTargets.add("dz.OthoMicro");
        this.gridTargets.add("mld.Moebius");
        this.gridTargets.add("non.mega.NoName");
        this.gridTargets.add("sgs.DogManSPE");
        this.gridTargets.add("strider.Mer");
        this.gridTargets.add("wiki.mini.BlackDestroyer");
    }

    public Target produce(String name, Foundation robot) {
        TargetBase target = null;
        boolean allowFullThrottle = true;
        boolean allowRamOffense = true;
        boolean allowRamDefense = true;
        boolean allowWaypoint1a = true;
        boolean allowWaypoint1b = true;
        boolean allowWaypoint2 = true;
        boolean allowTango3 = true;
        boolean allowGrid = true;
        if (target == null && TargetFactory.isInList(name, this.targetingChallengeTargets.iterator())) {
            target = new TargetTargetingChallengeImpl(name, robot);
        }
        if (target == null && TargetFactory.isInList(name, this.movementChallengeTargets.iterator())) {
            target = new TargetMovementChallengeImpl(name, robot);
        }
        if (target == null && allowRamOffense && TargetFactory.isInList(name, this.ramOffenseTargets.iterator())) {
            target = new TargetMovementRambotOffenseImpl(name, robot);
        }
        if (target == null && allowRamDefense && TargetFactory.isInList(name, this.ramDefenseTargets.iterator())) {
            target = new TargetMovementRambotDefenseImpl(name, robot);
        }
        if (target == null && allowWaypoint1a && TargetFactory.isInList(name, this.waypoint1aTargets.iterator())) {
            target = new TargetMovementWaypointImpl1a(name, robot);
        }
        if (target == null && allowWaypoint1b && TargetFactory.isInList(name, this.waypoint1bTargets.iterator())) {
            target = new TargetMovementWaypointImpl1b(name, robot);
        }
        if (target == null && allowWaypoint2 && TargetFactory.isInList(name, this.waypoint2Targets.iterator())) {
            target = new TargetMovementWaypointImpl2(name, robot);
        }
        if (target == null && allowTango3 && TargetFactory.isInList(name, this.tango3Targets.iterator())) {
            target = new TargetMovementTangoImpl3(name, robot);
        }
        if (target == null && allowFullThrottle && TargetFactory.isInList(name, this.fullThrottleTargets.iterator())) {
            target = new TargetMovementFullThrottleImpl(name, robot);
        }
        if (target == null && allowGrid && TargetFactory.isInList(name, this.gridTargets.iterator())) {
            target = new TargetMovementGridImpl2(name, robot);
        }
        if (target == null) {
            target = new TargetStandardImpl(name, robot);
        }
        ++targetCount;
        return target;
    }

    private static boolean isInList(String name, Iterator iterator) {
        boolean isInList = false;
        while (iterator.hasNext() && !isInList) {
            if (!name.contains((String)iterator.next())) continue;
            isInList = true;
        }
        return isInList;
    }

    public static void debug() {
        Debug.debug("Target Factory: produced " + targetCount + " targets.");
    }
}

