/*
 * Decompiled with CFR 0.152.
 */
package pedersen.physics;

import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import pedersen.core.Constraints;
import pedersen.physics.StaticPosition;
import pedersen.physics.StaticPositionImpl;

public class CircleFormula {
    private final double h;
    private final double k;
    private final double rSquared;

    public CircleFormula(StaticPosition center, double radius) {
        this.h = center.getX();
        this.k = center.getY();
        this.rSquared = radius * radius;
    }

    public Double getFunctionOfX(double x, boolean positive) {
        Double functionOfX = null;
        double xSquared = CircleFormula.square(x - this.h);
        if (xSquared <= this.rSquared) {
            double subsection = Math.sqrt(this.rSquared - xSquared);
            functionOfX = new Double(this.k + (positive ? subsection : -subsection));
        }
        return functionOfX;
    }

    public Double getFunctionOfY(double y, boolean positive) {
        Double functionOfY = null;
        double ySquared = CircleFormula.square(y - this.k);
        if (ySquared <= this.rSquared) {
            double subsection = Math.sqrt(this.rSquared - ySquared);
            functionOfY = new Double(this.h + (positive ? subsection : -subsection));
        }
        return functionOfY;
    }

    private static double square(double value) {
        return value * value;
    }

    public List getPointsOfIntersection(Rectangle2D.Double hitbox) {
        Double maxYnegX;
        Double maxYposX;
        Double minYnegX;
        Double minYposX;
        Double maxXnegY;
        Double maxXposY;
        Double minXnegY;
        ArrayList<StaticPositionImpl> pointsOfIntersection = new ArrayList<StaticPositionImpl>();
        double minX = hitbox.getMinX();
        double maxX = hitbox.getMaxX();
        double minY = hitbox.getMinY();
        double maxY = hitbox.getMaxY();
        Double minXposY = this.getFunctionOfX(minX, true);
        if (minXposY != null && Constraints.isInRange(minY, minXposY, maxY)) {
            pointsOfIntersection.add(new StaticPositionImpl(minX, minXposY));
        }
        if ((minXnegY = this.getFunctionOfX(minX, false)) != null && Constraints.isInRange(minY, minXnegY, maxY)) {
            pointsOfIntersection.add(new StaticPositionImpl(minX, minXnegY));
        }
        if ((maxXposY = this.getFunctionOfX(maxX, true)) != null && Constraints.isInRange(minY, maxXposY, maxY)) {
            pointsOfIntersection.add(new StaticPositionImpl(maxX, maxXposY));
        }
        if ((maxXnegY = this.getFunctionOfX(maxX, false)) != null && Constraints.isInRange(minY, maxXnegY, maxY)) {
            pointsOfIntersection.add(new StaticPositionImpl(maxX, maxXnegY));
        }
        if ((minYposX = this.getFunctionOfY(minY, true)) != null && Constraints.isInRange(minX, minYposX, maxX)) {
            pointsOfIntersection.add(new StaticPositionImpl(minYposX, minY));
        }
        if ((minYnegX = this.getFunctionOfY(minY, false)) != null && Constraints.isInRange(minX, minYnegX, maxX)) {
            pointsOfIntersection.add(new StaticPositionImpl(minYnegX, minY));
        }
        if ((maxYposX = this.getFunctionOfY(maxY, true)) != null && Constraints.isInRange(minX, maxYposX, maxX)) {
            pointsOfIntersection.add(new StaticPositionImpl(maxYposX, maxY));
        }
        if ((maxYnegX = this.getFunctionOfY(maxY, false)) != null && Constraints.isInRange(minX, maxYnegX, maxX)) {
            pointsOfIntersection.add(new StaticPositionImpl(maxYnegX, maxY));
        }
        return pointsOfIntersection;
    }
}

