/*
 * Decompiled with CFR 0.152.
 */
package pedersen.physics;

import pedersen.debug.Debug;
import pedersen.debug.Debuggable;
import pedersen.physics.StaticPosition;
import pedersen.physics.StaticPositionImpl;
import pedersen.physics.StaticVectorImpl;

public class SlopeFormula
implements Debuggable {
    private final double slope;
    private final double offset;

    public SlopeFormula(StaticPosition position, double heading) {
        StaticPositionImpl position2 = new StaticPositionImpl(position, new StaticVectorImpl(heading, 1.0));
        double deltaX = position2.getX() - position.getX();
        double deltaY = position2.getY() - position.getY();
        this.slope = deltaY / deltaX;
        this.offset = position.getY() - this.slope * position.getX();
    }

    public SlopeFormula(StaticPosition center, StaticPosition position) {
        double heading = center.getBearing(position) + 1.5707963267948966;
        StaticPositionImpl position2 = new StaticPositionImpl(position, new StaticVectorImpl(heading, 1.0));
        double deltaX = position2.getX() - position.getX();
        double deltaY = position2.getY() - position.getY();
        this.slope = deltaY / deltaX;
        this.offset = position.getY() - this.slope * position.getX();
    }

    public double getFunctionOfX(double x) {
        return this.slope * x + this.offset;
    }

    public StaticPosition getPositionForX(double x) {
        return new StaticPositionImpl(x, this.getFunctionOfX(x));
    }

    public double getFunctionOfY(double y) {
        double functionOfY = 0.0;
        if (this.slope != 0.0) {
            functionOfY = (y - this.offset) / this.slope;
        }
        return functionOfY;
    }

    public StaticPosition getPositionForY(double y) {
        return new StaticPositionImpl(this.getFunctionOfY(y), y);
    }

    public StaticPosition getPointOfIntercept(SlopeFormula other) {
        StaticPositionImpl pointOfIntercept = null;
        if (this.slope != other.slope) {
            double x = (other.offset - this.offset) / (this.slope - other.slope);
            double y = this.getFunctionOfX(x);
            pointOfIntercept = new StaticPositionImpl(x, y);
        }
        return pointOfIntercept;
    }

    public void debug() {
        Debug.debug("y = " + Debug.trim(this.slope) + "x + " + Debug.trim(this.offset));
    }
}

