/*
 * Decompiled with CFR 0.152.
 */
package pa3k;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import pa3k.Aiming;
import pa3k.AngleUtils;
import pa3k.BulletTracking;
import pa3k.CircleMoving;
import pa3k.Configuration;
import pa3k.Log;
import pa3k.Opponent;
import pa3k.OpponentCreator;
import pa3k.Position;
import pa3k.RobotModule;
import pa3k.SelfTracking;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.Robot;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class Tracking
extends RobotModule {
    protected Map<String, Opponent> opponents;
    protected SelfTracking selfTracking;
    protected Aiming selfAiming;
    protected Deque<BulletTracking> trackedBullets;
    protected Deque<BulletTracking> ownBullets;
    private Opponent scanningTarget;
    protected Opponent lastHitBy;
    private CircleMoving moving;
    protected OpponentCreator opponentCreator;
    private Configuration aimingConfiguration;
    private Configuration evasiveConfiguration;
    private boolean energyChange;

    public Tracking(AdvancedRobot advancedRobot, SelfTracking selfTracking, OpponentCreator opponentCreator) {
        super(advancedRobot);
        this.selfTracking = selfTracking;
        this.opponents = new TreeMap<String, Opponent>();
        this.trackedBullets = new LinkedList<BulletTracking>();
        this.ownBullets = new LinkedList<BulletTracking>();
        this.opponentCreator = opponentCreator;
        this.lastHitBy = null;
        this.aimingConfiguration = null;
        this.evasiveConfiguration = null;
        this.energyChange = false;
    }

    public void clearEnergyChange() {
        this.energyChange = false;
    }

    @Override
    public void init() {
    }

    protected void turnBulletTracking() {
        Object object;
        long l;
        long l2;
        BulletTracking bulletTracking = this.trackedBullets.peekFirst();
        if (bulletTracking != null) {
            l2 = this.robot.getTime();
            l = bulletTracking.getETA(new Position((Robot)this.robot)) - 1L;
            if (l + 1L <= l2) {
                bulletTracking.setEvaded();
            }
            if (l < l2 - 3L) {
                Log.log(3, "Opponent " + bulletTracking.getOwner() + " missed from " + bulletTracking.getSource());
                this.trackedBullets.removeFirst();
                bulletTracking.getOwner().bulletMissedMe(bulletTracking);
                object = bulletTracking.clone();
                try {
                    ((BulletTracking)object).setFiringAngle(((BulletTracking)object).getSource().getDirectionTo(this.selfTracking.getLastPosition((int)(this.robot.getTime() - l - 1L))));
                    ((BulletTracking)object).getOwner().bulletPossibleHitMe((BulletTracking)object);
                    Log.log(3, "  the correct aiming ration was: " + 100.0 * ((BulletTracking)object).getAimingRatio() + "%");
                    Log.paintArc(3, bulletTracking.getSource(), bulletTracking.getNegativeAngle(), AngleUtils.difference(bulletTracking.getPositiveAngle(), bulletTracking.getNegativeAngle()), 200.0, new Color(255, 100, 100, 30), 0);
                    Log.paintLine(3, ((BulletTracking)object).getSource(), ((BulletTracking)object).getFiringAngle(), new Color(255, 0, 0), 0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        l2 = this.robot.getTime();
        bulletTracking = this.ownBullets.peekFirst();
        if (bulletTracking != null && (l = bulletTracking.getETA(bulletTracking.getTargetOpponent().getLastPosition()) - 1L) < l2 - 3L) {
            object = null;
            try {
                object = bulletTracking.getTargetOpponent().getLastPosition(l);
            }
            catch (Exception exception) {
                // empty catch block
            }
            BulletTracking bulletTracking2 = bulletTracking.clone();
            bulletTracking2.setFiringAngle(bulletTracking.getSource().getDirectionTo((Position)object));
            double d = bulletTracking2.getAimingRatio();
            try {
                Log.log(3, "We missed " + bulletTracking.getTargetOpponent() + " at angle " + bulletTracking.getAimingRatio() + ", target was at " + d);
                Log.paintArc(3, bulletTracking.getSource(), bulletTracking.getNegativeAngle(), AngleUtils.difference(bulletTracking.getPositiveAngle(), bulletTracking.getNegativeAngle()), 200.0, new Color(255, 255, 255, 30), 0);
                Log.paintLine(3, bulletTracking.getSource(), bulletTracking.getFiringAngle(), new Color(0, 0, 0), 0);
                Log.paintLine(3, bulletTracking2.getSource(), bulletTracking2.getFiringAngle(), new Color(255, 255, 255), 0);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.ownBullets.removeFirst();
            bulletTracking.getTargetOpponent().bulletPossibleHit(bulletTracking2);
            bulletTracking.getTargetOpponent().bulletMiss(bulletTracking);
        }
        Iterator<BulletTracking> iterator = this.ownBullets.iterator();
        while (iterator.hasNext()) {
            iterator.next().paint(3, l2 + 1L);
        }
        iterator = this.trackedBullets.iterator();
        while (iterator.hasNext()) {
            iterator.next().paint(3, l2 + 1L);
        }
    }

    @Override
    public void turn() {
        if (this.scanningTarget != null) {
            if (this.scanningTarget.lastSeen(this.robot.getTime()) > 3L) {
                this.scanningTarget = null;
            } else {
                Position position = new Position((Robot)this.robot);
                double d = 0.0;
                d = position.getDirectionTo(this.scanningTarget.getLastPosition());
                double d2 = this.robot.getRadarHeadingRadians();
                if ((d = Utils.normalRelativeAngle((double)(d - d2))) > 0.0) {
                    this.robot.setTurnRadarRightRadians(1.5707963267948966);
                } else {
                    this.robot.setTurnRadarLeftRadians(1.5707963267948966);
                }
            }
        }
        if (this.scanningTarget == null) {
            this.robot.setTurnRadarRightRadians(1.5707963267948966);
        }
        this.turnBulletTracking();
    }

    public void bulletFired(BulletTracking bulletTracking, Opponent opponent) {
        this.energyChange = true;
        this.ownBullets.add(bulletTracking);
        bulletTracking.getTargetOpponent().firedAt(bulletTracking);
        if (this.aimingConfiguration != null) {
            this.aimingConfiguration.shot();
        }
    }

    public Opponent getByName(String string) {
        Log.log(4, "Looking up: '" + string + "'");
        Opponent opponent = this.opponents.get(string);
        if (opponent == null) {
            Log.log(2, "Not found, creating: '" + string + "'");
            opponent = this.opponentCreator.createOpponent(string, this.robot);
            this.opponents.put(string, opponent);
        }
        return opponent;
    }

    public void opponentScanned(ScannedRobotEvent scannedRobotEvent) {
        BulletTracking bulletTracking;
        Opponent opponent = this.getByName(scannedRobotEvent.getName());
        if (this.lastHitBy == null) {
            this.lastHitBy = opponent;
        }
        if ((bulletTracking = opponent.updateInfo(scannedRobotEvent, scannedRobotEvent.getBearingRadians() + this.robot.getHeadingRadians(), new Position((Robot)this.robot))) != null) {
            Log.log(3, "Energy drop detected at " + opponent + ": " + bulletTracking.getEnergy());
            if (this.evasiveConfiguration != null) {
                this.evasiveConfiguration.shot();
            }
            try {
                bulletTracking.setValues(opponent.getLastPosition(this.robot.getTime() - 1L), this.selfTracking, this, opponent);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.trackedBullets.add(bulletTracking);
        }
    }

    public void hitByBullet(HitByBulletEvent hitByBulletEvent) {
        Opponent opponent;
        this.energyChange = true;
        this.lastHitBy = opponent = this.getByName(hitByBulletEvent.getName());
        long l = this.robot.getTime();
        for (BulletTracking bulletTracking : this.trackedBullets) {
            long l2 = bulletTracking.getETA(new Position(hitByBulletEvent.getBullet()));
            Log.log(3, "Checking against bullet: " + bulletTracking);
            Log.log(3, "Computed ETA: " + l2 + ", actual time: " + hitByBulletEvent.getTime());
            if (bulletTracking.getOwner() != opponent || (int)((bulletTracking.getEnergy() + 0.005) * 100.0) != (int)((hitByBulletEvent.getPower() + 0.005) * 100.0) || l2 < l - 3L || l2 > l + 3L) continue;
            bulletTracking.setFiringAngle(hitByBulletEvent.getBullet().getHeadingRadians());
            Log.log(2, "Hit by bullet from " + opponent + " fired at " + bulletTracking.getTime() + " at " + bulletTracking.getSource());
            Log.log(3, "Random hit probability " + (int)(bulletTracking.getRandomHitProbability() * 100.0) + "%, aiming ratio " + (int)(bulletTracking.getAimingRatio() * 100.0) + "%");
            Log.paintArc(3, bulletTracking.getSource(), bulletTracking.getNegativeAngle(), AngleUtils.difference(bulletTracking.getPositiveAngle(), bulletTracking.getNegativeAngle()), 200.0, new Color(255, 100, 100, 30), 0);
            Log.paintLine(3, bulletTracking.getSource(), bulletTracking.getFiringAngle(), new Color(255, 0, 0), 0);
            this.trackedBullets.remove(bulletTracking);
            opponent.bulletHitMe(bulletTracking);
            this.moving.bulletHitMe(bulletTracking);
            return;
        }
        Log.log(2, "Hit by unidentified bullet");
    }

    public Object[] getTargets() {
        return this.opponents.values().toArray();
    }

    public void setOpponentOfInterest(Opponent opponent) {
        this.scanningTarget = opponent;
    }

    public void bulletHitBullet(BulletHitBulletEvent bulletHitBulletEvent) {
        Bullet bullet = bulletHitBulletEvent.getHitBullet();
        BulletTracking bulletTracking = BulletTracking.remove(this.ownBullets, bulletHitBulletEvent.getBullet());
        try {
            if (bulletTracking.getSource().distance(bullet.getX(), bullet.getY()) > bulletTracking.getSource().distance(bulletTracking.getTargetOpponent().getLastPosition(this.robot.getTime()))) {
                bulletTracking.getTargetOpponent().bulletMiss(bulletTracking);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Opponent opponent = this.getByName(bullet.getName());
        for (BulletTracking bulletTracking2 : this.trackedBullets) {
            long l = bulletTracking2.getETA(new Position(bullet.getX(), bullet.getY()));
            if (bulletTracking2.getOwner() != opponent || bulletTracking2.getEnergy() != bullet.getPower() || l < bulletHitBulletEvent.getTime() - 2L || l > bulletHitBulletEvent.getTime() + 2L) continue;
            Log.log(2, "Bullet shot down by " + opponent + " fired at " + bulletTracking2.getTime() + " at " + bulletTracking2.getSource());
            Log.log(3, "Random hit probability " + (int)(bulletTracking2.getRandomHitProbability() * 100.0) + "%");
            this.trackedBullets.remove(bulletTracking2);
            return;
        }
    }

    public void bulletMissed(BulletMissedEvent bulletMissedEvent) {
    }

    public void bulletHit(BulletHitEvent bulletHitEvent) {
        Bullet bullet = bulletHitEvent.getBullet();
        Opponent opponent = this.getByName(bullet.getVictim());
        BulletTracking bulletTracking = BulletTracking.remove(this.ownBullets, bullet);
        if (bulletTracking != null) {
            try {
                bulletTracking.setFiringAngle(bulletTracking.getSource().getDirectionTo(bulletTracking.getTargetOpponent().getLastPosition(this.robot.getTime() - 1L)));
            }
            catch (Exception exception) {
                // empty catch block
            }
            Log.paintArc(3, bulletTracking.getSource(), bulletTracking.getNegativeAngle(), AngleUtils.difference(bulletTracking.getPositiveAngle(), bulletTracking.getNegativeAngle()), 200.0, new Color(255, 255, 255, 30), 0);
            Log.paintLine(3, bulletTracking.getSource(), bulletTracking.getFiringAngle(), new Color(255, 255, 255), 0);
            opponent.bulletHit(bulletTracking);
            if (opponent != bulletTracking.getTargetOpponent()) {
                try {
                    if (bulletTracking.getTargetOpponent().getLastPosition(this.robot.getTime()).distance(bulletTracking.getSource()) < opponent.getLastPosition(this.robot.getTime()).distance(bulletTracking.getSource())) {
                        bulletTracking.getTargetOpponent().bulletMiss(bulletTracking);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        } else {
            Log.log(2, "Bullet hit with no tracking");
        }
    }

    public void robotDeath(RobotDeathEvent robotDeathEvent) {
        Opponent opponent = this.getByName(robotDeathEvent.getName());
        if (this.scanningTarget == opponent) {
            this.scanningTarget = null;
        }
        opponent.death();
    }

    @Override
    public void onPaint(Graphics2D graphics2D) {
    }

    public Deque<BulletTracking> getTrackedBullets() {
        return this.trackedBullets;
    }

    public Deque<BulletTracking> getOwnBullets() {
        return this.ownBullets;
    }

    public BulletTracking getClosestBullet() {
        Position position = new Position((Robot)this.robot);
        Iterator<BulletTracking> iterator = this.trackedBullets.iterator();
        BulletTracking bulletTracking = null;
        while (iterator.hasNext()) {
            BulletTracking bulletTracking2 = iterator.next();
            if (bulletTracking2.getEvaded() || bulletTracking != null && bulletTracking.getOwner() == bulletTracking2.getOwner()) continue;
            long l = bulletTracking2.getETA(position);
            if (bulletTracking != null && (bulletTracking.getETA(position) <= l || l >= this.robot.getTime())) continue;
            bulletTracking = bulletTracking2;
        }
        return bulletTracking;
    }

    public BulletTracking getClosestBullet(Opponent opponent) {
        Iterator<BulletTracking> iterator = this.trackedBullets.iterator();
        BulletTracking bulletTracking = null;
        while (iterator.hasNext()) {
            BulletTracking bulletTracking2 = iterator.next();
            if (bulletTracking2.getOwner() != opponent) continue;
            bulletTracking = bulletTracking2;
            break;
        }
        return bulletTracking;
    }

    public Opponent getLastHitBy() {
        return this.lastHitBy;
    }

    public void setMoving(CircleMoving circleMoving) {
        this.moving = circleMoving;
    }

    public void setAimingConfiguration(Configuration configuration) {
        this.aimingConfiguration = configuration;
    }

    public void setEvasiveConfiguration(Configuration configuration) {
        this.evasiveConfiguration = configuration;
    }

    public void onHitRobot(HitRobotEvent hitRobotEvent) {
        this.energyChange = true;
        this.getByName(hitRobotEvent.getName()).giveSolicitedEnergyLost(hitRobotEvent.getEnergy());
    }

    public void death(DeathEvent deathEvent) {
        for (Opponent opponent : this.opponents.values()) {
            opponent.getSelfAiming().dumpStats();
        }
    }

    public void injectBullet(BulletTracking bulletTracking) {
        this.ownBullets.add(bulletTracking);
    }
}

