/*
 * Decompiled with CFR 0.152.
 */
package dsekercioglu.mega.rMove.info;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import robocode.AdvancedRobot;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;

public class BotInfo {
    double energy;
    double oldEnergy;
    double deltaEnergy;
    ArrayList<Double> gunBearings = new ArrayList();
    ArrayList<Point2D.Double> locations = new ArrayList();
    final AdvancedRobot BOT;

    public BotInfo(AdvancedRobot advBot) {
        this.BOT = advBot;
    }

    public void run() {
        this.energy = 100.0;
        this.oldEnergy = 100.0;
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.gunBearings.add(this.BOT.getGunHeadingRadians());
        this.locations.add(new Point2D.Double(this.BOT.getX(), this.BOT.getY()));
        this.energy = this.BOT.getEnergy();
        this.deltaEnergy = this.oldEnergy - this.energy;
        this.oldEnergy = this.energy;
    }

    public void onHitRobot(HitRobotEvent e) {
        this.oldEnergy -= 0.6;
    }

    public void onHitByBullet(HitByBulletEvent e) {
        this.oldEnergy -= Rules.getBulletDamage((double)e.getPower());
    }

    public void onBulletHit(BulletHitEvent e) {
        this.oldEnergy += e.getBullet().getPower() * 3.0;
    }

    public boolean botFired() {
        return this.deltaEnergy > 0.099 && this.deltaEnergy < 3.001;
    }

    public double getGunHeading() {
        return this.gunBearings.get(this.gunBearings.size() - 2);
    }

    public double getFirePower() {
        return this.deltaEnergy;
    }

    public Point2D.Double getFireLocation() {
        return this.locations.get(this.locations.size() - 2);
    }
}

