/*
 * Decompiled with CFR 0.152.
 */
package DM.mega;

class BezierCalc {
    private final double[][] points = new double[4][2];
    private final double[] combinations = new double[4];

    BezierCalc() {
        for (int i = 0; i < this.combinations.length; ++i) {
            this.combinations[i] = BezierCalc.factorial(3) / (BezierCalc.factorial(i) * BezierCalc.factorial(3 - i));
        }
    }

    public void setPath(double d, double d2, double[] dArray) {
        this.points[0][0] = d;
        this.points[0][1] = d2;
        System.arraycopy(dArray, 0, this.points[1], 0, 2);
        System.arraycopy(dArray, 2, this.points[2], 0, 2);
        System.arraycopy(dArray, 4, this.points[3], 0, 2);
    }

    public double[] calc(double d) {
        return this.add(this.add(this.add(this.scale(this.points[0], this.getMult(0, d)), this.scale(this.points[1], this.getMult(1, d))), this.scale(this.points[2], this.getMult(2, d))), this.scale(this.points[3], this.getMult(3, d)));
    }

    public double getMult(int n, double d) {
        return this.combinations[n] * Math.pow(d, n) * Math.pow(1.0 - d, 3 - n);
    }

    public double[] scale(double[] dArray, double d) {
        dArray[0] = dArray[0] * d;
        dArray[1] = dArray[1] * d;
        return dArray;
    }

    public double[] add(double[] dArray, double[] dArray2) {
        dArray[0] = dArray[0] + dArray2[0];
        dArray[1] = dArray[1] + dArray2[1];
        return dArray;
    }

    private static double factorial(int n) {
        if (n <= 1) {
            return 1.0;
        }
        return (double)n * BezierCalc.factorial(n - 1);
    }
}

