/*
 * Decompiled with CFR 0.152.
 */
package DM.mega;

import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

class HammerToss {
    private final Point2D.Double source;
    final double groundHeading;
    final double mEA;
    final double velocity;
    final double mainGunFactor;
    final double flatGunFactor;
    final double minCrimp;
    final double maxCrimp;
    final double minFactor;
    final double maxFactor;
    final long fireTime;
    final int dir;
    final float distSeg;
    final float velSeg;
    final float accelSeg;
    final float wallSpaceSeg;
    final float revWallSeg;
    final float headSeg;
    final float bPowerSeg;
    final boolean isReal;
    private boolean isActive;

    HammerToss(double d, double d2, double d3, double d4, long l, int n, float f, float f2, float f3, float f4, float f5, float f6, float f7, boolean bl, double d5, double d6, double d7, double d8, double d9, double d10) {
        this.source = new Point2D.Double(d, d2);
        this.mEA = Math.asin(8.0 / d4);
        this.velocity = d4;
        this.groundHeading = d3;
        this.fireTime = l;
        this.dir = n;
        this.distSeg = f;
        this.velSeg = f2;
        this.accelSeg = f3;
        this.wallSpaceSeg = f4;
        this.revWallSeg = f5;
        this.headSeg = f6;
        this.bPowerSeg = f7;
        this.minCrimp = d7;
        this.maxCrimp = d8;
        this.minFactor = d9;
        this.maxFactor = d10;
        this.isActive = true;
        this.isReal = bl;
        this.mainGunFactor = d5;
        this.flatGunFactor = d6;
    }

    boolean checkHit(Point2D.Double double_, long l) {
        double d = (double)(l - this.fireTime) * this.velocity;
        return new Ellipse2D.Double(this.source.x - d, this.source.y - d, 2.0 * d, 2.0 * d).intersects(new Rectangle2D.Double(double_.x - 18.0, double_.y - 18.0, 36.0, 36.0));
    }

    double sourceX() {
        return this.source.x;
    }

    double sourceY() {
        return this.source.y;
    }

    void setInactive() {
        this.isActive = false;
    }

    boolean isActive() {
        return this.isActive;
    }

    double sourceDist(Point2D.Double double_) {
        return this.source.distance(double_);
    }

    public int hashCode() {
        return this.source.hashCode() ^ Double.valueOf(this.groundHeading).hashCode() ^ Double.valueOf(this.mEA).hashCode() ^ Double.valueOf(this.velocity).hashCode() ^ (int)this.fireTime ^ this.dir ^ Double.valueOf(this.wallSpaceSeg).hashCode() ^ Double.valueOf(this.revWallSeg).hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof HammerToss) {
            HammerToss hammerToss = (HammerToss)object;
            return this.fireTime == hammerToss.fireTime && Math.abs(this.velocity - hammerToss.velocity) <= 0.2 && this.distSeg == hammerToss.distSeg;
        }
        return false;
    }
}

