/*
 * Decompiled with CFR 0.152.
 */
package DM.mega;

import DM.mega.Polyline2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;

public class Polygon2D
implements Shape,
Cloneable,
Serializable {
    public int npoints;
    public double[] xpoints;
    public double[] ypoints;
    protected Rectangle2D bounds;
    private GeneralPath path;
    private GeneralPath closedPath;

    public Polygon2D() {
        this.xpoints = new double[4];
        this.ypoints = new double[4];
    }

    public Polygon2D(Rectangle2D rectangle2D) {
        if (rectangle2D == null) {
            throw new IndexOutOfBoundsException("null Rectangle");
        }
        this.npoints = 4;
        this.xpoints = new double[4];
        this.ypoints = new double[4];
        this.xpoints[0] = rectangle2D.getMinX();
        this.ypoints[0] = rectangle2D.getMinY();
        this.xpoints[1] = rectangle2D.getMaxX();
        this.ypoints[1] = rectangle2D.getMinY();
        this.xpoints[2] = rectangle2D.getMaxX();
        this.ypoints[2] = rectangle2D.getMaxY();
        this.xpoints[3] = rectangle2D.getMinX();
        this.ypoints[3] = rectangle2D.getMaxY();
        this.calculatePath();
    }

    public Polygon2D(Polygon polygon) {
        if (polygon == null) {
            throw new IndexOutOfBoundsException("null Polygon");
        }
        this.npoints = polygon.npoints;
        this.xpoints = new double[polygon.npoints];
        this.ypoints = new double[polygon.npoints];
        for (int i = 0; i < polygon.npoints; ++i) {
            this.xpoints[i] = polygon.xpoints[i];
            this.ypoints[i] = polygon.ypoints[i];
        }
        this.calculatePath();
    }

    public Polygon2D(double[] dArray, double[] dArray2, int n) {
        if (n > dArray.length || n > dArray2.length) {
            throw new IndexOutOfBoundsException("npoints > xpoints.length || npoints > ypoints.length");
        }
        this.npoints = n;
        this.xpoints = new double[n];
        this.ypoints = new double[n];
        System.arraycopy(dArray, 0, this.xpoints, 0, n);
        System.arraycopy(dArray2, 0, this.ypoints, 0, n);
        this.calculatePath();
    }

    public Polygon2D(int[] nArray, int[] nArray2, int n) {
        if (n > nArray.length || n > nArray2.length) {
            throw new IndexOutOfBoundsException("npoints > xpoints.length || npoints > ypoints.length");
        }
        this.npoints = n;
        this.xpoints = new double[n];
        this.ypoints = new double[n];
        for (int i = 0; i < n; ++i) {
            this.xpoints[i] = nArray[i];
            this.ypoints[i] = nArray2[i];
        }
        this.calculatePath();
    }

    public void reset() {
        this.npoints = 0;
        this.bounds = null;
        this.path = new GeneralPath();
        this.closedPath = null;
    }

    public Object clone() {
        Polygon2D polygon2D = new Polygon2D();
        for (int i = 0; i < this.npoints; ++i) {
            polygon2D.addPoint(this.xpoints[i], this.ypoints[i]);
        }
        return polygon2D;
    }

    private void calculatePath() {
        this.path = new GeneralPath();
        this.path.moveTo(this.xpoints[0], this.ypoints[0]);
        for (int i = 1; i < this.npoints; ++i) {
            this.path.lineTo(this.xpoints[i], this.ypoints[i]);
        }
        this.bounds = this.path.getBounds2D();
        this.closedPath = null;
    }

    private void updatePath(double d, double d2) {
        this.closedPath = null;
        if (this.path == null) {
            this.path = new GeneralPath(0);
            this.path.moveTo(d, d2);
            this.bounds = new Rectangle2D.Double(d, d2, 0.0, 0.0);
        } else {
            this.path.lineTo(d, d2);
            double d3 = this.bounds.getMaxX();
            double d4 = this.bounds.getMaxY();
            double d5 = this.bounds.getMinX();
            double d6 = this.bounds.getMinY();
            if (d < d5) {
                d5 = d;
            } else if (d > d3) {
                d3 = d;
            }
            if (d2 < d6) {
                d6 = d2;
            } else if (d2 > d4) {
                d4 = d2;
            }
            this.bounds = new Rectangle2D.Double(d5, d6, d3 - d5, d4 - d6);
        }
    }

    public Polyline2D getPolyline2D() {
        Polyline2D polyline2D = new Polyline2D(this.xpoints, this.ypoints, this.npoints);
        polyline2D.addPoint(this.xpoints[0], this.ypoints[0]);
        return polyline2D;
    }

    public Polygon getPolygon() {
        int[] nArray = new int[this.npoints];
        int[] nArray2 = new int[this.npoints];
        for (int i = 0; i < this.npoints; ++i) {
            nArray[i] = (int)this.xpoints[i];
            nArray2[i] = (int)this.ypoints[i];
        }
        return new Polygon(nArray, nArray2, this.npoints);
    }

    public void addPoint(Point2D point2D) {
        this.addPoint(point2D.getX(), point2D.getY());
    }

    public void addPoint(double d, double d2) {
        if (this.npoints == this.xpoints.length) {
            double[] dArray = new double[this.npoints * 2];
            System.arraycopy(this.xpoints, 0, dArray, 0, this.npoints);
            this.xpoints = dArray;
            dArray = new double[this.npoints * 2];
            System.arraycopy(this.ypoints, 0, dArray, 0, this.npoints);
            this.ypoints = dArray;
        }
        this.xpoints[this.npoints] = d;
        this.ypoints[this.npoints] = d2;
        ++this.npoints;
        this.updatePath(d, d2);
    }

    public boolean contains(Point point) {
        return this.contains(point.x, point.y);
    }

    public boolean contains(int n, int n2) {
        return this.contains((double)n, (double)n2);
    }

    @Override
    public Rectangle2D getBounds2D() {
        return this.bounds;
    }

    @Override
    public Rectangle getBounds() {
        if (this.bounds == null) {
            return null;
        }
        return this.bounds.getBounds();
    }

    @Override
    public boolean contains(double d, double d2) {
        if (this.npoints <= 2 || !this.bounds.contains(d, d2)) {
            return false;
        }
        this.updateComputingPath();
        return this.closedPath.contains(d, d2);
    }

    private void updateComputingPath() {
        if (this.npoints >= 1 && this.closedPath == null) {
            this.closedPath = (GeneralPath)this.path.clone();
            this.closedPath.closePath();
        }
    }

    @Override
    public boolean contains(Point2D point2D) {
        return this.contains(point2D.getX(), point2D.getY());
    }

    @Override
    public boolean intersects(double d, double d2, double d3, double d4) {
        if (this.npoints <= 0 || !this.bounds.intersects(d, d2, d3, d4)) {
            return false;
        }
        this.updateComputingPath();
        return this.closedPath.intersects(d, d2, d3, d4);
    }

    @Override
    public boolean intersects(Rectangle2D rectangle2D) {
        return this.intersects(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    @Override
    public boolean contains(double d, double d2, double d3, double d4) {
        if (this.npoints <= 0 || !this.bounds.intersects(d, d2, d3, d4)) {
            return false;
        }
        this.updateComputingPath();
        return this.closedPath.contains(d, d2, d3, d4);
    }

    @Override
    public boolean contains(Rectangle2D rectangle2D) {
        return this.contains(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    @Override
    public PathIterator getPathIterator(AffineTransform affineTransform) {
        this.updateComputingPath();
        if (this.closedPath == null) {
            return null;
        }
        return this.closedPath.getPathIterator(affineTransform);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform affineTransform, double d) {
        return this.getPathIterator(affineTransform);
    }
}

