/*
 * Decompiled with CFR 0.152.
 */
package rdt.Wraith.DangerPrediction;

import java.util.Random;
import rdt.Wraith.DangerPrediction.CachedVelocityData;
import rdt.Wraith.DangerPrediction.PredictedRobotState;
import rdt.Wraith.Utils.MathUtils;

public class MovementCommand {
    public static final int Forward = 0;
    public static final int ForwardLeft = 1;
    public static final int ForwardRight = 2;
    public static final int Back = 3;
    public static final int BackLeft = 4;
    public static final int BackRight = 5;
    public static final int NUM_COMMANDS = 6;
    private static Random _random = new Random();
    private static final double PIOver180 = Math.PI / 180;
    private static final double OneOverDecceleration = 0.5;
    private static final double[] TurnMultiplier = new double[]{0.0, -1.0, 1.0, 0.0, 1.0, -1.0};

    public static CachedVelocityData PredictCommandFast(int command, PredictedRobotState currentState, PredictedRobotState predictedState, CachedVelocityData currentVelocity) {
        double turnAngle = currentVelocity.MaxTurnDelta * TurnMultiplier[command];
        double newHeading = currentState.Heading + turnAngle;
        CachedVelocityData nextVelocity = currentVelocity.NextCommandResults[command];
        double newVelocity = nextVelocity.Velocity;
        double dX = MathUtils.FastSin(newHeading) * newVelocity;
        double dY = MathUtils.FastCos(newHeading) * newVelocity;
        predictedState.Heading = newHeading;
        predictedState.Velocity = newVelocity;
        predictedState.X = currentState.X + dX;
        predictedState.Y = currentState.Y + dY;
        return nextVelocity;
    }

    public static int Random() {
        return _random.nextInt(6);
    }

    public static double GetVelocity(int command, double currentVelocity) {
        double newVelocity = currentVelocity;
        switch (command) {
            case 0: 
            case 1: 
            case 2: {
                if (currentVelocity >= 0.0) {
                    newVelocity += 1.0;
                    newVelocity = Math.min(newVelocity, 8.0);
                    break;
                }
                newVelocity += MovementCommand.MaxDecel(currentVelocity);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                if (currentVelocity <= 0.0) {
                    newVelocity -= 1.0;
                    newVelocity = Math.max(newVelocity, -8.0);
                    break;
                }
                newVelocity -= MovementCommand.MaxDecel(currentVelocity);
                break;
            }
        }
        return newVelocity;
    }

    public static double MaxDecel(double velocity) {
        double decelTime = Math.abs(velocity) * 0.5;
        double accelTime = 1.0 - decelTime;
        return Math.min(1.0, decelTime) * 2.0 + Math.max(0.0, accelTime) * 1.0;
    }
}

