/*
 * Decompiled with CFR 0.152.
 */
package rdt.Wraith.Guns;

import java.util.ArrayList;
import java.util.Arrays;
import rdt.Wraith.Guns.BulletClassifier;
import rdt.Wraith.Guns.FiringData;
import rdt.Wraith.Guns.FiringSolution;
import rdt.Wraith.Guns.FiringSolutions;
import rdt.Wraith.Guns.Gun;
import rdt.Wraith.Guns.GunComparator;
import rdt.Wraith.Guns.GunImplementations.HeadOnTargetingGun;
import rdt.Wraith.Guns.GunImplementations.IterativeCircularWithWallStopping;
import rdt.Wraith.Guns.GunImplementations.IterativeLinearWithWallStopping;
import rdt.Wraith.Guns.IClassifiedBulletListener;
import rdt.Wraith.Guns.IGunManager;
import rdt.Wraith.IRobot;
import rdt.Wraith.MEA.BasicMEACalculator;
import rdt.Wraith.MEA.IMEACalculator;
import rdt.Wraith.MEA.MEA;
import rdt.Wraith.RobotSnapshots.RobotSnapshot;
import rdt.Wraith.RobotSnapshots.RobotSnapshots;
import rdt.Wraith.Stats.IStats;
import rdt.Wraith.Targeting.Target;
import rdt.Wraith.Utils.MathUtils;
import rdt.Wraith.Waves.IWaveEventHandler;
import rdt.Wraith.Waves.IWaveManager;
import rdt.Wraith.Waves.WaveData;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.HitByBulletEvent;

public class EnemyGunManager
implements IGunManager,
IWaveEventHandler,
IClassifiedBulletListener {
    private final BulletClassifier _bulletClassifier;
    private final IRobot _robot;
    private final ArrayList<Gun> _sortedGuns;
    private final GunComparator _gunComparator = new GunComparator();
    private final double _angleMatchRadians;
    private final long _firingTickOffset = -1L;
    private final FiringData _firingData = new FiringData();
    private final RobotSnapshots _targetSnapshots;
    private final FiringSolutions _firingSolutions = new FiringSolutions();
    private final MEA _mea = new MEA();
    private final IMEACalculator _meaCalculator;

    public EnemyGunManager(String ownerName, IRobot robot, RobotSnapshots robotSnapshots, IWaveManager enemyWaveManager, IStats stats) {
        this._robot = robot;
        this._targetSnapshots = robotSnapshots;
        String ownerNameAppended = "From " + ownerName;
        Gun[] guns = new Gun[]{new HeadOnTargetingGun(ownerNameAppended, robot, this._targetSnapshots, stats), new IterativeLinearWithWallStopping(ownerNameAppended, robot, this._targetSnapshots, stats), new IterativeCircularWithWallStopping(ownerNameAppended, robot, this._targetSnapshots, stats)};
        this._sortedGuns = new ArrayList(guns.length);
        this._sortedGuns.addAll(Arrays.asList(guns));
        guns[0].RegisterHit(0.0);
        guns[0].RegisterHit(0.0);
        guns[2].RegisterHit(0.0);
        this._bulletClassifier = new BulletClassifier(guns);
        this._angleMatchRadians = Math.toRadians(2.0);
        enemyWaveManager.RegisterWaveEventHandler(this);
        this.SortGunsByRecentHitRate();
        this._meaCalculator = new BasicMEACalculator();
    }

    @Override
    public int PredictAngles(double originX, double originY, long tickFired, double bulletVelocity, int maxAngles, double[] anglesOut) {
        this._firingSolutions.Reset();
        long firingTick = tickFired + -1L;
        RobotSnapshot targetAtFiringTick = this._targetSnapshots.Read(firingTick);
        long numTicksToTarget = (long)Math.ceil(targetAtFiringTick.DistanceToItsTarget / bulletVelocity);
        this._meaCalculator.CalculateMEA(originX, originY, targetAtFiringTick, numTicksToTarget, bulletVelocity, this._mea);
        assert (!(targetAtFiringTick.RotationDirectionToTarget >= 0.0) ? this._mea.ForwardRelative <= 0.0 : this._mea.ForwardRelative >= 0.0);
        assert (!(targetAtFiringTick.RotationDirectionToTarget >= 0.0) ? this._mea.RearRelative >= 0.0 : this._mea.RearRelative <= 0.0);
        this._firingData.SourceX = originX;
        this._firingData.SourceY = originY;
        this._firingData.TargetAtFiringTick = targetAtFiringTick;
        this._firingData.BulletVelocity = bulletVelocity;
        this._firingData.FiringTick = firingTick;
        this._firingData.MEA.ForwardRelative = this._mea.ForwardRelative;
        this._firingData.MEA.RearRelative = this._mea.RearRelative;
        this._firingData.TargetHeadOnAbsoluteBearingAtFiringTick = MathUtils.GetAngle(originX, originY, this._firingData.TargetAtFiringTick.LocationX, this._firingData.TargetAtFiringTick.LocationY);
        this._firingData.TargetWidthRadians = Math.atan(18.0 / this._firingData.TargetAtFiringTick.DistanceToItsTarget) * 2.0;
        int NumAngles = 0;
        for (int GunIndex = 0; GunIndex < this._sortedGuns.size(); ++GunIndex) {
            if (this._sortedGuns.get((int)GunIndex).TotalHits.Value() <= 0) continue;
            this._sortedGuns.get(GunIndex).GetFiringSolutions(this._firingData, this._firingSolutions);
        }
        for (int solutionIndex = 0; solutionIndex < Math.min(maxAngles, this._firingSolutions.GetNumSolutions()); ++solutionIndex) {
            FiringSolution solution = this._firingSolutions.GetSolution(solutionIndex);
            anglesOut[NumAngles] = solution.AbsoluteAngle;
            ++NumAngles;
        }
        return NumAngles;
    }

    @Override
    public void OnWaveGeneratedEvent() {
    }

    @Override
    public void OnHitByBulletWithWaveEvent(HitByBulletEvent eventData, WaveData wave) {
        Bullet bullet = eventData.getBullet();
        this.SetupFiringDataForWave(wave);
        this._bulletClassifier.Classify(bullet.getX(), bullet.getY(), this._firingData, this, this._angleMatchRadians);
    }

    @Override
    public void OnBulletHitBulletWithWaveEvent(BulletHitBulletEvent eventData, WaveData wave) {
        Bullet bullet = eventData.getBullet().getName().compareTo(this._robot.getName()) == 0 ? eventData.getHitBullet() : eventData.getBullet();
        this.SetupFiringDataForWave(wave);
        this._bulletClassifier.Classify(bullet.getX(), bullet.getY(), this._firingData, this, this._angleMatchRadians);
    }

    @Override
    public void OnWavePassed(WaveData wave, Target target) {
    }

    @Override
    public void OnBulletClassified(Gun gun, int gunIndex, boolean hit, double deltaAngle) {
        if (hit) {
            gun.RegisterHit(deltaAngle);
        } else {
            gun.RegisterMiss(deltaAngle);
        }
        this.SortGunsByRecentHitRate();
    }

    @Override
    public void NoClassificationAvailable() {
    }

    private void SetupFiringDataForWave(WaveData wave) {
        this._firingData.SourceX = wave.OriginX;
        this._firingData.SourceY = wave.OriginY;
        this._firingData.TargetAtFiringTick = this._targetSnapshots.Read(wave.ActivationTick);
        this._firingData.BulletVelocity = wave.Velocity;
        this._firingData.FiringTick = wave.ActivationTick;
        this._firingData.MEA.ForwardRelative = wave.MEA.ForwardRelative;
        this._firingData.MEA.RearRelative = wave.MEA.RearRelative;
        assert (!(this._firingData.TargetAtFiringTick.RotationDirectionToTarget >= 0.0) ? wave.MEA.ForwardRelative <= 0.0 : wave.MEA.ForwardRelative >= 0.0);
        assert (!(this._firingData.TargetAtFiringTick.RotationDirectionToTarget >= 0.0) ? wave.MEA.RearRelative >= 0.0 : wave.MEA.RearRelative <= 0.0);
        this._firingData.TargetHeadOnAbsoluteBearingAtFiringTick = MathUtils.GetAngle(wave.OriginX, wave.OriginY, this._firingData.TargetAtFiringTick.LocationX, this._firingData.TargetAtFiringTick.LocationY);
        this._firingData.TargetWidthRadians = Math.atan(18.0 / this._firingData.TargetAtFiringTick.DistanceToItsTarget) * 2.0;
    }

    private void SortGunsByRecentHitRate() {
        this._sortedGuns.sort(this._gunComparator);
    }
}

