/*
 * Decompiled with CFR 0.152.
 */
package rdt.Wraith.Waves;

import java.util.ArrayList;
import rdt.Wraith.IBulletHitBulletEventHandler;
import rdt.Wraith.IHitByBulletEventHandler;
import rdt.Wraith.IRobot;
import rdt.Wraith.MEA.BasicMEACalculator;
import rdt.Wraith.RobotSnapshots.RobotSnapshot;
import rdt.Wraith.Targeting.ITargeting;
import rdt.Wraith.Targeting.Target;
import rdt.Wraith.Waves.IWaveEventHandler;
import rdt.Wraith.Waves.WaveData;
import rdt.Wraith.Waves.WaveManagerBase;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.HitByBulletEvent;

public class EnemyWaveManager
extends WaveManagerBase
implements IHitByBulletEventHandler,
IBulletHitBulletEventHandler {
    private ITargeting _targeting;

    public EnemyWaveManager(IRobot robot, ITargeting targeting) {
        super(robot, 100, new BasicMEACalculator());
        this._targeting = targeting;
        this._robot.RegisterForEventHandling(this);
        this._robot.RegisterForEventHandling(this);
    }

    @Override
    public void Update() {
        ArrayList<Target> targets = this._targeting.GetTargets();
        for (int index = 0; index < targets.size(); ++index) {
            Target target = targets.get(index);
            if (!target.Alive || !target.Valid || target.LastTickFired != this._robot.getTime() - 1L) continue;
            RobotSnapshot snapshot = target.RobotSnapshots.Read(target.LastTickFired);
            this.FireWave(snapshot.LocationX, snapshot.LocationY, WaveData.eWaveType.Real, target.LastFiredBulletFirepower, snapshot.Tick, target, this._robot.ReadRobotSnapshot(snapshot.Tick - 1L));
        }
        super.Update();
    }

    @Override
    public void OnHitByBulletEvent(HitByBulletEvent eventData) {
        WaveData waveData = this.GetClosestActiveWave(eventData.getBullet().getX(), eventData.getBullet().getY());
        if (waveData == null) {
            return;
        }
        for (int index = 0; index < this._eventHandlers.size(); ++index) {
            ((IWaveEventHandler)this._eventHandlers.get(index)).OnHitByBulletWithWaveEvent(eventData, waveData);
        }
        this.RemoveActiveWave(waveData);
    }

    @Override
    public void OnBulletHitBulletEvent(BulletHitBulletEvent eventData) {
        Bullet enemyBullet = eventData.getBullet().getName().compareTo(this._robot.getName()) == 0 ? eventData.getHitBullet() : eventData.getBullet();
        WaveData waveData = this.GetClosestActiveWave(enemyBullet.getX(), enemyBullet.getY());
        if (waveData == null) {
            return;
        }
        for (int index = 0; index < this._eventHandlers.size(); ++index) {
            ((IWaveEventHandler)this._eventHandlers.get(index)).OnBulletHitBulletWithWaveEvent(eventData, waveData);
        }
        this.RemoveActiveWave(waveData);
    }
}

