/*
 * Decompiled with CFR 0.152.
 */
package rdm.drivers;

import java.awt.geom.Point2D;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import rdm.drivers.Driver;
import rdm.state.Bullet;
import rdm.state.entities.BodyState;
import rdm.state.entities.EnemyState;
import rdm.state.entities.InstantState;
import rdm.state.entities.SelfState;
import rdm.state.entities.WorldState;
import robocode.util.Utils;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\f\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000bH\u0002J\u001e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0016R$\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003@RX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\u0004R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lrdm/drivers/RandomDriver;", "Lrdm/drivers/Driver;", "worldCenter", "Ljava/awt/geom/Point2D;", "(Ljava/awt/geom/Point2D;)V", "<set-?>", "destination", "getDestination", "()Ljava/awt/geom/Point2D;", "setDestination", "previousEnemyEnergy", "", "buildSafePoint", "instant", "Lrdm/state/entities/InstantState;", "self", "Lrdm/state/entities/SelfState;", "absoluteBearing", "onScannedRobot", "", "enemyBullets", "", "Lrdm/state/Bullet;", "Commons"})
public final class RandomDriver
implements Driver {
    private double previousEnemyEnergy;
    @NotNull
    private Point2D destination;

    @Override
    @NotNull
    public Point2D getDestination() {
        return this.destination;
    }

    private void setDestination(Point2D point2D) {
        this.destination = point2D;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onScannedRobot(@NotNull InstantState instant, @NotNull List<Bullet> enemyBullets) {
        boolean movementComplete;
        void self;
        Intrinsics.checkParameterIsNotNull(instant, "instant");
        Intrinsics.checkParameterIsNotNull(enemyBullets, "enemyBullets");
        InstantState instantState = instant;
        SelfState selfState = instantState.component2();
        EnemyState enemy = instantState.component3();
        void var6_6 = self;
        BodyState body = var6_6.component3();
        double enemyEnergyDrop = this.previousEnemyEnergy - enemy.getEnergy();
        this.previousEnemyEnergy = enemy.getEnergy();
        boolean shotDetected = enemyEnergyDrop > 0.0 && enemyEnergyDrop <= 3.0;
        boolean bl = movementComplete = body.getDistanceRemaining() == 0.0;
        if (shotDetected || movementComplete) {
            this.setDestination(this.buildSafePoint(instant));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Point2D buildSafePoint(InstantState instant) {
        double distance2;
        void world;
        void self;
        InstantState instantState = instant;
        WorldState worldState = instantState.component1();
        SelfState selfState = instantState.component2();
        EnemyState enemy = instantState.component3();
        void var6_6 = self;
        BodyState body = var6_6.component3();
        double absoluteBearing = body.getHeading() + enemy.getBearing();
        Point2D point1 = this.buildSafePoint((SelfState)self, absoluteBearing);
        Point2D point2 = this.buildSafePoint((SelfState)self, absoluteBearing);
        double halfBattleFieldWidth = world.getWidth() / (double)2;
        double halfBattleFieldHeight = world.getHeight() / (double)2;
        double distance1 = Math.sqrt(Math.pow(point1.getX() - halfBattleFieldWidth, 2.0) + Math.pow(point1.getY() - halfBattleFieldHeight, 2.0));
        return distance1 < (distance2 = Math.sqrt(Math.pow(point2.getX() - halfBattleFieldWidth, 2.0) + Math.pow(point2.getY() - halfBattleFieldHeight, 2.0))) ? point1 : point2;
    }

    private final Point2D buildSafePoint(SelfState self, double absoluteBearing) {
        double safeAngle = Math.toRadians(absoluteBearing - (double)90);
        int distance = 50 + Utils.getRandom().nextInt(200);
        int safeDistance = Utils.getRandom().nextBoolean() ? distance : -distance;
        double relativeX = (double)safeDistance * Math.sin(safeAngle);
        double relativeY = (double)safeDistance * Math.cos(safeAngle);
        double rawTargetX = self.getBody().getPosition().getX() + relativeX;
        double targetX = Math.max(50.0, Math.min(750.0, rawTargetX));
        double rawTargetY = self.getBody().getPosition().getY() + relativeY;
        double targetY = Math.max(50.0, Math.min(550.0, rawTargetY));
        return new Point2D.Double(targetX, targetY);
    }

    public RandomDriver(@NotNull Point2D worldCenter) {
        Intrinsics.checkParameterIsNotNull(worldCenter, "worldCenter");
        this.previousEnemyEnergy = 100.0;
        this.destination = worldCenter;
    }
}

