/*
 * Decompiled with CFR 0.152.
 */
package lechu;

import robocode.Rules;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class RobotSimulator {
    private int fieldWidth;
    private int fieldHeight;
    private int[] decelerator;
    private double x;
    private double y;
    private double heading;
    private double speed;
    double destinationTurn;
    double destinationMove;
    double predictedX;
    double predictedY;
    double predictedSpeed;
    double predictedHeading;

    public void InitRobot(double x, double y, double heading, double speed) {
        this.x = x;
        this.y = y;
        this.heading = heading;
        this.speed = speed;
    }

    public void AdditionalSettings(double destTurn, double destMove) {
        this.destinationTurn = destTurn;
        this.destinationMove = destMove;
    }

    public void Reset() {
        this.predictedX = this.x;
        this.predictedY = this.y;
        this.predictedHeading = this.heading;
        this.predictedSpeed = this.speed;
    }

    public void SimulateTime() {
        double turn = this.destinationTurn;
        double limit = Rules.getTurnRateRadians((double)Math.abs(this.predictedSpeed));
        if (turn > limit) {
            turn = limit;
        }
        if (turn < -limit) {
            turn = -limit;
        }
        this.predictedHeading += turn;
        this.destinationTurn -= turn;
        if (this.destinationMove == 0.0) {
            this.predictedSpeed = 0.0;
            return;
        }
        if (this.destinationMove > 0.0) {
            this.predictedSpeed = this.destinationMove <= 19.0 ? (double)this.decelerator[(int)this.destinationMove] : (this.predictedSpeed < 0.0 ? (this.predictedSpeed += (double)2) : (this.predictedSpeed += 1.0));
            if (this.predictedSpeed > 8.0) {
                this.predictedSpeed = 8.0;
            }
        }
        if (this.destinationMove < 0.0) {
            this.predictedSpeed = this.destinationMove >= -19.0 ? (double)(-this.decelerator[-((int)this.destinationMove)]) : (this.predictedSpeed > 0.0 ? (this.predictedSpeed -= (double)2) : (this.predictedSpeed -= 1.0));
            if (this.predictedSpeed < -8.0) {
                this.predictedSpeed = -8.0;
            }
        }
        this.destinationMove -= this.predictedSpeed;
        this.predictedX += Math.sin(this.predictedHeading) * this.predictedSpeed;
        this.predictedY += Math.cos(this.predictedHeading) * this.predictedSpeed;
    }

    public boolean NextTime() {
        this.x += Math.sin(this.heading) * this.speed;
        this.y += Math.cos(this.heading) * this.speed;
        boolean bl = false;
        if (this.x > 0.0 && this.x < (double)this.fieldWidth && this.y > 0.0 && this.y < (double)this.fieldHeight) {
            bl = true;
        }
        return bl;
    }

    private final /* synthetic */ void this() {
        int[] nArray = new int[20];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 2;
        nArray[4] = 3;
        nArray[5] = 3;
        nArray[6] = 4;
        nArray[7] = 4;
        nArray[8] = 4;
        nArray[9] = 5;
        nArray[10] = 5;
        nArray[11] = 5;
        nArray[12] = 6;
        nArray[13] = 6;
        nArray[14] = 6;
        nArray[15] = 6;
        nArray[16] = 7;
        nArray[17] = 7;
        nArray[18] = 7;
        nArray[19] = 7;
        this.decelerator = nArray;
    }

    public RobotSimulator(int fieldWidth, int fieldHeight) {
        this.this();
        this.fieldWidth = fieldWidth;
        this.fieldHeight = fieldHeight;
    }
}

