/*
 * Decompiled with CFR 0.152.
 */
package kid.info;

import java.io.PrintStream;
import kid.info.GunInfo;
import kid.utils.Utils;
import robocode.AdvancedRobot;
import robocode.RobocodeFileOutputStream;
import robocode.Robot;

public class RadarInfo
extends GunInfo {
    private static final long serialVersionUID = 5648067665876157986L;
    public static final double RADAR_TURN_RATE = 45.0;
    public static final double RADAR_SCAN_LENGTH = 1200.0;

    public RadarInfo(Robot myRobot) {
        super(myRobot);
        this.init(myRobot);
    }

    protected RadarInfo(RadarInfo myRobot) {
        super(myRobot);
        this.init(myRobot.robot);
    }

    private void init(Robot myRobot) {
        this.robot = myRobot;
    }

    @Override
    public double getHeading() {
        return this.robot.getRadarHeading();
    }

    @Override
    public double getTurnRemaining() {
        if (this.robot instanceof AdvancedRobot) {
            AdvancedRobot myRobot = (AdvancedRobot)this.robot;
            return myRobot.getRadarTurnRemaining();
        }
        return 0.0;
    }

    @Override
    public int getTurningSign() {
        return this.getTurnRemaining() == 0.0 ? 0 : Utils.sign(this.getTurnRemaining());
    }

    @Override
    public void print(PrintStream console) {
    }

    @Override
    public void print(RobocodeFileOutputStream output) {
    }

    @Override
    public Object clone() {
        return new RadarInfo(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof RadarInfo) {
            RadarInfo robot = (RadarInfo)obj;
            return robot.robot.getName().equals(this.robot.getName());
        }
        return false;
    }

    @Override
    public String toString() {
        return new String();
    }

    @Override
    protected void finalize() {
        this.robot = null;
    }
}

