/*
 * Decompiled with CFR 0.152.
 */
package jbot.tracer.techniques;

import java.awt.Color;
import java.util.Vector;
import jbot.Inherit;
import jbot.Rabbit2;
import jbot.tracer.Ray;
import jbot.tracer.Target;
import jbot.tracer.Tracer;
import jbot.tracer.Wave;
import jbot.tracer.techniques.TracerTechnique;
import jbot.util.Vector2;
import robocode.Rules;

public class AvgAngleTechnique
extends TracerTechnique {
    public static final double FACTOR_GAIN_RATE = 0.6;
    public static final double MIN_FACTOR = 0.0;
    public static final double MAX_FACTOR = 1.0;
    public static final int ORBIAVGV_SEGMENTS = 9;
    public static final int ORBIABSV_SEGMENTS = 4;
    public static final double TIMEDIST = 300.0 / Rules.getBulletSpeed((double)1.99999);
    double[][] mFactors = null;
    protected double mRecentMaxKDAngle = 0.0;
    protected double mRecentMaxRDAngle = 0.0;
    Vector<Integer> mRecentFactorIndices = new Vector();

    public Inherit.Container collectData() {
        TechniqueContainer o = new TechniqueContainer(this);
        o.mSavedFactorDimensions = new Vector();
        o.mSavedFactorDimensions.add(9);
        o.mSavedFactorDimensions.add(4);
        o.mSavedFactors = (double[][])this.mFactors.clone();
        return o;
    }

    public boolean extractData(Inherit.Container io) {
        TechniqueContainer o = (TechniqueContainer)io;
        if (o.mSavedFactorDimensions.get(0) == 9 && o.mSavedFactorDimensions.get(1) == 4) {
            this.mFactors = (double[][])o.mSavedFactors.clone();
            return true;
        }
        return false;
    }

    public AvgAngleTechnique(String techName, Rabbit2 bot, Target self, Target target, double initialEfficient, double learnFactor) {
        super(techName, bot, self, target, initialEfficient, learnFactor);
        this.mColor = new Color(255, 150, 150, 255);
        TechniqueContainer o = (TechniqueContainer)this.mBot.getInherit().getContainerBy(this.getName());
        if (o == null || !this.extractData(o)) {
            this.mFactors = new double[9][4];
            int ov = 0;
            while (ov < 9) {
                int oa = 0;
                while (oa < 4) {
                    this.mFactors[ov][oa] = 0.75;
                    ++oa;
                }
                ++ov;
            }
        }
    }

    protected void frameLogic(double deltaTime) {
        double distance = this.mTarget.getRelativePos().getLength();
        double timedist_diff = Math.abs(distance / Rules.getBulletSpeed((double)1.99999) - TIMEDIST);
        this.setEfficient((TIMEDIST - timedist_diff / 2.0) / TIMEDIST);
    }

    public static double normalFactor(double factor) {
        if (factor < 0.0) {
            factor = 0.0;
        } else if (factor > 1.0) {
            factor = 1.0;
        }
        return factor;
    }

    public static int orbitalAvgVelToIndex(double orbiVel) {
        return (int)Math.round((orbiVel + 8.0) * 0.5);
    }

    public static int orbitalAbsVelToIndex(double orbiVel) {
        return (int)Math.round(orbiVel * 0.375);
    }

    public static double factorToHeading(double factor, double maxFEAngle, double maxBEAngle) {
        Vector2 v1 = new Vector2(maxFEAngle);
        Vector2 v2 = new Vector2(maxBEAngle);
        double f = factor;
        v1.multiply(f);
        v2.multiply(1.0 - f);
        return v1.add(v2).getAngle();
    }

    public static double headingToFactor(double heading, double maxFEAngle, double maxBEAngle) {
        Vector2 v1 = new Vector2(maxFEAngle);
        Vector2 v2 = new Vector2(maxBEAngle);
        Vector2 va = new Vector2(heading);
        va.sub(v2);
        v1.sub(v2);
        return AvgAngleTechnique.normalFactor(va.getLength() / v1.getLength());
    }

    public void addEstimatedRay(Wave w) {
        Vector2 direction = new Vector2(this.getShotAngleFor(w.getShotTime(), w.getShotPos(), w.getPower()));
        w.addRay(new RayEx(this, direction, this.getHitProbability(w.getDistToTarget()), this.mRecentMaxKDAngle, this.mRecentMaxRDAngle, this.mRecentFactorIndices));
    }

    public double getShotAngleFor(long shootTime, Vector2 shootPos, double shootPower) {
        double absOrbiVel;
        Target.Data target = this.mTarget.getHistoryAt(shootTime);
        Vector2 distance = target.getPosition().sub(shootPos);
        double timeDist = Math.ceil(distance.getLength() / Rules.getBulletSpeed((double)shootPower));
        Vector2 smoothVel = target.getVelocity();
        if (this.mTarget.getHistoryEntriesBefore(shootTime) >= 4) {
            int i = 1;
            while (i < 4) {
                smoothVel.add(this.mTarget.getHistoryAt(shootTime - (long)i).getVelocity());
                ++i;
            }
            smoothVel.multiply(0.25);
        }
        if (smoothVel.getLength() > 0.05) {
            double angle = distance.getAngleTo(smoothVel);
            Vector2 velocity = Vector2.UP.clone().rotate(angle);
            velocity.multiply(8.0);
            absOrbiVel = Math.abs(velocity.getX());
        } else {
            absOrbiVel = 0.0;
        }
        int iterations = (int)timeDist;
        int historyEntries = this.mTarget.getHistoryEntriesBefore(shootTime);
        if (iterations > historyEntries) {
            iterations = historyEntries;
        }
        Vector2 avgVel = new Vector2();
        int i = 0;
        while (i < iterations) {
            avgVel.add(this.mTarget.getHistoryAt(shootTime - (long)i).getVelocity());
            ++i;
        }
        avgVel.multiply(1.0 / (double)iterations);
        double avgOrbiVel = 0.0;
        if (avgVel.getLength() > 0.05) {
            double angle = distance.getAngleTo(avgVel);
            Vector2 velocity = Vector2.UP.clone().rotate(angle);
            velocity.multiply(8.0);
            avgOrbiVel = Math.abs(velocity.getX()) * Math.signum(target.getSpeed());
        } else {
            avgOrbiVel = 0.0;
        }
        int avgOrbiVelIndex = AvgAngleTechnique.orbitalAvgVelToIndex(avgOrbiVel);
        int absOrbiVelIndex = AvgAngleTechnique.orbitalAbsVelToIndex(absOrbiVel);
        double factor = this.mFactors[avgOrbiVelIndex][absOrbiVelIndex];
        double maxFEAngle = Tracer.getMaxKeepDirAngle(shootPos.clone(), this.mTarget, shootPower);
        double maxBEAngle = Tracer.getMaxReverseDirAngle(shootPos.clone(), this.mTarget, shootPower);
        double shootAngle = AvgAngleTechnique.factorToHeading(factor, maxFEAngle, maxBEAngle);
        this.mRecentFactorIndices.clear();
        this.mRecentFactorIndices.add(avgOrbiVelIndex);
        this.mRecentFactorIndices.add(absOrbiVelIndex);
        this.mRecentMaxKDAngle = maxFEAngle;
        this.mRecentMaxRDAngle = maxBEAngle;
        return shootAngle;
    }

    public void selfLearn(Wave wave, Ray ray, double aimError) {
        double gain = 0.6;
        if (!wave.isRealBullet()) {
            gain *= 0.001;
        }
        if (wave.getTraveledDistance() < 100.0) {
            gain = Math.pow(wave.getTraveledDistance() / 100.0, 2.0) * gain;
        }
        gain *= this.getEfficient();
        RayEx rex = (RayEx)ray;
        double angle = rex.getDirection().rotate(-aimError).getAngle();
        double factor = AvgAngleTechnique.headingToFactor(angle, rex.mMaxKeepDirAngle, rex.mMaxReverseDirAngle);
        int i = rex.mFactorIndices.get(0);
        int j = rex.mFactorIndices.get(1);
        this.mFactors[i][j] = this.mFactors[i][j] * (1.0 - gain) + factor * gain;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RayEx
    extends Ray {
        double mMaxKeepDirAngle;
        double mMaxReverseDirAngle;
        Vector<Integer> mFactorIndices;

        public RayEx(TracerTechnique technique, Vector2 direction, double probability, double maxForwardAngle, double maxBackwardAngle, Vector<Integer> factorIndices) {
            super(technique, direction, probability);
            this.mMaxKeepDirAngle = maxForwardAngle;
            this.mMaxReverseDirAngle = maxBackwardAngle;
            this.mFactorIndices = factorIndices;
        }
    }

    protected static class TechniqueContainer
    extends Inherit.Container {
        private static final long serialVersionUID = 2014755553225475142L;
        Vector<Integer> mSavedFactorDimensions;
        double[][] mSavedFactors;

        protected TechniqueContainer(TracerTechnique t) {
            super(t.getName());
        }
    }
}

