/*
 * Decompiled with CFR 0.152.
 */
package TNT;

import TNT.AbstractMovementClass;
import TNT.EnemyEvasionStrategy;
import TNT.EnemyFiredListener;
import TNT.FightingStrategy;
import TNT.Recon;
import TNT.ReconCollection;
import TNT.TNT;
import TNT.TNTMath;
import robocode.HitRobotEvent;

class SingleMovementStrategy
extends AbstractMovementClass
implements EnemyFiredListener {
    private static final long RUNNING_DISTANCE = 150L;
    private Recon m_currentTarget = null;
    double moveAlternator = 1.0;

    public void move() {
        ReconCollection col;
        this.m_currentTarget = ((FightingStrategy)this.m_owner.m_fightManager.getStrategy()).getTarget();
        ReconCollection reconCollection = col = this.m_currentTarget != null ? (ReconCollection)TNT.m_scannedInformation.get(this.m_currentTarget.getName()) : null;
        if (this.m_currentTarget != null) {
            if (this.m_owner.m_direction == -1) {
                this.m_owner.setTurnRightRadians(TNTMath.normalRelativeAngle(TNTMath.getAngleToXYCoord(this.m_currentTarget.getX(), this.m_currentTarget.getY(), this.m_owner) - 1.5707963267948966));
            } else {
                this.m_owner.setTurnRightRadians(TNTMath.normalRelativeAngle(TNTMath.getAngleToXYCoord(this.m_currentTarget.getX(), this.m_currentTarget.getY(), this.m_owner) + 1.5707963267948966));
            }
        } else if (this.m_owner.getTurnRemaining() == 0.0) {
            if (TNT.random.nextBoolean()) {
                this.m_owner.setTurnRightRadians(Math.PI * 6);
                this.m_owner.setAhead(300.0);
            } else {
                this.m_owner.setTurnLeftRadians(Math.PI * 6);
                this.m_owner.setAhead(300.0);
            }
        }
        if (this.m_owner.getDistanceRemaining() == 0.0 && this.m_owner.getVelocity() == 0.0) {
            this.m_owner.setAhead(300.0);
        }
    }

    public void enemyFired(Recon in_enemy) {
        if (this.m_currentTarget != null && this.m_currentTarget.getName().equals(in_enemy.getName()) && Math.abs(this.m_owner.getVelocity()) == 8.0) {
            if (TNT.random.nextBoolean()) {
                this.m_owner.reverseDirection();
            } else {
                this.m_owner.setAhead(0.0);
            }
        }
    }

    public void gotCollision(HitRobotEvent event) {
        ReconCollection col = (ReconCollection)TNT.m_scannedInformation.get(event.getName());
        if (col != null && col.isCurrent()) {
            this.m_owner.m_moveManager.setStrategy(new EnemyEvasionStrategy(this.m_owner, col.get(0)));
        } else {
            this.m_owner.reverseDirection();
        }
    }

    public boolean shouldUseStrategy() {
        return this.m_owner.getOthers() == 1;
    }

    public boolean expiredStrategy() {
        return !this.shouldUseStrategy();
    }

    public SingleMovementStrategy(TNT in_owner) {
        super(in_owner);
        ReconCollection.setEnemyFireListener(this);
    }
}

