/*
 * Decompiled with CFR 0.152.
 */
package suzushin7.nano;

import robocode.AdvancedRobot;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class Galaxy02
extends AdvancedRobot {
    public static final double BULLET_POWER = 1.5;

    public void run() {
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustRadarForRobotTurn(true);
        while (true) {
            if (this.getRadarTurnRemaining() == 0.0) {
                this.setTurnRadarRight(360.0);
            }
            this.execute();
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        double absBearing = this.getHeadingRadians() + e.getBearingRadians();
        this.setTurnRadarRightRadians(2.0 * Utils.normalRelativeAngle((double)(absBearing - this.getRadarHeadingRadians())));
        this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(absBearing + Math.asin(e.getVelocity() * Math.sin(e.getHeadingRadians() - absBearing) / Rules.getBulletSpeed((double)1.5)) - this.getGunHeadingRadians())));
        if (this.getGunHeat() == 0.0 && Math.abs(this.getGunTurnRemaining()) < 20.0) {
            this.setFire(1.5);
        }
        double ex = this.getX() + e.getDistance() * Math.sin(absBearing);
        double ey = this.getY() + e.getDistance() * Math.cos(absBearing);
        double tx = this.getBattleFieldWidth() - ex;
        double ty = this.getBattleFieldHeight() - ey;
        double dx = tx - this.getX();
        double dy = ty - this.getY();
        this.setTurnRightRadians(Utils.normalRelativeAngle((double)(Math.atan2(dx, dy) - this.getHeadingRadians())));
        this.setAhead(Math.sqrt(dx * dx + dy * dy));
    }
}

