/*
 * Decompiled with CFR 0.152.
 */
package rdt.AgentSmith.Movement.DangerPrediction;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import rdt.AgentSmith.AgentSmith;
import rdt.AgentSmith.Movement.DangerPrediction.DangerPredictionState;
import rdt.AgentSmith.Movement.DangerPrediction.DangerPredictionTreeNode;
import rdt.AgentSmith.Movement.DangerPrediction.MovementCommand;
import rdt.AgentSmith.Movement.DangerPrediction.NodePool;
import rdt.AgentSmith.Movement.EnemyWaveManager;
import rdt.RobotData.RobotDataSnapshot;
import rdt.Utils.RuleUtils;
import rdt.Waves.WaveData;

public class DangerPredictionTree {
    private static double PreferredMinDistanceToTarget = 200.0;
    private static double PreferredMinDistanceToTargetSq = PreferredMinDistanceToTarget * PreferredMinDistanceToTarget;
    private DangerPredictionTreeNode _rootNode;
    private ArrayList<DangerPredictionTreeNode> _nodeList = new ArrayList();
    private MovementCommand _movementCommand = new MovementCommand();
    private ArrayList<DangerPredictionTreeNode> _chosenMovement = new ArrayList();
    private NodePool _nodePool;
    private EnemyWaveManager _enemyWaveManager;

    public DangerPredictionTree(EnemyWaveManager enemyWaveManager) {
        this._enemyWaveManager = enemyWaveManager;
        this._nodePool = new NodePool(10500);
    }

    public void PreBuildTree() {
        this._nodePool.ResetPool();
        this._nodeList.clear();
        this._rootNode = this._nodePool.TakeFromPool();
        this._rootNode.NodeDepth = 0;
        this._rootNode.TotalDeltaTime = 0;
        this._rootNode.Parent = null;
        this._chosenMovement.clear();
    }

    public void AddCommandList(ArrayList<MovementCommand.eCommand> commandList) {
        DangerPredictionTreeNode currentNode = this._rootNode;
        int commandIndex = 0;
        while (commandIndex < commandList.size()) {
            MovementCommand.eCommand command = commandList.get(commandIndex);
            int childIndex = command.ordinal();
            DangerPredictionTreeNode childNode = currentNode.Children[childIndex];
            if (childNode != null) {
                currentNode = childNode;
            } else {
                childNode = this._nodePool.TakeFromPool();
                childNode.NodeDepth = currentNode.NodeDepth + 1;
                childNode.TotalDeltaTime = currentNode.TotalDeltaTime + 1;
                childNode.Parent = currentNode;
                childNode.Command = command;
                currentNode.Children[childIndex] = childNode;
                currentNode = childNode;
            }
            ++commandIndex;
        }
    }

    public void PostTreeBuildOptimise() {
        ArrayList<DangerPredictionTreeNode> queue = new ArrayList<DangerPredictionTreeNode>();
        queue.add(this._rootNode);
        this._nodeList.clear();
        while (!queue.isEmpty()) {
            DangerPredictionTreeNode front = (DangerPredictionTreeNode)queue.remove(0);
            int index = 0;
            while (index < DangerPredictionTreeNode.NumChildren) {
                DangerPredictionTreeNode child = front.Children[index];
                if (child != null) {
                    queue.add(child);
                }
                ++index;
            }
            this._nodeList.add(front);
        }
        System.out.println("Total Tree Nodes: " + this._nodeList.size());
    }

    public void UpdatePrediction(DangerPredictionState currentState, RobotDataSnapshot targetSnapshot, int maxPredictionDepth) {
        long currentTick = AgentSmith.Instance().getTime();
        this._rootNode.State = currentState;
        this._rootNode.NodeDistanceToDangerSq = this.CalculateMinDistanceSqToDanger(this._rootNode.State.X, this._rootNode.State.Y, currentTick);
        this._rootNode.NodeDistanceToTargetSq = this.CalculateDistanceSqToTarget(this._rootNode.State.X, this._rootNode.State.Y, currentTick, targetSnapshot);
        this._rootNode.PathDistanceToDangerSq = this._rootNode.NodeDistanceToDangerSq;
        this._rootNode.PathDistanceToTargetSq = this._rootNode.NodeDistanceToTargetSq;
        this._rootNode.Updated = true;
        this._rootNode.OutOfBounds = false;
        this._rootNode.Valid = true;
        double battlefieldWidth = AgentSmith.Instance().getBattleFieldWidth();
        double battlefieldHeight = AgentSmith.Instance().getBattleFieldHeight();
        double botWidth = AgentSmith.Instance().GetBotSizeMax();
        double botHalfWidth = AgentSmith.Instance().GetBotSizeMaxHalf();
        double botWidthSq = botWidth * botWidth;
        double botHalfWidthSq = botHalfWidth * botHalfWidth;
        double battlefieldPadding = AgentSmith.Instance().GetBotSizeMinHalf();
        int nodeListSize = this._nodeList.size();
        DangerPredictionTreeNode lowestDangerNodeValid = null;
        DangerPredictionTreeNode lowestDangerNodeInvalid = null;
        double highestScoreValid = 0.0;
        double highestScoreInvalid = 0.0;
        int index = 1;
        while (index < nodeListSize) {
            DangerPredictionTreeNode node = this._nodeList.get(index);
            if (node.NodeDepth > maxPredictionDepth) break;
            node.OutOfBounds = false;
            node.Valid = true;
            node.Updated = false;
            if (node.Parent.OutOfBounds) {
                node.OutOfBounds = true;
                node.Valid = node.Parent.Valid;
                node.Updated = false;
            } else {
                node.Updated = true;
                this._movementCommand.PredictCommand(node.Command, node.Parent.State, node.State);
                double nodeX = node.State.X;
                double nodeY = node.State.Y;
                if (RuleUtils.IsOutsideBattlefield(nodeX, nodeY, battlefieldPadding, battlefieldWidth, battlefieldHeight)) {
                    node.OutOfBounds = true;
                    node.Valid = false;
                } else {
                    long absTick = currentTick + (long)node.TotalDeltaTime;
                    node.NodeDistanceToDangerSq = this.CalculateMinDistanceSqToDanger(nodeX, nodeY, absTick);
                    node.PathDistanceToDangerSq = Math.min(node.Parent.PathDistanceToDangerSq, node.NodeDistanceToDangerSq);
                    node.NodeDistanceToTargetSq = this.CalculateDistanceSqToTarget(node.State.X, node.State.Y, absTick, targetSnapshot);
                    node.PathDistanceToTargetSq = Math.min(node.Parent.PathDistanceToTargetSq, node.NodeDistanceToTargetSq);
                    if (!node.Parent.Valid) {
                        node.Valid = false;
                    } else {
                        boolean bl = node.Valid = node.PathDistanceToDangerSq > botHalfWidthSq && node.PathDistanceToTargetSq > botWidthSq;
                    }
                    if (node.NodeDepth == maxPredictionDepth) {
                        double nodeScore = node.PathDistanceToDangerSq;
                        if (node.PathDistanceToTargetSq <= PreferredMinDistanceToTargetSq) {
                            double adjust01 = node.PathDistanceToTargetSq / PreferredMinDistanceToTargetSq;
                            nodeScore *= adjust01;
                        }
                        if (node.Valid) {
                            if (lowestDangerNodeValid == null || nodeScore > highestScoreValid) {
                                lowestDangerNodeValid = node;
                                highestScoreValid = nodeScore;
                            }
                        } else if (lowestDangerNodeInvalid == null || nodeScore > highestScoreInvalid) {
                            lowestDangerNodeInvalid = node;
                            highestScoreInvalid = nodeScore;
                        }
                    }
                }
            }
            ++index;
        }
        this._chosenMovement.clear();
        DangerPredictionTreeNode currentNode = lowestDangerNodeValid != null ? lowestDangerNodeValid : lowestDangerNodeInvalid;
        while (currentNode != null && currentNode != this._rootNode) {
            this._chosenMovement.add(0, currentNode);
            currentNode = currentNode.Parent;
        }
    }

    private double CalculateMinDistanceSqToDanger(double x, double y, long absTick) {
        double minDistanceSq = Double.MAX_VALUE;
        int numEnemyWaves = this._enemyWaveManager.GetNumActiveWaves();
        int waveIndex = 0;
        while (waveIndex < numEnemyWaves) {
            double waveDistanceSq = this.GetDistanceSqToClosestPredictedWave(waveIndex, absTick, x, y);
            minDistanceSq = Math.min(minDistanceSq, waveDistanceSq);
            ++waveIndex;
        }
        return minDistanceSq;
    }

    private double GetDistanceSqToClosestPredictedWave(int waveIndex, long tick, double x, double y) {
        WaveData enemyWave = this._enemyWaveManager.GetActiveWave(waveIndex);
        long snapshotIndex = tick - enemyWave.VirtualGunData.TickFired;
        if (snapshotIndex >= (long)WaveData.WaveSnapshotCount) {
            return Double.MAX_VALUE;
        }
        double closestDistance = Double.MAX_VALUE;
        int snapshotIndexInt = (int)snapshotIndex;
        int index = 0;
        while (index < enemyWave.NumWaveAngles) {
            WaveData.WaveAngleSnapshotData data = enemyWave.AngleSnapshots[index][snapshotIndexInt];
            double dX = x - data.CurrentLocationX;
            double dY = y - data.CurrentLocationY;
            double distanceSq = dX * dX + dY * dY;
            closestDistance = Math.min(closestDistance, distanceSq);
            ++index;
        }
        return closestDistance;
    }

    private double CalculateDistanceSqToTarget(double x, double y, long absTick, RobotDataSnapshot targetSnapshot) {
        long snapshotPredictionIndex = absTick - targetSnapshot.SnapshotTick;
        if (snapshotPredictionIndex >= (long)RobotDataSnapshot.MAX_PREDICTED_POSITIONS) {
            snapshotPredictionIndex = RobotDataSnapshot.MAX_PREDICTED_POSITIONS - 1;
        }
        double dX = x - targetSnapshot.PredictedPositionsX[(int)snapshotPredictionIndex];
        double dY = y - targetSnapshot.PredictedPositionsY[(int)snapshotPredictionIndex];
        return dX * dX + dY * dY;
    }

    public ArrayList<DangerPredictionTreeNode> GetChosenPrediction() {
        return this._chosenMovement;
    }

    public void DebugDrawTree(Graphics2D gfx) {
        int nodeListSize = this._nodeList.size();
        int index = 1;
        while (index < nodeListSize) {
            DangerPredictionTreeNode currentNode = this._nodeList.get(index);
            if (currentNode.Updated) {
                DangerPredictionState currentState = currentNode.State;
                DangerPredictionState parentState = currentNode.Parent.State;
                if (currentNode.OutOfBounds) {
                    gfx.setColor(Color.red);
                } else if (!currentNode.Valid) {
                    gfx.setColor(Color.orange);
                } else {
                    gfx.setColor(Color.green);
                }
                gfx.drawLine((int)currentState.X, (int)currentState.Y, (int)parentState.X, (int)parentState.Y);
            }
            ++index;
        }
    }
}

