/*
 * Decompiled with CFR 0.152.
 */
package rdt.Utils;

public class RollingAverage {
    private int _values;
    private int _maxValues;
    private double _averageValue;
    private double _weighting;

    public RollingAverage(int maxValues, double weighting) {
        this._maxValues = maxValues;
        this._values = 0;
        this._averageValue = 0.0;
        this._weighting = weighting;
    }

    public void AddEntry(double entry) {
        ++this._values;
        int n = Math.min(this._values, this._maxValues);
        this._averageValue = this.UpdateRollingAverage(this._averageValue, entry, n, this._weighting);
    }

    private double UpdateRollingAverage(double value, double newEntry, double n, double weighting) {
        return (value * n + newEntry * weighting) / (n + weighting);
    }

    public double Average() {
        return this._averageValue;
    }

    public void Reset() {
        this._averageValue = 0.0;
        this._values = 0;
    }
}

