/*
 * Decompiled with CFR 0.152.
 */
package gf.Centaur.movement;

import gf.Centaur.movement.PredictionRobot;
import gf.Centaur.utils.ExecutingRobot;
import gf.Centaur.utils.Tools;
import gf.Centaur.utils.Wave;
import java.awt.geom.Point2D;
import robocode.Rules;
import robocode.util.Utils;

public class PrecisePrediction {
    private static final double WALL_HIT_DIST = 30.0;
    private ExecutingRobot robot;
    PredictionRobot rob;
    double distanceRemaining;
    double angleRemaining;
    boolean isOverDriving;

    public PrecisePrediction(ExecutingRobot robot) {
        this.robot = robot;
    }

    public PredictionRobot getPrediction(long time, double distance, double turnAngle) {
        this.rob = new PredictionRobot(this.robot.getPosition(), Tools.toPolar(this.robot.getHeadingRadians()), this.robot.getVelocity());
        this.distanceRemaining = distance;
        this.angleRemaining = -turnAngle;
        this.isOverDriving = false;
        while (time > 0L) {
            this.next();
            --time;
        }
        return this.rob;
    }

    public PredictionRobot getPrediction(double distance, double turnAngle) {
        this.rob = new PredictionRobot(this.robot.getPosition(), Tools.toPolar(this.robot.getHeadingRadians()), this.robot.getVelocity());
        this.distanceRemaining = distance;
        this.angleRemaining = -turnAngle;
        this.isOverDriving = false;
        while (this.angleRemaining != 0.0 || this.distanceRemaining != 0.0) {
            this.next();
        }
        return this.rob;
    }

    public PredictionRobot getPredictionWave(double distance, double turnAngle, Wave wave) {
        this.rob = new PredictionRobot(this.robot.getPosition(), Tools.toPolar(this.robot.getHeadingRadians()), this.robot.getVelocity());
        this.distanceRemaining = distance;
        this.angleRemaining = -turnAngle;
        this.isOverDriving = false;
        long time = 0L;
        while (this.rob.getPosition().distance(wave.getPoint()) > wave.getRadius(this.robot.getTime() + time)) {
            this.next();
            ++time;
        }
        return this.rob;
    }

    private void next() {
        double turnRate = Math.min(Rules.MAX_TURN_RATE_RADIANS, (0.4 + 0.6 * (1.0 - Math.abs(this.rob.getVelocity()) / 8.0)) * Rules.MAX_TURN_RATE_RADIANS);
        double turnAngle = Math.min(Math.max(this.angleRemaining, -turnRate), turnRate);
        this.rob.turn(turnAngle);
        this.angleRemaining -= turnAngle;
        this.rob.setVelocity(PrecisePrediction.getNewVelocity(this.rob.getVelocity(), this.distanceRemaining));
        if (Utils.isNear((double)this.rob.getVelocity(), (double)0.0) && this.isOverDriving) {
            this.distanceRemaining = 0.0;
            this.isOverDriving = false;
        }
        if (Math.signum(this.distanceRemaining * this.rob.getVelocity()) != -1.0) {
            this.isOverDriving = PrecisePrediction.getDistanceTraveledUntilStop(this.rob.getVelocity()) > Math.abs(this.distanceRemaining);
        }
        this.distanceRemaining -= this.rob.getVelocity();
        double heading = this.rob.getHeading();
        double velocity = this.rob.getVelocity();
        Point2D.Double pos = new Point2D.Double(this.rob.getX() + Math.cos(heading) * velocity, this.rob.getY() + Math.sin(heading) * velocity);
        if (pos.getX() < 30.0 || pos.getX() > this.robot.getBattleFieldWidth() - 30.0 || pos.getY() < 30.0 || pos.getY() > this.robot.getBattleFieldHeight() - 30.0) {
            this.distanceRemaining = 0.0;
            this.rob.setVelocity(0.0);
            this.rob.hitWall();
        } else {
            this.rob.setPosition(pos);
        }
    }

    private static double getNewVelocity(double velocity, double distance) {
        if (distance < 0.0) {
            return -PrecisePrediction.getNewVelocity(-velocity, -distance);
        }
        double goalVel = distance == Double.POSITIVE_INFINITY ? 8.0 : Math.min(PrecisePrediction.getMaxVelocity(distance), 8.0);
        if (velocity >= 0.0) {
            return Math.max(velocity - 2.0, Math.min(goalVel, velocity + 1.0));
        }
        return Math.max(velocity - 1.0, Math.min(goalVel, velocity + PrecisePrediction.maxDecel(-velocity)));
    }

    static final double getMaxVelocity(double distance) {
        double decelTime = Math.max(1.0, Math.ceil((Math.sqrt(4.0 * distance + 1.0) - 1.0) / 2.0));
        if (decelTime == Double.POSITIVE_INFINITY) {
            return 8.0;
        }
        double decelDist = decelTime / 2.0 * (decelTime - 1.0) * 2.0;
        return (decelTime - 1.0) * 2.0 + (distance - decelDist) / decelTime;
    }

    private static double maxDecel(double speed) {
        double decelTime = speed / 2.0;
        double accelTime = 1.0 - decelTime;
        return Math.min(1.0, decelTime) * 2.0 + Math.max(0.0, accelTime) * 1.0;
    }

    private static double getDistanceTraveledUntilStop(double velocity) {
        double distance = 0.0;
        velocity = Math.abs(velocity);
        while (velocity > 0.0) {
            velocity = PrecisePrediction.getNewVelocity(velocity, 0.0);
            distance += velocity;
        }
        return distance;
    }
}

