/*
 * Decompiled with CFR 0.152.
 */
package florent.test;

import florent.test.FUtils;
import florent.test.NodeSegmentation;
import florent.test.Segmentation;
import florent.test.SymbolicTree;
import florent.test.Toad;
import florent.test.WeightedVisitRecorder;
import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;
import robocode.AdvancedRobot;
import robocode.Condition;
import robocode.RobocodeFileOutputStream;

public class SegmentationTree
implements Serializable,
Runnable {
    private static final long serialVersionUID = 2503026896538361157L;
    private static final boolean RUMBLE = true;
    private boolean saveToFile = false;
    private boolean showSegementation = false;
    private int GF_ZERO;
    private int GF_ONE;
    private double[] ALL_ACCEL = new double[]{Double.NEGATIVE_INFINITY, 2.0, -1.5, -1.0, -0.5, 0.0, 0.5, 1.0, Double.POSITIVE_INFINITY};
    private double[] ALL_DISTANCE = new double[]{Double.NEGATIVE_INFINITY, 100.0, 150.0, 200.0, 250.0, 300.0, 350.0, 400.0, 450.0, 500.0, 550.0, 600.0, 650.0, Double.POSITIVE_INFINITY};
    private double[] ALL_POWER = new double[]{Double.NEGATIVE_INFINITY, 0.5, 1.0, 1.5, 2.0, 2.5, Double.POSITIVE_INFINITY};
    private double[] ALL_TIME = new double[]{Double.NEGATIVE_INFINITY, 0.1, 0.15, 0.25, 0.3, 0.35, 0.45, 0.55, 0.65, 0.7, 0.9, 1.1, Double.POSITIVE_INFINITY};
    private double[] ALL_VEL = new double[]{Double.NEGATIVE_INFINITY, 0.0, 1.0, 1.5, 2.0, 2.5, 3.0, 3.5, 4.0, 4.5, 5.0, 5.5, 6.0, 6.5, 7.0, 7.5, Double.POSITIVE_INFINITY};
    private double[] ALL_WALL = new double[]{Double.NEGATIVE_INFINITY, 0.15, 0.3, 0.4, 0.6, 0.8, 0.1, 1.0, 1.3, 1.6, Double.POSITIVE_INFINITY};
    private double[] ALL_WALL_REVERSE = new double[]{Double.NEGATIVE_INFINITY, 0.5, 0.75, 1.0, 1.45, Double.POSITIVE_INFINITY};
    private double[] ALL_DISTANCE8 = new double[]{Double.NEGATIVE_INFINITY, 0.0, Double.POSITIVE_INFINITY};
    private double[] ALL_DISTANCE15 = new double[]{Double.NEGATIVE_INFINITY, 0.0, Double.POSITIVE_INFINITY};
    private double minAccel = 0.5;
    private double minVel = 1.5;
    private double minLatvel = 1.5;
    private double minDistance = 150.0;
    private double minPower = 80.0;
    private double minWall = 0.15;
    private double minTime = 0.1;
    private double minWallReverse = 0.35;
    private double minDistance15 = 80.0;
    private double minDistance8 = 8.0;
    private int threshold;
    private boolean verbose = false;
    private int rebuilding = 0;
    private boolean start = false;
    private boolean rebuild = true;
    private Node root;
    private int leaves = 0;
    private int weightedLeaves = 0;
    public AdvancedRobot me;
    private boolean bufferingEntry = false;
    private Vector buffer = new Vector();
    private Thread rebuildThread;
    private Thread treeThread;
    private volatile boolean rebuildingInProcess = false;
    private volatile boolean addingInProcess = false;
    private WeightedVisitRecorder recorder = new WeightedVisitRecorder();
    private boolean dynamicTree = true;
    private volatile boolean quitThread = false;
    private double round;
    private boolean standardized = false;
    private Segmentation seg;

    public SegmentationTree(int gf0, int gf1, int threshold) {
        this.GF_ZERO = gf0;
        this.GF_ONE = gf1;
        this.threshold = threshold * 5;
        this.root = new NonPreTerminalNode();
        this.root.nSeg = new NodeSegmentation();
    }

    public void init() {
        this.quitThread = false;
        this.round = this.me.getRoundNum();
        this.treeThread = ((Toad)this.me).giveThread(this);
        this.treeThread.start();
        this.treeThread.setPriority(10);
    }

    public void setRoot(Node node) {
        System.out.println("Root changed");
        this.root = node;
    }

    private int getRealThreshold() {
        return this.threshold;
    }

    public void newEntry(double d, double e, double f, double g, double h, double i, double j, double k, double wallReverse, boolean vb, double distance8, double distance15) {
        ++this.leaves;
        this.weightedLeaves += vb ? 1 : 5;
        Leaf leaf = new Leaf(d, e, f, g, h, i, j, k, wallReverse, distance8, distance15);
        leaf.weigth = vb ? 1 : 5;
        this.buffer.add(leaf);
        this.treeThread.setPriority(10);
    }

    public void run() {
        this.quitThread = false;
        while (!this.quitThread) {
            if (this.rebuildingInProcess) continue;
            if (this.buffer.size() > 0) {
                Leaf leaf = (Leaf)this.buffer.remove(0);
                TreeAddVisitor v = new TreeAddVisitor(leaf);
                this.addingInProcess = true;
                v.test();
                this.addingInProcess = false;
                continue;
            }
            this.treeThread.setPriority(1);
        }
    }

    public int getPeak(double d, double e, double f, double g, double h, double i, double j, double k, double wallReverse, double distance8, double distance15) {
        Leaf leaf = new Leaf(d, e, f, g, h, i, j, k, wallReverse, distance8, distance15);
        return this.getPeak(leaf);
    }

    public int getPeak(Leaf leaf) {
        if (this.leaves == 0) {
            return this.GF_ZERO;
        }
        TreePeakVisitor peak = new TreePeakVisitor(leaf);
        this.root.accept(peak);
        return peak.getPeak();
    }

    public void clean() {
        TreeCleanerVisitor v = new TreeCleanerVisitor();
        this.root.accept(v);
    }

    public void populate() {
        TreePopulatorVisitor v = new TreePopulatorVisitor();
        this.root.accept(v);
    }

    public void rebuild() {
        if (!this.rebuild) {
            return;
        }
        this.bufferingEntry = true;
        TreeRebuildVisitor visitor = new TreeRebuildVisitor();
        this.rebuildThread = new Thread(visitor);
        while (this.addingInProcess) {
        }
        this.rebuildThread.start();
        this.rebuildThread.setPriority(10);
    }

    public void endRound() {
        this.quitThread = true;
    }

    public void setRebuild(boolean rebuild) {
        this.rebuild = rebuild;
    }

    public boolean isRebuilding() {
        return this.rebuilding != 0 || this.start;
    }

    public Node save() {
        this.root.accept(new TreeCleanerVisitor());
        return this.root;
    }

    public SymbolicTree saveSymbolic() {
        TreeSaveSymbolicVisitor v = new TreeSaveSymbolicVisitor();
        this.root.accept(v);
        return v.getTheNode();
    }

    public void restoreFromSymbolicTree(SymbolicTree sTree) {
        SymbolicTree symbolicTree = sTree;
        symbolicTree.getClass();
        SymbolicTree.TreeRestoreSymbolicVisitor v = symbolicTree.new SymbolicTree.TreeRestoreSymbolicVisitor(sTree, this.root, this);
        Thread restoreThread = new Thread(v);
        restoreThread.start();
    }

    public void restore(Node node) {
        node.accept(new TreePopulatorVisitor());
        this.root = node;
    }

    public NonPreTerminalNode getNode(int code) {
        int offset = 0;
        if (code == -1) {
            return new NonPreTerminalNode();
        }
        if (code < this.ALL_ACCEL.length) {
            return new AccelNode(this.ALL_ACCEL[code]);
        }
        if (code < (offset += this.ALL_ACCEL.length) + this.ALL_DISTANCE.length) {
            return new DistanceNode(this.ALL_DISTANCE[code - offset]);
        }
        if (code < (offset += this.ALL_DISTANCE.length) + this.ALL_VEL.length) {
            return new LatvelNode(this.ALL_VEL[code - offset]);
        }
        if (code < (offset += this.ALL_VEL.length) + this.ALL_POWER.length) {
            return new PowerNode(this.ALL_POWER[code - offset]);
        }
        if (code < (offset += this.ALL_POWER.length) + this.ALL_TIME.length) {
            return new MoveTimeNode(this.ALL_TIME[code - offset]);
        }
        if (code < (offset += this.ALL_TIME.length) + this.ALL_VEL.length) {
            return new VelNode(this.ALL_VEL[code - offset]);
        }
        if (code < (offset += this.ALL_VEL.length) + this.ALL_WALL.length) {
            return new WallNode(this.ALL_WALL[code - offset]);
        }
        if (code < (offset += this.ALL_WALL.length) + this.ALL_WALL_REVERSE.length) {
            return new WallReverseNode(this.ALL_WALL_REVERSE[code - offset]);
        }
        return null;
    }

    public boolean isStart() {
        return this.start;
    }

    public void setStart(boolean start) {
        this.start = start;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    abstract class Node
    implements Serializable {
        protected int count;
        protected NodeSegmentation nSeg;

        Node() {
        }

        public void accept(TreeVisitor v) {
            this.count = 0;
        }

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            this.count = count;
        }
    }

    public class NonPreTerminalNode
    extends Node {
        private static final long serialVersionUID = 2511616405755008534L;
        protected Node right;
        protected Node left;
        protected ArrayList[] factors;

        protected NonPreTerminalNode() {
            this.factors = new ArrayList[SegmentationTree.this.GF_ONE + 1];
            int i = 0;
            while (i < SegmentationTree.this.GF_ONE + 1) {
                this.factors[i] = new ArrayList();
                ++i;
            }
            if (SegmentationTree.this.rebuild) {
                this.left = new DynamicNode();
                this.right = new DynamicNode();
                this.left.nSeg = new NodeSegmentation();
                this.right.nSeg = new NodeSegmentation();
            } else {
                this.left = new StaticNode();
                this.right = new StaticNode();
            }
        }

        public boolean goRight(Leaf leaf) {
            return false;
        }

        public Node getLeft() {
            return this.left;
        }

        public void setLeft(Node left) {
            this.left = left;
        }

        public Node getRight() {
            return this.right;
        }

        public void setRight(Node right) {
            this.right = right;
        }

        public void fillFactors(ArrayList[] list) {
            int k = 0;
            while (k < SegmentationTree.this.GF_ONE) {
                Iterator it = list[k].listIterator();
                while (it.hasNext()) {
                    ++this.count;
                    Leaf leaf = (Leaf)it.next();
                    this.add(leaf);
                    if (this.goRight(leaf)) {
                        ((PreTerminalNode)this.right).add(leaf);
                        continue;
                    }
                    ((PreTerminalNode)this.left).add(leaf);
                }
                ++k;
            }
        }

        public void add(Leaf leaf) {
            this.factors[(int)FUtils.bindToRange(Math.round((1.0 + leaf.gf) * (double)SegmentationTree.this.GF_ZERO), 0.0, SegmentationTree.this.GF_ONE)].add(leaf);
        }

        public ArrayList[] getLeaves() {
            return this.factors;
        }

        public void accept(TreeVisitor v) {
            v.visitNPTN(this);
        }

        public int code() {
            return -1;
        }

        public String toString() {
            return "NonPreTerminal root";
        }
    }

    class StaticNonPreTerminalNode
    extends NonPreTerminalNode {
        private NonPreTerminalNode node;
        private double[] factors;

        public StaticNonPreTerminalNode(NonPreTerminalNode node) {
            this.factors = new double[SegmentationTree.this.GF_ONE + 1];
            this.node = node;
        }

        public void addLeaf(Leaf leaf) {
            SegmentationTree.this.recorder.setWeight(leaf.getWeigth());
            SegmentationTree.this.recorder.registerVisit(leaf.getGf(), this.factors);
        }

        public void accept(TreeVisitor v) {
            v.visitSNPTN(this);
            v.visitNPTN(this.node);
        }

        public int code() {
            return this.node.code();
        }

        public String toString() {
            return "Static " + this.node.toString();
        }
    }

    class DistanceNode
    extends NonPreTerminalNode {
        private static final long serialVersionUID = -3017031763049964074L;
        protected double distance;

        public DistanceNode(double distance) {
            this.distance = distance;
        }

        public boolean goRight(Leaf leaf) {
            return leaf.getDistance() > this.distance;
        }

        public double getDistance() {
            return this.distance;
        }

        public int code() {
            return Arrays.binarySearch(SegmentationTree.this.ALL_DISTANCE, this.distance) + SegmentationTree.this.ALL_ACCEL.length;
        }

        public String toString() {
            return "Distance:" + this.distance;
        }
    }

    class AccelNode
    extends NonPreTerminalNode {
        private static final long serialVersionUID = -5774124356484777243L;
        protected double accel;

        public AccelNode(double accel) {
            this.accel = accel;
        }

        public boolean goRight(Leaf leaf) {
            return leaf.getAccel() > this.accel;
        }

        public double getAccel() {
            return this.accel;
        }

        public int code() {
            return Arrays.binarySearch(SegmentationTree.this.ALL_ACCEL, this.accel);
        }

        public String toString() {
            return "Acceleration:" + this.accel;
        }
    }

    class VelNode
    extends NonPreTerminalNode {
        private static final long serialVersionUID = 943213232679268372L;
        protected double velocity;

        public VelNode(double velocity) {
            this.velocity = velocity;
        }

        public boolean goRight(Leaf leaf) {
            return leaf.getVelocity() > this.velocity;
        }

        public double getVelocity() {
            return this.velocity;
        }

        public int code() {
            return Arrays.binarySearch(SegmentationTree.this.ALL_VEL, this.velocity) + SegmentationTree.this.ALL_ACCEL.length + SegmentationTree.this.ALL_DISTANCE.length + SegmentationTree.this.ALL_VEL.length + SegmentationTree.this.ALL_POWER.length + SegmentationTree.this.ALL_TIME.length;
        }

        public String toString() {
            return "Velocity:" + this.velocity;
        }
    }

    class LatvelNode
    extends NonPreTerminalNode {
        private static final long serialVersionUID = 2699104696000932491L;
        protected double latvel;

        public LatvelNode(double latvel) {
            this.latvel = latvel;
        }

        public boolean goRight(Leaf leaf) {
            return leaf.getLatvel() > this.latvel;
        }

        public double getLatvel() {
            return this.latvel;
        }

        public int code() {
            return Arrays.binarySearch(SegmentationTree.this.ALL_VEL, this.latvel) + SegmentationTree.this.ALL_ACCEL.length + SegmentationTree.this.ALL_DISTANCE.length;
        }

        public String toString() {
            return "Lateral Velocity:" + this.latvel;
        }
    }

    class MoveTimeNode
    extends NonPreTerminalNode {
        private static final long serialVersionUID = -403423486376627154L;
        protected double move;

        public MoveTimeNode(double move) {
            this.move = move;
        }

        public boolean goRight(Leaf leaf) {
            return leaf.getMoveTime() > this.move;
        }

        public double getMoveTime() {
            return this.move;
        }

        public int code() {
            return Arrays.binarySearch(SegmentationTree.this.ALL_TIME, this.move) + SegmentationTree.this.ALL_ACCEL.length + SegmentationTree.this.ALL_DISTANCE.length + SegmentationTree.this.ALL_VEL.length + SegmentationTree.this.ALL_POWER.length;
        }

        public String toString() {
            return "Move Time:" + this.move;
        }
    }

    class PowerNode
    extends NonPreTerminalNode {
        private static final long serialVersionUID = -4244374812884848001L;
        protected double power;

        public PowerNode(double power) {
            this.power = power;
        }

        public boolean goRight(Leaf leaf) {
            return leaf.getFirePower() > this.power / 50.0;
        }

        public double getPower() {
            return this.power;
        }

        public int code() {
            return Arrays.binarySearch(SegmentationTree.this.ALL_POWER, this.power) + SegmentationTree.this.ALL_ACCEL.length + SegmentationTree.this.ALL_DISTANCE.length + SegmentationTree.this.ALL_VEL.length;
        }

        public String toString() {
            return "Power:" + this.power;
        }
    }

    class WallNode
    extends NonPreTerminalNode {
        private static final long serialVersionUID = -2695158178698601457L;
        protected double wall;

        public WallNode(double wall) {
            this.wall = wall;
        }

        public boolean goRight(Leaf leaf) {
            return leaf.getWallIndex() > this.wall;
        }

        public double getWall() {
            return this.wall;
        }

        public int code() {
            return Arrays.binarySearch(SegmentationTree.this.ALL_WALL, this.wall) + SegmentationTree.this.ALL_ACCEL.length + SegmentationTree.this.ALL_DISTANCE.length + SegmentationTree.this.ALL_VEL.length + SegmentationTree.this.ALL_POWER.length + SegmentationTree.this.ALL_TIME.length + SegmentationTree.this.ALL_VEL.length;
        }

        public String toString() {
            return "Wall:" + this.wall;
        }
    }

    class WallReverseNode
    extends NonPreTerminalNode {
        private static final long serialVersionUID = -2695158178698601457L;
        protected double wall;

        public WallReverseNode(double wall) {
            this.wall = wall;
        }

        public boolean goRight(Leaf leaf) {
            return leaf.getWallIndex() > this.wall;
        }

        public double getWall() {
            return this.wall;
        }

        public int code() {
            return Arrays.binarySearch(SegmentationTree.this.ALL_WALL_REVERSE, this.wall) + SegmentationTree.this.ALL_ACCEL.length + SegmentationTree.this.ALL_DISTANCE.length + SegmentationTree.this.ALL_VEL.length + SegmentationTree.this.ALL_POWER.length + SegmentationTree.this.ALL_TIME.length + SegmentationTree.this.ALL_VEL.length + SegmentationTree.this.ALL_WALL.length;
        }

        public String toString() {
            return "Wall Reverse:" + this.wall;
        }
    }

    class Distance8Node
    extends NonPreTerminalNode {
        protected double distance8;

        public Distance8Node(double distance) {
            this.distance8 = distance;
        }

        public boolean goRight(Leaf leaf) {
            return leaf.getDistance8() > this.distance8;
        }

        public double getDistance8() {
            return this.distance8;
        }

        public int code() {
            return Arrays.binarySearch(SegmentationTree.this.ALL_DISTANCE8, this.distance8) + SegmentationTree.this.ALL_ACCEL.length + SegmentationTree.this.ALL_DISTANCE.length + SegmentationTree.this.ALL_VEL.length + SegmentationTree.this.ALL_POWER.length + SegmentationTree.this.ALL_TIME.length + SegmentationTree.this.ALL_VEL.length + SegmentationTree.this.ALL_WALL.length + SegmentationTree.this.ALL_WALL_REVERSE.length;
        }

        public String toString() {
            return "Distance8:" + this.distance8;
        }
    }

    class Distance15Node
    extends NonPreTerminalNode {
        protected double distance15;

        public Distance15Node(double distance) {
            this.distance15 = distance;
        }

        public boolean goRight(Leaf leaf) {
            return leaf.getDistance8() > this.distance15;
        }

        public double getDistance15() {
            return this.distance15;
        }

        public int code() {
            return Arrays.binarySearch(SegmentationTree.this.ALL_DISTANCE15, this.distance15) + SegmentationTree.this.ALL_ACCEL.length + SegmentationTree.this.ALL_DISTANCE.length + SegmentationTree.this.ALL_VEL.length + SegmentationTree.this.ALL_POWER.length + SegmentationTree.this.ALL_TIME.length + SegmentationTree.this.ALL_VEL.length + SegmentationTree.this.ALL_WALL.length + SegmentationTree.this.ALL_WALL_REVERSE.length + SegmentationTree.this.ALL_DISTANCE8.length;
        }

        public String toString() {
            return "Distance15:" + this.distance15;
        }
    }

    abstract class PreTerminalNode
    extends Node {
        protected Leaf leaf;
        protected boolean done = false;

        PreTerminalNode() {
        }

        public boolean isDone() {
            return this.done;
        }

        public void setLeaf(Leaf leaf) {
            this.leaf = leaf;
        }

        public abstract void add(Leaf var1);

        public abstract int getPeak();

        public void fillFactors(ArrayList[] list) {
            int k = 0;
            while (k < SegmentationTree.this.GF_ONE) {
                Iterator it = list[k].listIterator();
                while (it.hasNext()) {
                    this.add((Leaf)it.next());
                }
                ++k;
            }
        }

        public void accept(TreeVisitor v) {
            v.visitPTN(this);
        }
    }

    class StaticNode
    extends PreTerminalNode {
        private static final long serialVersionUID = -8584356499226512475L;
        private double[] factors;

        public StaticNode() {
            this.factors = new double[SegmentationTree.this.GF_ONE + 1];
            if (SegmentationTree.this.verbose) {
                System.out.println("new static node");
            }
        }

        public void add(Leaf leaf) {
            SegmentationTree.this.recorder.setWeight(leaf.getWeigth());
            SegmentationTree.this.recorder.registerVisit(leaf.getGf(), this.factors);
        }

        public int getPeak() {
            int bestGF = (int)((double)SegmentationTree.this.GF_ZERO * 1.2);
            double bestVal = 0.0;
            int halfWidth = (int)Math.floor(Math.atan(18.0 / this.leaf.distance) * (double)SegmentationTree.this.GF_ONE);
            int gf = SegmentationTree.this.GF_ONE;
            while (gf > 0) {
                double tmp = 0.0;
                int i = Math.max(1, gf - halfWidth);
                while (i <= Math.min(gf + halfWidth, SegmentationTree.this.GF_ONE)) {
                    if ((tmp += this.factors[i]) > bestVal) {
                        bestGF = gf;
                        bestVal = tmp;
                    }
                    ++i;
                }
                --gf;
            }
            return bestGF;
        }
    }

    class DynamicNode
    extends PreTerminalNode
    implements Runnable {
        private static final long serialVersionUID = -3948835283424191222L;
        private ArrayList[] factors;
        private Leaf leaf;
        private boolean done = false;
        private boolean accelDone = false;
        private boolean velDone = false;
        private boolean latvelDone = false;
        private boolean distanceDone = false;
        private boolean powerDone = false;
        private boolean wallDone = false;
        private boolean moveDone = false;
        private boolean wallReverseDone = false;
        private boolean distance8Done = false;
        private boolean distance15Done = false;
        private double minAccel1 = Double.POSITIVE_INFINITY;
        private double minVel1 = Double.POSITIVE_INFINITY;
        private double minLatvel1 = Double.POSITIVE_INFINITY;
        private double minDistance1 = Double.POSITIVE_INFINITY;
        private double minPower1 = Double.POSITIVE_INFINITY;
        private double minWall1 = Double.POSITIVE_INFINITY;
        private double minMove1 = Double.POSITIVE_INFINITY;
        private double minWallReverse1 = Double.POSITIVE_INFINITY;
        private double maxAccel1 = Double.NEGATIVE_INFINITY;
        private double maxVel1 = Double.NEGATIVE_INFINITY;
        private double maxLatvel1 = Double.NEGATIVE_INFINITY;
        private double maxDistance1 = Double.NEGATIVE_INFINITY;
        private double maxPower1 = Double.NEGATIVE_INFINITY;
        private double maxWall1 = Double.NEGATIVE_INFINITY;
        private double maxMove1 = Double.NEGATIVE_INFINITY;
        private double maxWallReverse1 = Double.NEGATIVE_INFINITY;

        public DynamicNode() {
            this.factors = new ArrayList[SegmentationTree.this.GF_ONE + 1];
            int i = 0;
            while (i <= SegmentationTree.this.GF_ONE) {
                this.factors[i] = new ArrayList();
                ++i;
            }
        }

        public DynamicNode(ArrayList[] factors) {
            this.factors = factors;
        }

        public boolean isDone() {
            return this.done;
        }

        public void setLeaf(Leaf leaf) {
            this.leaf = leaf;
        }

        public ArrayList[] getFactors() {
            return this.factors;
        }

        public void add(Leaf leaf) {
            try {
                this.factors[(int)FUtils.bindToRange((int)(FUtils.bindToRange(leaf.getGf(), -1.0, 1.0) * (double)SegmentationTree.this.GF_ZERO + (double)SegmentationTree.this.GF_ZERO), 0.0, SegmentationTree.this.GF_ONE)].add(leaf);
            }
            catch (Exception e) {
                System.out.println("gf" + leaf.getGf() + "\n" + e);
            }
        }

        public int getPeak() {
            int bestGF = (int)((double)SegmentationTree.this.GF_ZERO * 1.2);
            double bestVal = 0.0;
            int halfWidth = (int)Math.floor(Math.atan(18.0 / this.leaf.distance) * (double)SegmentationTree.this.GF_ONE);
            int gf = SegmentationTree.this.GF_ONE;
            while (gf > 0) {
                double tmp = 0.0;
                if ((tmp += (double)this.factors[gf].size()) > bestVal) {
                    bestGF = gf;
                    bestVal = tmp;
                }
                --gf;
            }
            return bestGF;
        }

        public void run() {
            this.split();
        }

        public NonPreTerminalNode split() {
            double bestGain;
            NonPreTerminalNode best;
            double wallReverse;
            Distance15Node distance15Node;
            double distance15Mean;
            double distance8Mean;
            double distanceMean;
            double moveMean;
            double wallReverseMean;
            double wallMean;
            double powerMean;
            double latvelMean;
            double velMean;
            double accelMean;
            SegmentationTree segmentationTree = SegmentationTree.this;
            segmentationTree.rebuilding = segmentationTree.rebuilding + 1;
            SegmentationTree.this.start = false;
            this.wallReverseDone = false;
            this.distance15Done = false;
            this.distance8Done = false;
            this.distanceDone = false;
            this.moveDone = false;
            this.wallDone = false;
            this.powerDone = false;
            this.latvelDone = false;
            this.velDone = false;
            this.accelDone = false;
            if (this.accelDone && this.velDone && this.latvelDone && this.powerDone && this.wallDone && this.moveDone && this.distance8Done && this.distance15Done && this.distanceDone && this.wallReverseDone) {
                return null;
            }
            this.distance15Done = true;
            this.powerDone = true;
            ArrayList<Double> accelArray = this.accelDone ? null : new ArrayList<Double>();
            ArrayList<Double> velArray = this.velDone ? null : new ArrayList<Double>();
            ArrayList<Double> latvelArray = this.latvelDone ? null : new ArrayList<Double>();
            ArrayList<Double> powerArray = this.powerDone ? null : new ArrayList<Double>();
            ArrayList<Double> wallArray = this.wallDone ? null : new ArrayList<Double>();
            ArrayList<Double> wallReverseArray = this.wallReverseDone ? null : new ArrayList<Double>();
            ArrayList<Double> moveArray = this.moveDone ? null : new ArrayList<Double>();
            ArrayList<Double> distanceArray = this.distanceDone ? null : new ArrayList<Double>();
            ArrayList<Double> distance8Array = this.distance8Done ? null : new ArrayList<Double>();
            ArrayList<Double> distance15Array = this.distance15Done ? null : new ArrayList<Double>();
            int i = 0;
            while (i <= SegmentationTree.this.GF_ONE) {
                int j = 0;
                while (j < this.factors[i].size()) {
                    Leaf leaf = (Leaf)this.factors[i].get(j);
                    if (!this.accelDone) {
                        accelArray.add(new Double(leaf.getAccel()));
                    }
                    if (!this.velDone) {
                        velArray.add(new Double(leaf.getVelocity()));
                    }
                    if (!this.latvelDone) {
                        latvelArray.add(new Double(leaf.getLatvel()));
                    }
                    if (!this.powerDone) {
                        powerArray.add(new Double(leaf.getFirePower()));
                    }
                    if (!this.wallDone) {
                        wallArray.add(new Double(leaf.getWallIndex()));
                    }
                    if (!this.wallReverseDone) {
                        wallReverseArray.add(new Double(leaf.getWallReverse()));
                    }
                    if (!this.moveDone) {
                        moveArray.add(new Double(leaf.getMoveTime()));
                    }
                    if (!this.distanceDone) {
                        distanceArray.add(new Double(leaf.getDistance()));
                    }
                    if (!this.distance8Done) {
                        distance8Array.add(new Double(leaf.getDistance8()));
                    }
                    if (!this.distance15Done) {
                        distance15Array.add(new Double(leaf.getDistance15()));
                    }
                    ++j;
                }
                ++i;
            }
            if (!this.accelDone) {
                Collections.sort(accelArray);
            }
            if (!this.velDone) {
                Collections.sort(velArray);
            }
            if (!this.latvelDone) {
                Collections.sort(latvelArray);
            }
            if (!this.powerDone) {
                Collections.sort(powerArray);
            }
            if (!this.wallDone) {
                Collections.sort(wallArray);
            }
            if (!this.wallReverseDone) {
                Collections.sort(wallReverseArray);
            }
            if (!this.moveDone) {
                Collections.sort(moveArray);
            }
            if (!this.distanceDone) {
                Collections.sort(distanceArray);
            }
            if (!this.distance8Done) {
                Collections.sort(distance8Array);
            }
            if (!this.distance15Done) {
                Collections.sort(distance15Array);
            }
            boolean bl = this.accelDone ? this.accelDone : (this.accelDone = Math.abs((Double)accelArray.get(0) - (Double)accelArray.get(accelArray.size() - 1)) < SegmentationTree.this.minAccel);
            boolean bl2 = this.latvelDone ? this.latvelDone : (this.latvelDone = Math.abs((Double)latvelArray.get(0) - (Double)latvelArray.get(latvelArray.size() - 1)) < SegmentationTree.this.minLatvel);
            boolean bl3 = this.velDone ? this.velDone : (this.velDone = Math.abs((Double)velArray.get(0) - (Double)velArray.get(velArray.size() - 1)) < SegmentationTree.this.minVel);
            boolean bl4 = this.distanceDone ? this.distanceDone : (this.distanceDone = Math.abs((Double)distanceArray.get(0) - (Double)distanceArray.get(distanceArray.size() - 1)) < SegmentationTree.this.minDistance);
            boolean bl5 = this.distance8Done ? this.distance8Done : (this.distance8Done = Math.abs((Double)distance8Array.get(0) - (Double)distance8Array.get(distance8Array.size() - 1)) < SegmentationTree.this.minDistance8);
            boolean bl6 = this.distance15Done ? this.distance15Done : (this.distance15Done = Math.abs((Double)distance15Array.get(0) - (Double)distance15Array.get(distance15Array.size() - 1)) < SegmentationTree.this.minDistance15);
            boolean bl7 = this.powerDone ? this.powerDone : (this.powerDone = Math.abs((Double)powerArray.get(0) - (Double)powerArray.get(powerArray.size() - 1)) < SegmentationTree.this.minPower);
            boolean bl8 = this.moveDone ? this.moveDone : (this.moveDone = Math.abs((Double)moveArray.get(0) - (Double)moveArray.get(moveArray.size() - 1)) < SegmentationTree.this.minTime);
            boolean bl9 = this.wallDone ? this.wallDone : (this.wallDone = Math.abs((Double)wallArray.get(0) - (Double)wallArray.get(wallArray.size() - 1)) < SegmentationTree.this.minWall);
            boolean bl10 = this.wallReverseDone ? this.wallReverseDone : (this.wallReverseDone = Math.abs((Double)wallReverseArray.get(0) - (Double)wallReverseArray.get(wallReverseArray.size() - 1)) < SegmentationTree.this.minWallReverse);
            if (this.accelDone && this.velDone && this.latvelDone && this.powerDone && this.wallDone && this.moveDone && this.distanceDone && this.distance8Done && this.distance15Done && this.wallReverseDone) {
                return null;
            }
            if (!SegmentationTree.this.standardized) {
                accelMean = this.accelDone ? -1000.0 : (Double)accelArray.get(accelArray.size() / 2);
                velMean = this.velDone ? -1000.0 : (Double)velArray.get(velArray.size() / 2);
                latvelMean = this.latvelDone ? -1000.0 : (Double)latvelArray.get(latvelArray.size() / 2);
                powerMean = this.powerDone ? -1000.0 : (Double)powerArray.get(powerArray.size() / 2);
                wallMean = this.wallDone ? -1000.0 : (Double)wallArray.get(wallArray.size() / 2);
                wallReverseMean = this.wallReverseDone ? -1000.0 : (Double)wallReverseArray.get(wallReverseArray.size() / 2);
                moveMean = this.moveDone ? -1000.0 : (Double)moveArray.get(moveArray.size() / 2);
                distanceMean = this.distanceDone ? -1000.0 : (Double)distanceArray.get(distanceArray.size() / 2);
                distance8Mean = this.distance8Done ? -1000.0 : (Double)distance8Array.get(distance8Array.size() / 2);
                distance15Mean = this.distance15Done ? -1000.0 : (Double)distance15Array.get(distance15Array.size() / 2);
            } else {
                accelMean = this.accelDone ? -1000.0 : FUtils.closestBorder(SegmentationTree.this.ALL_ACCEL, (Double)accelArray.get(accelArray.size() / 2));
                velMean = this.velDone ? -1000.0 : FUtils.closestBorder(SegmentationTree.this.ALL_VEL, (Double)velArray.get(velArray.size() / 2));
                latvelMean = this.latvelDone ? -1000.0 : FUtils.closestBorder(SegmentationTree.this.ALL_VEL, (Double)latvelArray.get(latvelArray.size() / 2));
                powerMean = this.powerDone ? -1000.0 : FUtils.closestBorder(SegmentationTree.this.ALL_POWER, (Double)powerArray.get(powerArray.size() / 2));
                wallMean = this.wallDone ? -1000.0 : FUtils.closestBorder(SegmentationTree.this.ALL_WALL, (Double)wallArray.get(wallArray.size() / 2));
                wallReverseMean = this.wallReverseDone ? -1000.0 : FUtils.closestBorder(SegmentationTree.this.ALL_WALL_REVERSE, (Double)wallReverseArray.get(wallReverseArray.size() / 2));
                moveMean = this.moveDone ? -1000.0 : FUtils.closestBorder(SegmentationTree.this.ALL_TIME, (Double)moveArray.get(moveArray.size() / 2));
                distanceMean = this.distanceDone ? -1000.0 : FUtils.closestBorder(SegmentationTree.this.ALL_DISTANCE, (Double)distanceArray.get(distanceArray.size() / 2));
                distance8Mean = this.distance8Done ? -1000.0 : FUtils.closestBorder(SegmentationTree.this.ALL_DISTANCE8, (Double)distanceArray.get(distance8Array.size() / 2));
                distance15Mean = this.distance15Done ? -1000.0 : FUtils.closestBorder(SegmentationTree.this.ALL_DISTANCE15, (Double)distanceArray.get(distance15Array.size() / 2));
            }
            AccelNode accelNode = this.accelDone ? null : new AccelNode(accelMean);
            MoveTimeNode moveNode = this.moveDone ? null : new MoveTimeNode(moveMean);
            VelNode velNode = this.velDone ? null : new VelNode(velMean);
            LatvelNode latvelNode = this.latvelDone ? null : new LatvelNode(latvelMean);
            PowerNode powerNode = this.powerDone ? null : new PowerNode(powerMean);
            WallNode wallNode = this.wallDone ? null : new WallNode(wallMean);
            WallReverseNode wallReverseNode = this.wallReverseDone ? null : new WallReverseNode(wallReverseMean);
            DistanceNode distanceNode = this.distanceDone ? null : new DistanceNode(distanceMean);
            Distance8Node distance8Node = this.distance8Done ? null : new Distance8Node(distance8Mean);
            Distance15Node distance15Node2 = distance15Node = this.distance15Done ? null : new Distance15Node(distance15Mean);
            if (!this.accelDone) {
                accelNode.fillFactors(this.factors);
            }
            if (!this.moveDone) {
                moveNode.fillFactors(this.factors);
            }
            if (!this.velDone) {
                velNode.fillFactors(this.factors);
            }
            if (!this.latvelDone) {
                latvelNode.fillFactors(this.factors);
            }
            if (!this.powerDone) {
                powerNode.fillFactors(this.factors);
            }
            if (!this.wallDone) {
                wallNode.fillFactors(this.factors);
            }
            if (!this.wallReverseDone) {
                wallReverseNode.fillFactors(this.factors);
            }
            if (!this.distanceDone) {
                distanceNode.fillFactors(this.factors);
            }
            if (!this.distance8Done) {
                distance8Node.fillFactors(this.factors);
            }
            if (!this.distance15Done) {
                distance15Node.fillFactors(this.factors);
            }
            double[] factorsCount = this.getFactorsCount();
            double accel = this.accelDone || FUtils.isConstant(accelArray) ? 0.0 : this.getGain(accelNode, factorsCount);
            double vel = this.velDone || FUtils.isConstant(velArray) ? 0.0 : this.getGain(velNode, factorsCount);
            double latvel = this.latvelDone || FUtils.isConstant(latvelArray) ? 0.0 : this.getGain(latvelNode, factorsCount);
            double dist = this.distanceDone || FUtils.isConstant(distanceArray) ? 0.0 : this.getGain(distanceNode, factorsCount);
            double dist8 = this.distance8Done || FUtils.isConstant(distance8Array) ? 0.0 : this.getGain(distance8Node, factorsCount);
            double dist15 = this.distance15Done || FUtils.isConstant(distance15Array) ? 0.0 : this.getGain(distance15Node, factorsCount);
            double power = this.powerDone || FUtils.isConstant(powerArray) ? 0.0 : this.getGain(powerNode, factorsCount);
            double move = this.moveDone || FUtils.isConstant(moveArray) ? 0.0 : this.getGain(moveNode, factorsCount);
            double wall = this.wallDone || FUtils.isConstant(wallArray) ? 0.0 : this.getGain(wallNode, factorsCount);
            double d = wallReverse = this.wallReverseDone || FUtils.isConstant(wallReverseArray) ? 0.0 : this.getGain(wallReverseNode, factorsCount);
            if (SegmentationTree.this.verbose) {
                System.out.print("Splitting on acceleration...");
            }
            if ((best = accelNode) != null) {
                best.nSeg = new NodeSegmentation(this.nSeg);
                best.nSeg.decisionValue = accelMean;
                best.left.nSeg = new NodeSegmentation(this.nSeg);
                best.right.nSeg = new NodeSegmentation(this.nSeg);
                best.left.nSeg.highAcceleration = accelMean;
                best.right.nSeg.lowAcceleration = accelMean;
            }
            if (vel >= (bestGain = accel) || best == null) {
                if (SegmentationTree.this.verbose) {
                    System.out.print("NO/velocity...");
                }
                best = velNode;
                bestGain = vel;
                if (best != null) {
                    best.nSeg = new NodeSegmentation(this.nSeg);
                    best.nSeg.decisionValue = velMean;
                    best.left.nSeg = new NodeSegmentation(this.nSeg);
                    best.right.nSeg = new NodeSegmentation(this.nSeg);
                    best.left.nSeg.highVelocity = velMean;
                    best.right.nSeg.lowVelocity = velMean;
                }
            }
            if (latvel >= bestGain || best == null) {
                if (SegmentationTree.this.verbose) {
                    System.out.print("NO/lateral velocity...");
                }
                best = latvelNode;
                bestGain = latvel;
                if (best != null) {
                    best.nSeg = new NodeSegmentation(this.nSeg);
                    best.nSeg.decisionValue = latvelMean;
                    best.left.nSeg = new NodeSegmentation(this.nSeg);
                    best.right.nSeg = new NodeSegmentation(this.nSeg);
                    best.left.nSeg.highLateralVelocity = latvelMean;
                    best.right.nSeg.lowLateralVelocity = latvelMean;
                }
            }
            if (dist >= bestGain || best == null) {
                if (SegmentationTree.this.verbose) {
                    System.out.print("NO/distance...");
                }
                best = distanceNode;
                bestGain = dist;
                if (best != null) {
                    best.nSeg = new NodeSegmentation(this.nSeg);
                    best.nSeg.decisionValue = distanceMean;
                    best.left.nSeg = new NodeSegmentation(this.nSeg);
                    best.right.nSeg = new NodeSegmentation(this.nSeg);
                    best.left.nSeg.highDistance = distanceMean;
                    best.right.nSeg.lowDistance = distanceMean;
                }
            }
            if (power >= bestGain || best == null) {
                if (SegmentationTree.this.verbose) {
                    System.out.print("NO/fire power...");
                }
                best = powerNode;
                bestGain = power;
                if (best != null) {
                    best.nSeg = new NodeSegmentation(this.nSeg);
                    best.nSeg.decisionValue = powerMean;
                    best.left.nSeg = new NodeSegmentation(this.nSeg);
                    best.right.nSeg = new NodeSegmentation(this.nSeg);
                    best.left.nSeg.highPower = powerMean;
                    best.right.nSeg.lowPower = powerMean;
                }
            }
            if (move >= bestGain || best == null) {
                if (SegmentationTree.this.verbose) {
                    System.out.print("NO/move time...");
                }
                best = moveNode;
                bestGain = move;
                if (best != null) {
                    best.nSeg = new NodeSegmentation(this.nSeg);
                    best.nSeg.decisionValue = moveMean;
                    best.left.nSeg = new NodeSegmentation(this.nSeg);
                    best.right.nSeg = new NodeSegmentation(this.nSeg);
                    best.left.nSeg.highTime = moveMean;
                    best.right.nSeg.lowTime = moveMean;
                }
            }
            if (wall >= bestGain || best == null) {
                if (SegmentationTree.this.verbose) {
                    System.out.print("NO/wall...");
                }
                best = wallNode;
                bestGain = wall;
                if (best != null) {
                    best.nSeg = new NodeSegmentation(this.nSeg);
                    best.nSeg.decisionValue = wallMean;
                    best.left.nSeg = new NodeSegmentation(this.nSeg);
                    best.right.nSeg = new NodeSegmentation(this.nSeg);
                    best.left.nSeg.highWall = wallMean;
                    best.right.nSeg.lowWall = wallMean;
                }
            }
            if (wallReverse >= bestGain || best == null) {
                if (SegmentationTree.this.verbose) {
                    System.out.print("NO/wall reverse...");
                }
                best = wallReverseNode;
                bestGain = wallReverse;
                if (best != null) {
                    best.nSeg = new NodeSegmentation(this.nSeg);
                    best.nSeg.decisionValue = wallReverseMean;
                    best.left.nSeg = new NodeSegmentation(this.nSeg);
                    best.right.nSeg = new NodeSegmentation(this.nSeg);
                    best.left.nSeg.highWallReverse = wallReverseMean;
                    best.right.nSeg.lowWallReverse = wallReverseMean;
                }
            }
            if (dist8 >= bestGain || best == null) {
                if (SegmentationTree.this.verbose) {
                    System.out.print("NO/distance8...");
                }
                best = distance8Node;
                bestGain = dist8;
                if (best != null) {
                    best.nSeg = new NodeSegmentation(this.nSeg);
                    best.nSeg.decisionValue = distance8Mean;
                    best.left.nSeg = new NodeSegmentation(this.nSeg);
                    best.right.nSeg = new NodeSegmentation(this.nSeg);
                    best.left.nSeg.highDistance8 = distance8Mean;
                    best.right.nSeg.lowDistance8 = distance8Mean;
                }
            }
            if (dist15 >= bestGain || best == null) {
                if (SegmentationTree.this.verbose) {
                    System.out.print("NO/distance15...");
                }
                best = distance15Node;
                bestGain = dist15;
                if (best != null) {
                    best.nSeg = new NodeSegmentation(this.nSeg);
                    best.nSeg.decisionValue = distance15Mean;
                    best.left.nSeg = new NodeSegmentation(this.nSeg);
                    best.right.nSeg = new NodeSegmentation(this.nSeg);
                    best.left.nSeg.highDistance15 = distance15Mean;
                    best.right.nSeg.lowDistance15 = distance15Mean;
                }
            }
            if (SegmentationTree.this.verbose) {
                System.out.println("YES");
            }
            if (bestGain == 0.0) {
                return null;
            }
            try {
                NonPreTerminalNode son;
                if (best.getRight().getCount() > SegmentationTree.this.getRealThreshold() && (son = ((DynamicNode)best.getRight()).split()) != null) {
                    best.setRight(son);
                }
                if (best.getLeft().getCount() > SegmentationTree.this.getRealThreshold() && (son = ((DynamicNode)best.getLeft()).split()) != null) {
                    best.setLeft(son);
                }
            }
            catch (Exception e) {
                System.out.println(e + "\n" + bestGain + best + "\n" + accel + this.accelDone + accelNode + "\n" + vel + this.velDone + velNode + "\n" + latvel + this.latvelDone + latvelNode + "\n" + dist + this.distanceDone + distanceNode + "\n" + power + this.powerDone + powerNode + "\n" + wall + this.wallDone + wallNode + "\n" + move + this.moveDone + moveNode);
            }
            SegmentationTree segmentationTree2 = SegmentationTree.this;
            segmentationTree2.rebuilding = segmentationTree2.rebuilding - 1;
            return best;
        }

        private double getGain(NonPreTerminalNode node, double[] factorsCount) {
            DynamicNode right = (DynamicNode)node.getRight();
            DynamicNode left = (DynamicNode)node.getLeft();
            double[][] seg = new double[2][SegmentationTree.this.GF_ONE + 1];
            seg[0] = right.getFactorsCount();
            seg[1] = left.getFactorsCount();
            return FUtils.informationGain(factorsCount, seg);
        }

        public int getCount() {
            double[] factorsCount = this.getFactorsCount();
            int val = 0;
            int i = 0;
            while (i < SegmentationTree.this.GF_ONE + 1) {
                val = (int)((double)val + factorsCount[i]);
                ++i;
            }
            return val;
        }

        public double[] getFactorsCount() {
            double[] factorsCount = new double[SegmentationTree.this.GF_ONE + 1];
            int i = 0;
            while (i < SegmentationTree.this.GF_ONE + 1) {
                factorsCount[i] = this.factors[i].size();
                ++i;
            }
            return factorsCount;
        }

        public void accept(TreeVisitor v) {
            v.visitPTN(this);
        }
    }

    class Leaf
    implements Serializable {
        private static final long serialVersionUID = 8764985023831432109L;
        private double accel;
        private double velocity;
        private double latvel;
        private double distance;
        private double firePower;
        private double wallIndex;
        private double gf;
        private double moveTime;
        private double weigth;
        private double wallReverse;
        private double distance8;
        private double distance15;

        public Leaf(double accel, double distance, double power, double gf, double latvel, double time, double velocity, double index, double wallReverse, double distance8, double distance15) {
            this.accel = accel;
            this.distance = distance;
            this.firePower = power;
            this.gf = gf;
            this.latvel = Math.abs(latvel);
            this.moveTime = time;
            this.velocity = Math.abs(velocity);
            this.wallIndex = index;
            this.wallReverse = wallReverse;
            this.distance8 = Math.abs(distance8);
            this.distance15 = Math.abs(distance15);
        }

        public double getAccel() {
            return this.accel;
        }

        public double getDistance() {
            return this.distance;
        }

        public double getFirePower() {
            return this.firePower;
        }

        public double getLatvel() {
            return this.latvel;
        }

        public double getVelocity() {
            return this.velocity;
        }

        public double getWallIndex() {
            return this.wallIndex;
        }

        public double getGf() {
            return this.gf;
        }

        public double getMoveTime() {
            return this.moveTime;
        }

        public double getWeigth() {
            return this.weigth;
        }

        public void setWeigth(double weigth) {
            this.weigth = weigth;
        }

        public double getWallReverse() {
            return this.wallReverse;
        }

        public double getDistance15() {
            return this.distance15;
        }

        public double getDistance8() {
            return this.distance8;
        }
    }

    abstract class TreeVisitor
    extends Condition {
        TreeVisitor() {
        }

        public void visitNPTN(NonPreTerminalNode node) {
            if (SegmentationTree.this.verbose) {
                System.out.println(node.left + "|" + node.right);
            }
        }

        public void visitSNPTN(StaticNonPreTerminalNode node) {
        }

        public void visitPTN(PreTerminalNode node) {
            if (SegmentationTree.this.verbose) {
                System.out.println("counts:" + node.getCount());
            }
        }

        public boolean test() {
            return false;
        }
    }

    class TreeLeafVisitor
    extends TreeVisitor {
        protected Leaf leaf;
        protected NonPreTerminalNode father;
        protected boolean done = false;
        protected PreTerminalNode theNode;

        public TreeLeafVisitor(Leaf leaf) {
            this.leaf = leaf;
        }

        public void visitNPTN(NonPreTerminalNode node) {
            this.father = node;
            if (node.goRight(this.leaf)) {
                node.getRight().accept(this);
            } else {
                node.getLeft().accept(this);
            }
        }

        public void visitPTN(PreTerminalNode node) {
            this.theNode = node;
            node.setLeaf(this.leaf);
            this.done = true;
        }

        public PreTerminalNode getNode() {
            while (!this.done) {
            }
            return this.theNode;
        }
    }

    class TreeAddVisitor
    extends TreeLeafVisitor
    implements Runnable {
        private boolean running;

        public TreeAddVisitor(Leaf leaf) {
            super(leaf);
            this.running = false;
        }

        public boolean test() {
            if (!this.running) {
                this.running = true;
                SegmentationTree.this.root.accept(this);
                SegmentationTree.this.me.removeCustomEvent((Condition)this);
            }
            return false;
        }

        public void run() {
            this.running = true;
            SegmentationTree.this.root.accept(this);
            this.running = false;
        }

        public void visitNPTN(NonPreTerminalNode node) {
            this.father = node;
            node.setCount((int)((double)node.getCount() + this.leaf.weigth));
            node.add(this.leaf);
            if (node.goRight(this.leaf)) {
                node.getRight().accept(this);
            } else {
                node.getLeft().accept(this);
            }
        }

        public void visitSNTPN(StaticNonPreTerminalNode node) {
            node.addLeaf(this.leaf);
        }

        public void visitPTN(PreTerminalNode node) {
            if (SegmentationTree.this.dynamicTree) {
                int i = 0;
                while ((double)i < this.leaf.weigth) {
                    node.add(this.leaf);
                    ++i;
                }
            } else {
                node.add(this.leaf);
            }
            node.setCount((int)((double)node.getCount() + this.leaf.weigth));
            if (SegmentationTree.this.rebuild && SegmentationTree.this.dynamicTree && node.getCount() > SegmentationTree.this.getRealThreshold()) {
                NonPreTerminalNode son = ((DynamicNode)node).split();
                if (node.equals(this.father.getRight()) && son != null) {
                    this.father.setRight(son);
                    if (SegmentationTree.this.verbose) {
                        double[] factorsCount = ((DynamicNode)node).getFactorsCount();
                        System.out.println("split" + ((PreTerminalNode)((NonPreTerminalNode)this.father.getRight()).getRight()).getCount() + "/" + ((PreTerminalNode)((NonPreTerminalNode)this.father.getRight()).getLeft()).getCount());
                        double[] factorsCountRight = ((DynamicNode)((NonPreTerminalNode)this.father.getRight()).getRight()).getFactorsCount();
                        double[] factorsCountLeft = ((DynamicNode)((NonPreTerminalNode)this.father.getRight()).getLeft()).getFactorsCount();
                        System.out.print(String.valueOf(FUtils.doubleArrayToString(factorsCount)) + "\n" + FUtils.doubleArrayToString(factorsCountLeft) + "|" + FUtils.doubleArrayToString(factorsCountRight));
                    }
                } else if (son != null) {
                    this.father.setLeft(son);
                    if (SegmentationTree.this.verbose) {
                        double[] factorsCount = ((DynamicNode)node).getFactorsCount();
                        System.out.println("split" + ((PreTerminalNode)((NonPreTerminalNode)this.father.getLeft()).getRight()).getCount() + "/" + ((PreTerminalNode)((NonPreTerminalNode)this.father.getLeft()).getLeft()).getCount());
                        double[] factorsCountRight = ((DynamicNode)((NonPreTerminalNode)this.father.getLeft()).getRight()).getFactorsCount();
                        double[] factorsCountLeft = ((DynamicNode)((NonPreTerminalNode)this.father.getLeft()).getLeft()).getFactorsCount();
                        System.out.print(String.valueOf(FUtils.doubleArrayToString(factorsCount)) + "\n" + FUtils.doubleArrayToString(factorsCountLeft) + "\n" + FUtils.doubleArrayToString(factorsCountRight) + "\n");
                    }
                }
            }
        }
    }

    class TreePeakVisitor
    extends TreeLeafVisitor {
        private int idx;
        private ArrayList factorsList;

        public TreePeakVisitor(Leaf leaf) {
            super(leaf);
            this.factorsList = new ArrayList(15);
        }

        public void visitSNTPN(StaticNonPreTerminalNode node) {
            this.factorsList.add(node.factors);
        }

        public void visitPTN(PreTerminalNode node) {
            node.setLeaf(this.leaf);
            if (!SegmentationTree.this.dynamicTree) {
                this.factorsList.add(((StaticNode)node).factors);
            }
            this.idx = node.getPeak();
        }

        public int getPeak() {
            if (!SegmentationTree.this.dynamicTree) {
                double[][] buffers = (double[][])this.factorsList.toArray();
                double bestVal = 0.0;
                this.idx = (int)((double)SegmentationTree.this.GF_ZERO * 1.2);
                int gf = 0;
                while (gf < SegmentationTree.this.GF_ONE) {
                    double tmp = 0.0;
                    int i = 0;
                    while (i < this.factorsList.size()) {
                        tmp += 1000.0 * buffers[i][gf] / Math.max(1.0, buffers[i][0]) * (double)i;
                        ++i;
                    }
                    if (tmp > bestVal) {
                        bestVal = tmp;
                        this.idx = gf;
                    }
                    ++gf;
                }
            }
            return this.idx;
        }
    }

    class TreeCleanerVisitor
    extends TreeVisitor {
        NonPreTerminalNode father;
        int nptn;
        int ptn;

        TreeCleanerVisitor() {
        }

        public void visitNPTN(NonPreTerminalNode node) {
            ++this.nptn;
            this.father = node;
            if (node.getRight() != null) {
                node.getRight().accept(this);
            }
            if (node.getLeft() != null) {
                node.getLeft().accept(this);
            }
        }

        public void visitPTN(PreTerminalNode node) {
            ++this.ptn;
            if (node.equals(this.father.getRight())) {
                this.father.setRight(null);
            } else {
                this.father.setLeft(null);
            }
        }
    }

    class TreePopulatorVisitor
    extends TreeVisitor {
        TreePopulatorVisitor() {
        }

        public void visitNPTN(NonPreTerminalNode node) {
            if (node.getRight() == null) {
                node.setRight(new StaticNode());
            } else {
                node.getRight().accept(this);
            }
            if (node.getLeft() == null) {
                node.setLeft(new StaticNode());
            } else {
                node.getLeft().accept(this);
            }
        }
    }

    class TreeRebuildVisitor
    extends TreeVisitor
    implements Runnable {
        private NonPreTerminalNode father;
        private int MAX_REBUILD;
        private int MIN_REBUILD;
        private boolean running;
        private double startTime;
        private int heigth;

        TreeRebuildVisitor() {
            this.MAX_REBUILD = SegmentationTree.this.weightedLeaves < 10000 ? SegmentationTree.this.weightedLeaves + 1 : (SegmentationTree.this.weightedLeaves < 25000 ? SegmentationTree.this.threshold * 16 : 0);
            this.MIN_REBUILD = SegmentationTree.this.getRealThreshold();
            this.running = false;
            this.heigth = 0;
        }

        public void run() {
            if (this.MAX_REBUILD < this.MIN_REBUILD) {
                return;
            }
            this.startTime = SegmentationTree.this.me.getTime();
            this.running = true;
            SegmentationTree.this.rebuildingInProcess = true;
            SegmentationTree.this.root.accept(this);
            SegmentationTree.this.rebuildingInProcess = false;
            SegmentationTree.this.bufferingEntry = false;
            this.running = false;
            if (SegmentationTree.this.saveToFile || SegmentationTree.this.showSegementation) {
                TreeSegmentationVisitor v = new TreeSegmentationVisitor();
                v.seg = new Segmentation();
                SegmentationTree.this.root.accept(v);
                System.out.println(v.seg.toString());
                if (SegmentationTree.this.saveToFile) {
                    try {
                        File file = SegmentationTree.this.me.getDataFile("seg");
                        RobocodeFileOutputStream o = new RobocodeFileOutputStream(file);
                        OutputStreamWriter out = new OutputStreamWriter((OutputStream)o);
                        out.write(v.ptnSeg);
                        out.flush();
                        out.close();
                    }
                    catch (Exception e) {
                        System.out.println(e);
                    }
                }
            }
        }

        public boolean test() {
            if (!this.running) {
                this.running = true;
                SegmentationTree.this.root.accept(this);
                SegmentationTree.this.me.removeCustomEvent((Condition)this);
            }
            return false;
        }

        public void visitNPTN(NonPreTerminalNode node) {
            if (SegmentationTree.this.quitThread) {
                return;
            }
            if (node.getCount() < this.MAX_REBUILD && node.getCount() > this.MIN_REBUILD) {
                NonPreTerminalNode theNode;
                if (SegmentationTree.this.verbose) {
                    System.out.println("rebuild");
                }
                DynamicNode newNode = new DynamicNode(node.getLeaves());
                newNode.nSeg = new NodeSegmentation(node.nSeg);
                if (SegmentationTree.this.verbose) {
                    System.out.println(FUtils.doubleArrayToString(newNode.getFactorsCount()));
                }
                if ((theNode = newNode.split()) == null) {
                    return;
                }
                if (this.father == null) {
                    node.setRight(new DynamicNode());
                    node.setLeft(theNode);
                } else if (this.father.getRight().equals(node)) {
                    this.father.setRight(theNode);
                } else if (this.father.getLeft().equals(node)) {
                    this.father.setLeft(theNode);
                }
            } else {
                this.father = node;
                ++this.heigth;
                if (node.getRight() != null) {
                    node.getRight().accept(this);
                }
                if (node.getLeft() != null) {
                    node.getLeft().accept(this);
                }
                --this.heigth;
            }
        }

        public void visitPTN(PreTerminalNode node) {
            try {
                this.visitPTN((DynamicNode)node);
            }
            catch (Exception e) {
                System.out.println("inappropriate use of TreeRebuildVisitor" + e);
            }
        }

        public void visitPTN(DynamicNode node) {
            NonPreTerminalNode son;
            if (node.getCount() > SegmentationTree.this.threshold && (son = node.split()) != null) {
                if (node.equals(this.father.getRight())) {
                    this.father.setRight(son);
                } else if (son != null) {
                    this.father.setLeft(son);
                }
            }
        }
    }

    class TreeCollectorVisitor
    extends TreeVisitor {
        private ArrayList[] leaves;
        private boolean done = false;
        private int count;

        public TreeCollectorVisitor(Node node) {
            this.leaves = new ArrayList[SegmentationTree.this.GF_ONE + 1];
            this.count = node.getCount();
            int i = 0;
            while (i < SegmentationTree.this.GF_ONE + 1) {
                this.leaves[i] = new ArrayList();
                ++i;
            }
        }

        public boolean isDone() {
            return this.done;
        }

        public ArrayList[] getLeaves() {
            return this.leaves;
        }

        public void visitNPTN(NonPreTerminalNode node) {
            if (node.getRight() != null) {
                node.getRight().accept(this);
            }
            if (node.getLeft() != null) {
                node.getLeft().accept(this);
            }
        }

        public void visitPTN(PreTerminalNode node) {
            try {
                this.visitPTN((DynamicNode)node);
            }
            catch (Exception e) {
                System.out.println("inappropriate use of TreeCollectorVisitor" + e);
            }
        }

        public void visitPTN(DynamicNode node) {
            ArrayList[] all = node.getFactors();
            int size = 0;
            int i = 0;
            while (i < all.length) {
                this.leaves[i].addAll(all[i]);
                size += this.leaves[i].size();
                ++i;
            }
            if (this.count == size) {
                this.done = true;
            }
        }
    }

    public class TreeSegmentationVisitor
    extends TreeVisitor {
        Segmentation seg;
        String ptnSeg = "";

        public void visitPTN(PreTerminalNode node) {
            this.ptnSeg = String.valueOf(this.ptnSeg) + node.nSeg.toString() + "\n";
        }

        public void visitNPTN(NonPreTerminalNode node) {
            NonPreTerminalNode node2;
            if (node.getLeft() != null) {
                node.getLeft().accept(this);
            }
            if (node instanceof DistanceNode) {
                node2 = (DistanceNode)node;
                this.seg.addDistance(((DistanceNode)node2).getDistance());
            }
            if (node instanceof PowerNode) {
                node2 = (PowerNode)node;
                this.seg.addPower(((PowerNode)node2).getPower());
            }
            if (node instanceof WallNode) {
                node2 = (WallNode)node;
                this.seg.addWall(((WallNode)node2).getWall());
            }
            if (node instanceof WallReverseNode) {
                node2 = (WallReverseNode)node;
                this.seg.addWallReverse(((WallReverseNode)node2).getWall());
            }
            if (node instanceof VelNode) {
                node2 = (VelNode)node;
                this.seg.addVelocity(((VelNode)node2).getVelocity());
            }
            if (node instanceof LatvelNode) {
                node2 = (LatvelNode)node;
                this.seg.addLateralVelocity(((LatvelNode)node2).getLatvel());
            }
            if (node instanceof MoveTimeNode) {
                node2 = (MoveTimeNode)node;
                this.seg.addMove(((MoveTimeNode)node2).getMoveTime());
            }
            if (node instanceof AccelNode) {
                node2 = (AccelNode)node;
                this.seg.addAcceleration(((AccelNode)node2).getAccel());
            }
            if (node.getRight() != null) {
                node.getRight().accept(this);
            }
        }
    }

    public class TreeSaveSymbolicVisitor
    extends TreeVisitor {
        SymbolicTree right;
        SymbolicTree left;
        SymbolicTree theNode;

        public void visitNPTN(NonPreTerminalNode node) {
            this.theNode = new SymbolicTree(node.code());
            if (node.left != null) {
                TreeSaveSymbolicVisitor visitorLeft = new TreeSaveSymbolicVisitor();
                node.left.accept(visitorLeft);
                this.theNode.setLeft(visitorLeft.theNode);
            }
            if (node.right != null) {
                TreeSaveSymbolicVisitor visitorRight = new TreeSaveSymbolicVisitor();
                node.right.accept(visitorRight);
                this.theNode.setRight(visitorRight.theNode);
            }
        }

        public SymbolicTree getTheNode() {
            return this.theNode;
        }
    }
}

