/*
 * Decompiled with CFR 0.152.
 */
package justin;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import justin.Gun;
import justin.Mallais;
import justin.Scan;
import justin.ScannerV2;
import robocode.AdvancedRobot;
import robocode.HitByBulletEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class Tank
extends Mallais {
    String name;
    boolean alive;
    int turnsTillGunHeatZero;
    double threatLevel;
    ArrayList<Scan> scanList;
    public double[][][][] stats;
    public Gun gun;
    public static final byte MEMSIZE = 100;
    public boolean factorsRestored;
    public int[][][][][][][] statBuffers;
    public static final byte BINS = 29;
    public static final byte MIDDLE_BIN = 14;
    private static final double MAX_ESCAPE_ANGLE = 0.7;
    private static final double BIN_WIDTH = 0.049999999999999996;

    public static void iWasHit(HitByBulletEvent e) {
        Tank t = Tank.get(e.getName());
        t.threatLevel = Math.min(t.threatLevel + e.getPower(), 5.0);
    }

    public static void update(ScannedRobotEvent e, AdvancedRobot bot) {
        Scan oldData;
        Scan newData = new Scan();
        newData.name = e.getName();
        newData.scanTime = bot.getTime() - 1L;
        newData.energy = e.getEnergy();
        newData.speed = e.getVelocity();
        newData.distance = e.getDistance();
        newData.bearing = e.getBearingRadians();
        newData.absBearing = Utils.normalAbsoluteAngle((double)(e.getBearingRadians() + bot.getHeadingRadians()));
        double x = bot.getX() + newData.distance * Math.sin(newData.absBearing);
        double y = bot.getY() + newData.distance * Math.cos(newData.absBearing);
        newData.location = new Point2D.Double(x, y);
        newData.heading = newData.speed < 0.0 ? (e.getHeadingRadians() + Math.PI) % (Math.PI * 2) : e.getHeadingRadians();
        Scan cb = Tank.getClosestBotTo(newData);
        newData.closestBotName = cb.name;
        newData.smallestDistance = newData.location.distance(cb.location);
        double ang = (Utils.normalRelativeAngle((double)(Tank.absoluteBearing(newData.location, cb.location) - newData.heading)) + Math.PI * 3) % (Math.PI * 2);
        newData.closestBotAngle = ang / (Math.PI * 2);
        newData.botCloseDanger = newData.smallestDistance / 4.0;
        if (ang > 5.497787143782138 || ang < 0.7853981633974483) {
            newData.botCloseDanger *= 2.0;
        }
        if (newData.deltaSmallestDistance < 0.0) {
            newData.botCloseDanger *= 2.0;
        }
        if ((oldData = Tank.getScan(newData.name, 0)) == null) {
            oldData = Tank.foundNewBot(newData, bot);
        }
        Tank thisTank = Tank.get(newData.name);
        long sinceScanned = bot.getTime() - 1L - oldData.scanTime;
        thisTank.threatLevel = Math.max(0.0, thisTank.threatLevel - 0.02 * (double)sinceScanned);
        newData.deltaSmallestDistance = newData.smallestDistance - oldData.smallestDistance < 0.0 ? -1 : 1;
        newData.deltaBearing = Utils.normalRelativeAngle((double)(newData.bearing - oldData.bearing));
        newData.forward = newData.speed == 0.0 ? oldData.forward : newData.speed > 0.0;
        newData.heading = newData.forward ? e.getHeadingRadians() : (e.getHeadingRadians() + Math.PI) % (Math.PI * 2);
        newData.deltaHeading = Utils.normalRelativeAngle((double)(newData.heading - oldData.heading));
        newData.accel = (int)Math.signum(Math.abs(newData.speed) - Math.abs(oldData.speed));
        newData.runTime = oldData.speed == newData.speed ? oldData.runTime + (double)sinceScanned : 0.0;
        newData.fireLocation = Tank.myData.location;
        newData.lateralDirection = newData.speed != 0.0 ? Math.signum(newData.speed * Math.sin(e.getHeadingRadians() - newData.absBearing)) : oldData.lateralDirection;
        newData.waveSpeed = Tank.bulletVelocity(1.9);
        newData.distanceTraveled = 0.0;
        newData.buffer = Tank.setSegmentations(newData, oldData, thisTank, bot, myData);
        thisTank.scanList.add(newData);
    }

    public static Scan foundNewBot(Scan newData, AdvancedRobot bot) {
        Tank newTank = Tank.get(newData.name);
        if (newTank == null) {
            newTank = new Tank();
            newTank.threatLevel = 0.0;
            newTank.turnsTillGunHeatZero = 27;
            newTank.gun = new Gun(bot);
            newTank.gun.initRound();
            newTank.statBuffers = new int[7][5][3][5][3][7][29];
            newTank.scanList = new ArrayList();
            tank.add(newTank);
        } else {
            newTank.turnsTillGunHeatZero = Math.max(0, newTank.turnsTillGunHeatZero - 1);
            newTank.threatLevel = 0.0;
        }
        newTank.name = newData.name;
        newTank.alive = true;
        newTank.scanList.add(newData);
        newData.botCloseDanger = 0.0;
        newData.deltaSmallestDistance = 1.0;
        newData.forward = true;
        newData.runTime = 0.0;
        newData.accel = 0;
        long sinceScanned = bot.getTime();
        newData.deltaHeading = 0.0;
        newData.deltaBearing = 0.08;
        newData.accel = 0;
        newData.lateralDirection = 1.0;
        if (target == null | targetScan == null) {
            target = newTank;
            targetScan = newData;
        }
        if (ScannerV2.Lf == null | ScannerV2.Lfscan == null) {
            ScannerV2.Lf = newTank;
            ScannerV2.Lfscan = newData;
        }
        return newData;
    }

    public static Tank get(String aName) {
        Tank t = new Tank();
        int i = 0;
        while (i < tank.size()) {
            t = (Tank)((Object)tank.get(i));
            if (t.name == aName) {
                return t;
            }
            ++i;
        }
        return null;
    }

    public static void newRound() {
        Tank t = new Tank();
        int i = 0;
        while (i < tank.size()) {
            t = (Tank)((Object)tank.get(i));
            t.alive = false;
            t.scanList.clear();
            ++i;
        }
    }

    public static Scan getScan(String aName, int indexAge) {
        Tank t = Tank.get(aName);
        if (t == null) {
            return null;
        }
        if (t.scanList.size() - 1 + indexAge < 0) {
            return null;
        }
        Scan s = t.scanList.get(t.scanList.size() - 1 + indexAge);
        while (t.scanList.size() > 100) {
            t.scanList.remove(0);
        }
        return s;
    }

    public static void updateSelf(AdvancedRobot bot) {
        myTank = Tank.get(bot.getName());
        if (myTank == null) {
            myTank = new Tank();
            Tank.myTank.scanList = new ArrayList();
            Tank.myTank.statBuffers = new int[7][5][3][5][3][7][29];
            tank.add(myTank);
        }
        Tank.myTank.name = bot.getName();
        Tank.myTank.alive = true;
        Tank.myTank.turnsTillGunHeatZero = (int)(bot.getGunHeat() / bot.getGunCoolingRate());
        myData = new Scan();
        Tank.myData.name = Tank.myTank.name;
        Tank.myData.scanTime = bot.getTime() - 1L;
        Tank.myData.energy = bot.getEnergy();
        Tank.myData.speed = bot.getVelocity();
        Tank.myData.heading = Tank.myData.speed < 0.0 ? (bot.getHeadingRadians() + Math.PI) % (Math.PI * 2) : bot.getHeadingRadians();
        Tank.myData.location = new Point2D.Double(bot.getX(), bot.getY());
        Scan cb = Tank.getClosestBotTo(myData);
        Tank.myData.closestBotName = cb.name;
        Tank.myData.smallestDistance = Tank.myData.location.distance(cb.location);
        Scan oldData = Tank.getScan(Tank.myData.name, 0);
        if (oldData != null) {
            Tank.myData.forward = Tank.myData.speed == 0.0 ? oldData.forward : Tank.myData.speed > 0.0;
            Tank.myData.heading = Tank.myData.forward ? bot.getHeadingRadians() : (bot.getHeadingRadians() + Math.PI) % (Math.PI * 2);
            Tank.myData.deltaHeading = Utils.normalRelativeAngle((double)(Tank.myData.heading - oldData.heading));
            if (oldData.speed == Tank.myData.speed) {
                Tank.myData.runTime = oldData.runTime + 1.0;
                Tank.myData.accel = 0;
            } else {
                Tank.myData.runTime = 0.0;
                Tank.myData.accel = (int)Math.signum(Math.abs(Tank.myData.speed) - Math.abs(oldData.speed));
            }
        }
        if (targetScan != null) {
            Tank.myData.fireLocation = Tank.targetScan.location;
            Tank.myData.lateralDirection = Tank.myData.speed != 0.0 ? Math.signum(Tank.myData.speed * Math.sin(Tank.myData.heading - Tank.absoluteBearing(Tank.targetScan.location, Tank.myData.location))) : oldData.lateralDirection;
            Tank.myData.waveSpeed = Tank.bulletVelocity(1.9);
            Tank.myData.bulletFired = Tank.target.turnsTillGunHeatZero < 2;
            Tank.myData.distanceTraveled = 0.0;
            Tank.myData.buffer = Tank.setSegmentations(myData, oldData, myTank, bot, targetScan);
        } else {
            Tank.myData.waveSpeed = 0.0;
        }
        Tank.myTank.scanList.add(myData);
        while (Tank.myTank.scanList.size() > 100) {
            Tank.myTank.scanList.remove(0);
        }
    }

    public static boolean allBotsAlive() {
        Tank t = new Tank();
        int i = 1;
        while (i < tank.size()) {
            t = (Tank)((Object)tank.get(i));
            if (t == null | !t.alive) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static double nearestEnemyDistance(AdvancedRobot bot) {
        return Tank.smallestDistance(bot.getName());
    }

    public static double smallestDistance(String name) {
        double smallestDist = Double.POSITIVE_INFINITY;
        int q = 1;
        while (q < tank.size()) {
            Tank t = (Tank)((Object)tank.get(q));
            if (t.alive && t.name != name) {
                Scan s = t.scanList.get(t.scanList.size() - 1);
                double dist = s.location.distance(Tank.getScan((String)name, (int)0).location);
                if (dist < smallestDist) {
                    smallestDist = dist;
                }
            }
            ++q;
        }
        return smallestDist;
    }

    public static Scan nearestEnemy(AdvancedRobot bot) {
        return Tank.getClosestBotTo(myData);
    }

    public static Scan getClosestBotTo(Scan reference) {
        Scan closestScan = myData;
        double smallestDist = Double.POSITIVE_INFINITY;
        int q = 1;
        while (q < tank.size()) {
            Tank t = (Tank)((Object)tank.get(q));
            if (t.alive && t.name != reference.name) {
                Scan s = t.scanList.get(t.scanList.size() - 1);
                double dist = s.location.distance(reference.location);
                if (dist < smallestDist) {
                    closestScan = s;
                    smallestDist = dist;
                }
            }
            ++q;
        }
        return closestScan;
    }

    public static double mostVisitedBearingOffset(Scan w, AdvancedRobot bot) {
        return w.lateralDirection * 0.049999999999999996 * (double)(Tank.mostVisitedBin(w, bot) - 14);
    }

    private static int mostVisitedBin(Scan w, AdvancedRobot bot) {
        int mostVisited = 14;
        int i = 0;
        while (i < 29) {
            int x1 = i * 4 + 100;
            int y1 = 100;
            int x2 = i * 4 + 100;
            int y2 = 101 + w.buffer[i];
            if (w.buffer[i] > w.buffer[mostVisited]) {
                mostVisited = i;
            }
            ++i;
        }
        return mostVisited;
    }

    public static int[] setSegmentations(Scan current, Scan oldData, Tank t, AdvancedRobot robot, Scan owner) {
        int distanceIndex = (int)(Tank.limit(0.0, current.location.distance(owner.location), 900.0) / 900.0 * 6.0);
        int velocityIndex = (int)Tank.limit(0.0, (int)Math.abs(current.speed / 2.0), 4.0);
        int lastVelocityIndex = (int)Tank.limit(0.0, (int)Math.abs(oldData.speed / 2.0), 4.0);
        int accel = current.accel + 1;
        double bw = robot.getBattleFieldWidth();
        double bh = robot.getBattleFieldHeight();
        double maxWDist = 375.0;
        double distV = 0.0;
        double distH = 0.0;
        distV = current.heading == 1.5707963267948966 || current.heading == 4.71238898038469 ? Double.POSITIVE_INFINITY : (current.heading < 1.5707963267948966 || current.heading > 4.71238898038469 ? (bh - current.location.y) / Math.cos(current.heading) : current.location.y / Math.cos(current.heading - Math.PI));
        distH = current.heading == Math.PI || current.heading == 0.0 ? Double.POSITIVE_INFINITY : (current.heading < Math.PI ? (bw - current.location.x) / Math.cos(current.heading - 1.5707963267948966) : current.location.x / Math.cos(current.heading - 4.71238898038469));
        int dtwf = (int)Tank.limit(0.0, (1.0 - Math.min(Math.min(distV, distH), maxWDist) / maxWDist) * 5.0, 4.0);
        double h1 = (current.heading + Math.PI) % (Math.PI * 2);
        if (h1 < 0.0) {
            h1 += Math.PI * 2;
        }
        distV = h1 == 1.5707963267948966 || h1 == 4.71238898038469 ? Double.POSITIVE_INFINITY : (h1 < 1.5707963267948966 || h1 > 4.71238898038469 ? (bh - current.location.y) / Math.cos(h1) : current.location.y / Math.cos(h1 - Math.PI));
        distH = h1 == Math.PI || h1 == 0.0 ? Double.POSITIVE_INFINITY : (h1 < Math.PI ? (bw - current.location.x) / Math.cos(h1 - 1.5707963267948966) : current.location.x / Math.cos(h1 - 4.71238898038469));
        int dtwb = (int)Math.min(2.0, (1.0 - Math.min(Math.min(distV, distH), maxWDist) / maxWDist) * 3.0);
        int angleToMe = (int)(Math.abs(Utils.normalRelativeAngle((double)(current.heading - owner.heading - current.bearing))) / Math.PI * 6.0);
        int runTime = (int)Math.min(current.runTime, 37.0) / 37 * 4;
        if (current.name == robot.getName()) {
            dtwf = 0;
            dtwb = 0;
        }
        return t.statBuffers[distanceIndex][velocityIndex][accel][runTime][dtwb][angleToMe];
    }

    public static void updateWaves(AdvancedRobot bot) {
        int i = 0;
        while (i < tank.size()) {
            Tank t = (Tank)((Object)tank.get(i));
            if (t != null & t.alive & t.scanList.size() > 1) {
                int z = 1;
                while (z < t.scanList.size()) {
                    Scan w = t.scanList.get(z);
                    if (w.waveSpeed != 0.0) {
                        w.distanceTraveled += w.waveSpeed;
                        Scan currentData = Tank.getScan(w.name, 0);
                        if (w.distanceTraveled > currentData.location.distance(w.fireLocation) - 18.0 && bot.getTime() > 15L && t.alive) {
                            byte binHit = Tank.currentBin(w, currentData);
                            byte bin = 0;
                            while (bin < 29) {
                                w.buffer[bin] = binHit == bin ? (int)Tank.rollingAvg(w.buffer[bin], 50.0, 30.0, 1.0) : (int)Tank.rollingAvg(w.buffer[bin], 0.0, 30.0, 0.01);
                                bin = (byte)(bin + 1);
                            }
                        }
                    }
                    ++z;
                }
            }
            ++i;
        }
    }

    public static byte currentBin(Scan tankData, Scan currentData) {
        byte bin = (byte)Math.round(Utils.normalRelativeAngle((double)(Tank.absoluteBearing(tankData.fireLocation, currentData.location) - Tank.absoluteBearing(tankData.fireLocation, tankData.location))) / (tankData.lateralDirection * 0.049999999999999996) + 14.0);
        return (byte)Tank.limit(0.0, bin, 28.0);
    }

    public static void drawTargetWave(AdvancedRobot bot) {
        if (Tank.myTank.scanList.size() > 1) {
            int x = 1;
            while (x < Tank.myTank.scanList.size()) {
                Scan data = Tank.myTank.scanList.get(x);
                if (data.waveSpeed != 0.0 && data.bulletFired) {
                    double offset = Tank.mostVisitedBearingOffset(data, bot);
                    double angle = Utils.normalRelativeAngle((double)(Tank.absoluteBearing(data.fireLocation, data.location) + offset));
                    Point2D.Double double_ = Tank.project(data.fireLocation, angle, data.distanceTraveled);
                }
                ++x;
            }
        }
    }

    static double rollingAvg(double value, double newEntry, double n, double weighting) {
        return (value * n + newEntry * weighting) / (n + weighting);
    }

    static double bulletVelocity(double power) {
        return 20.0 - 3.0 * power;
    }

    public static double limit(double min, double value, double max) {
        return Math.max(min, Math.min(value, max));
    }

    public static Point2D.Double project(Point2D.Double sourceLocation, double angle, double length) {
        return new Point2D.Double(sourceLocation.x + Math.sin(angle) * length, sourceLocation.y + Math.cos(angle) * length);
    }
}

