/*
 * Decompiled with CFR 0.152.
 */
package benhorner.utility.units;

import benhorner.utility.units.Distance;
import benhorner.utility.units.Duration;
import benhorner.utility.units.Heading;
import benhorner.utility.units.Location;
import benhorner.utility.units.Units;
import benhorner.utility.units.Velocity;

public class RelativeLocation {
    private Distance x;
    private Distance y;

    public RelativeLocation(Location source, Location target) {
        this.x = target.getX().subtract(source.getX());
        this.y = target.getY().subtract(source.getY());
    }

    public RelativeLocation(Heading heading, Distance distance) {
        this.x = distance.multiply(Units.sin(heading.toAngle()));
        this.y = distance.multiply(Units.cos(heading.toAngle()));
    }

    public RelativeLocation(Heading heading, double distance) {
        this(heading, new Distance(distance));
    }

    public Distance getX() {
        return this.x;
    }

    public Distance getY() {
        return this.y;
    }

    public Distance getDistance() {
        double x_len = this.x.toDouble();
        double y_len = this.y.toDouble();
        return new Distance(Math.sqrt(x_len * x_len + y_len * y_len));
    }

    public Heading getHeading() {
        return new Heading(Units.atan2(this.x, this.y));
    }

    public Velocity divide(Duration duration) {
        return new Velocity(this.getHeading(), this.getDistance().divide(duration));
    }

    public String toString() {
        return "<" + this.x + ", " + this.y + ">";
    }

    public boolean equals(Object o) {
        boolean result;
        boolean bl = result = o.getClass() == this.getClass();
        if (result) {
            RelativeLocation rl = (RelativeLocation)o;
            result = rl.x.equals(this.x) && rl.y.equals(this.y);
        }
        return result;
    }

    public int hashCode() {
        return this.x.hashCode() * 31 + this.y.hashCode();
    }
}

