/*
 * Decompiled with CFR 0.152.
 */
package catcat20.atom.rader;

import catcat20.atom.robot.Bot;
import catcat20.atom.robot.BotState;
import catcat20.atom.utils.HConstants;
import catcat20.atom.utils.HUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import robocode.AdvancedRobot;
import robocode.RobotDeathEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.TeamRobot;
import robocode.util.Utils;

public class AtomRader {
    public TeamRobot robot;
    public static Bot nearestBot;
    public static long dirChangeTime;
    public static ArrayList<BotState> oldMyStates;
    public static BotState currentMyState;
    public static HashMap<String, Bot> enemies;
    static LinkedHashMap<String, Double> enemyHashMap;
    static double scanDir;
    static Object sought;
    private static double power;
    static double[] POWERS;

    public AtomRader(TeamRobot robot) {
        this.robot = robot;
        nearestBot = null;
        enemies = new HashMap();
    }

    public void init() {
        scanDir = 1.0;
        enemyHashMap = new LinkedHashMap(5, 2.0f, true);
        for (Bot bot : enemies.values()) {
            bot.alive = false;
            bot.currentState = null;
            bot.botStateLogs = new ArrayList();
            bot.lastFlattenerEnable = false;
        }
        oldMyStates = new ArrayList();
    }

    public void onTick() {
        Point2D.Double myPos = new Point2D.Double(this.robot.getX(), this.robot.getY());
        BotState myState = new BotState(this.robot.getTime(), this.robot.getEnergy(), myPos, this.robot.getVelocity(), this.robot.getHeadingRadians());
        oldMyStates.add(0, myState);
        if (currentMyState != null) {
            myState.currentGF = AtomRader.currentMyState.currentGF;
        }
        currentMyState = myState;
        if (this.robot.getOthers() > 1) {
            this.robot.setTurnRadarRightRadians(scanDir * Double.POSITIVE_INFINITY);
        } else if (nearestBot != null && AtomRader.nearestBot.currentState != null) {
            this.oneRadar(myPos, nearestBot);
        }
        Graphics2D g = this.robot.getGraphics();
        double others = this.robot.getOthers();
        String myName = this.robot.getName();
        double nearestDistance = Double.POSITIVE_INFINITY;
        for (Bot bot : enemies.values()) {
            double radius;
            BotState nbState;
            BotState state;
            if (!bot.alive) continue;
            bot.tickUpdate(this.robot);
            g.setColor(Color.white);
            g.drawString("heat:" + bot.gunHeat, (int)bot.currentState.getPosition().x - 15, (int)bot.currentState.getPosition().y - 36 - 15);
            double distance = bot.currentState.getPosition().distance(myPos);
            if (distance < nearestDistance) {
                nearestDistance = distance;
                nearestBot = bot;
            }
            if ((state = bot.currentState) == null) continue;
            Bot nearBot = AtomRader.getBot(bot.nearestBotName);
            if (nearBot != null) {
                nbState = nearBot.currentState;
                if (nbState == null) continue;
                radius = nbState.getPosition().distance(state.getPosition());
                g.setColor(new Color(255, 0, 0, 60));
                g.fillOval((int)(state.getPosition().x - radius), (int)(state.getPosition().y - radius), (int)(radius * 2.0), (int)(radius * 2.0));
                continue;
            }
            if (!bot.nearestBotName.equals(myName) || (nbState = myState) == null) continue;
            radius = nbState.getPosition().distance(state.getPosition());
            g.setColor(new Color(255, 0, 0, 60));
            g.fillOval((int)(state.getPosition().x - radius), (int)(state.getPosition().y - radius), (int)(radius * 2.0), (int)(radius * 2.0));
        }
        this.updatePower();
        g.setColor(Color.white);
        g.drawString("power:" + AtomRader.calculatePower(), (int)myPos.x - 15, (int)myPos.y - 36 - 15);
    }

    public double nearestAntiBasicSurferPower(double power) {
        double bestDistance = Double.POSITIVE_INFINITY;
        double bestPower = 1.95;
        for (int i = 0; i < POWERS.length; ++i) {
            double dist = Math.abs(power - POWERS[i]);
            if (!(dist < bestDistance)) continue;
            bestPower = POWERS[i];
            bestDistance = dist;
        }
        return bestPower;
    }

    public void updatePower() {
        power = 1.95;
        Point2D.Double myPos = new Point2D.Double(this.robot.getX(), this.robot.getY());
        int others = this.robot.getOthers();
        if (nearestBot != null && AtomRader.nearestBot.currentState != null) {
            double distance = AtomRader.nearestBot.currentState.getPosition().distance(myPos);
            if (others <= 1) {
                BotState en = AtomRader.nearestBot.currentState;
                power = 1.95;
                if (en != null) {
                    power = nearestBot.predictNextPower(this.robot, 1.95) + 0.05;
                    if (this.robot.getEnergy() <= 8.0) {
                        power = 0.1;
                    }
                    if (distance <= 325.0) {
                        power = 2.45;
                    }
                    if (distance <= 260.0) {
                        power = 2.95;
                    }
                    if (distance <= 110.0) {
                        power = 3.0;
                    }
                    double minimumKillPower = 0.001 + en.getEnergy() / 4.0;
                    if (en.getEnergy() > 4.0) {
                        minimumKillPower = 0.001 + (en.getEnergy() + 2.0) / 6.0;
                    }
                    power = Math.min(minimumKillPower, power);
                    power = Math.min(power, this.robot.getEnergy() - 0.15);
                }
                power = this.nearestAntiBasicSurferPower(power);
            } else {
                power = 1.95;
                BotState en = AtomRader.nearestBot.currentState;
                if (this.robot.getEnergy() <= 16.0) {
                    power = 1.05;
                }
                if (this.robot.getEnergy() <= 8.0) {
                    power = 0.1;
                }
                if (en != null) {
                    if (distance >= 650.0) {
                        power = 1.05;
                    }
                    if (others >= 5) {
                        power = 2.45;
                    } else if (others >= 2) {
                        power = 0.95 + (double)others * 0.2;
                    }
                    if (distance <= 275.0) {
                        power = 2.999999;
                    }
                    if (distance <= 175.0) {
                        power = 3.0;
                    }
                }
                double minimumKillPower = 0.001 + en.getEnergy() / 4.0;
                if (en.getEnergy() > 4.0) {
                    minimumKillPower = 0.001 + (en.getEnergy() + 2.0) / 6.0;
                }
                power = Math.min(minimumKillPower, power);
                power = Math.min(this.robot.getEnergy() - 0.05, power);
            }
        }
    }

    public static double calculatePower() {
        return power;
    }

    public void oneRadar(Point2D.Double myPos, Bot bot) {
        double angleToEnemy = HUtils.absoluteBearing(myPos, bot.currentState.getPosition());
        double radarTurn = Utils.normalRelativeAngle((double)(angleToEnemy - this.robot.getRadarHeadingRadians()));
        double extraTurn = Math.min(Math.atan(36.0 / myPos.distance(bot.currentState.getPosition())), Rules.RADAR_TURN_RATE_RADIANS);
        radarTurn = radarTurn < 0.0 ? (radarTurn -= extraTurn) : (radarTurn += extraTurn);
        this.robot.setTurnRadarRightRadians(radarTurn);
    }

    public static Bot getBot(String name) {
        return enemies.get(name);
    }

    public void onScannedRobotEvent(ScannedRobotEvent e) {
        if (!enemies.containsKey(e.getName())) {
            enemies.put(e.getName(), new Bot((AdvancedRobot)this.robot));
        }
        if (!AtomRader.enemies.get((Object)e.getName()).alive) {
            AtomRader.enemies.get((Object)e.getName()).gunHeat = 3.0 - HConstants.GUN_COOLING_RATE * (double)(e.getTime() + 2L);
        }
        AtomRader.enemies.get((Object)e.getName()).alive = true;
        enemies.get(e.getName()).scannedUpdate(this.robot, e);
        AtomRader.enemies.get((Object)e.getName()).lastScanTime = e.getTime();
        String name = e.getName();
        LinkedHashMap<String, Double> ehm = enemyHashMap;
        ehm.put(name, this.robot.getHeadingRadians() + e.getBearingRadians());
        if ((name == sought || sought == null) && ehm.size() == this.robot.getOthers()) {
            scanDir = Utils.normalRelativeAngle((double)(ehm.values().iterator().next() - this.robot.getRadarHeadingRadians()));
            sought = ehm.keySet().iterator().next();
        }
    }

    public void onRobotDeath(RobotDeathEvent e) {
        enemyHashMap.remove(e.getName());
        sought = null;
        if (enemies.containsKey(e.getName())) {
            AtomRader.enemies.get((Object)e.getName()).alive = false;
        }
    }

    static {
        POWERS = new double[]{0.15, 0.25, 0.35, 0.45, 0.65, 0.85, 0.95, 1.15, 1.95, 2.95};
        power = 1.95;
    }
}

