/*
 * Decompiled with CFR 0.152.
 */
package dsekercioglu.roboneural.format;

import dsekercioglu.roboneural.net.ActivationFunction;
import dsekercioglu.roboneural.net.Gaussian;

public class FeatureSplitter {
    static ActivationFunction gaussian = new Gaussian();

    public static double[] split(double[] data, int[] fNum) {
        int size = 0;
        for (int i = 0; i < fNum.length; ++i) {
            size += fNum[i];
        }
        if (size == 0) {
            return data;
        }
        double[] fData = new double[size];
        int i = 0;
        for (int j = 0; j < data.length; ++j) {
            double split = 1.0 / (double)(fNum[j] - 1);
            for (int k = 0; k < fNum[j]; ++k) {
                double splitk = split * (double)k;
                fData[i] = gaussian.getValue((data[j] - splitk) * (double)fNum[j]);
                ++i;
            }
        }
        return fData;
    }

    public static double[] kernelTrick(double[] data, int fNum, boolean linearClassification) {
        int i;
        double[] fData = new double[fNum + (linearClassification ? data.length : 0)];
        double sumOfSquares = 0.0;
        for (i = 0; i < data.length; ++i) {
            sumOfSquares += FeatureSplitter.sq(data[i]);
        }
        for (i = 0; i < fNum; ++i) {
            fData[i] = sumOfSquares;
        }
        if (linearClassification) {
            for (i = fNum; i < fData.length; ++i) {
                fData[i] = data[i - fNum];
            }
        }
        return fData;
    }

    private static double sq(double x) {
        return x * x;
    }
}

