/*
 * Decompiled with CFR 0.152.
 */
package zzx;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import robocode.AdvancedRobot;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitWallEvent;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;
import robocode.util.Utils;

public class StormHead
extends AdvancedRobot {
    static double stableRoundsWin = 0.0;
    static double stableRoundsDeath = 0.0;
    double i;
    int c = 0;
    static double b;
    static double reversePercentage;
    double timeC;
    static double totalHit;
    static double winCount;
    static double deathCount;
    static double totalMiss;
    static double randomGunAngle;
    double turn;
    double gunTurn;
    double bulletCount = 0.0;
    static double moveDirection;
    static double turnDirection;
    double previousEnergy = 100.0;
    double bulletPower = 2.0;
    double sBulletPower;
    int scannedX = Integer.MIN_VALUE;
    int scannedY = Integer.MIN_VALUE;
    int myX = Integer.MIN_VALUE;
    int myY = Integer.MIN_VALUE;
    int enemyDistance = 0;
    int enemyVelocity = 0;
    double myHitCount = 0.0;
    double myMissCount = 0.0;
    public double wallStick = 180.0;
    double gunTime;
    static double directCount;
    static double predictCount;
    static double waveCount;
    static double distanceCount;
    static double randomCount;
    static boolean newRandomGun;
    static boolean predictGunCounter;
    static boolean directGunCounter;
    static boolean waveGunCounter;
    static boolean randomGunCounter;
    static boolean distanceWaveCounter;
    double moveAmount = 10.0 * moveDirection;
    boolean wallReversing = true;
    boolean wallRunning = false;
    public Point2D.Double myLocation;
    public Point2D.Double predictedLocation;

    static {
        reversePercentage = 20.0;
        moveDirection = 1.0;
        turnDirection = 1.0;
    }

    public void run() {
        this.setBodyColor(new Color(0, 4, 34));
        this.setGunColor(new Color(178, 191, 160));
        this.setRadarColor(new Color(171, 161, 149));
        this.setBulletColor(new Color(245, 145, 27));
        this.setScanColor(new Color(213, 156, 165));
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        while (true) {
            this.turnRadarRight(90.0);
        }
    }

    public void gun() {
        Graphics2D g = this.getGraphics();
        g.setColor(Color.white);
        ((Graphics)g).drawString("PG  " + predictCount, 0, 70);
        ((Graphics)g).drawString("DG  " + directCount, 0, 90);
        ((Graphics)g).drawString("WG  " + waveCount, 0, 110);
        ((Graphics)g).drawString("DWG  " + distanceCount, 0, 130);
        ((Graphics)g).drawString("RG  " + randomCount, 0, 150);
    }

    public void randomGun(ScannedRobotEvent e) {
        double predictive = 12.5;
        double directWave = 50.0;
        double wave = 17.0;
        double distanceWave2 = 22.0;
        double random = Math.random() * 40.0 + 12.0;
        double randomAngle = Math.random() * 50.0;
        if (randomAngle < 10.0) {
            randomGunAngle = predictive;
            predictGunCounter = true;
            directGunCounter = false;
            waveGunCounter = false;
            distanceWaveCounter = false;
            randomGunCounter = false;
        }
        if (randomAngle >= 10.0 && randomAngle < 20.0) {
            randomGunAngle = directWave;
            directGunCounter = true;
            predictGunCounter = false;
            waveGunCounter = false;
            distanceWaveCounter = false;
            randomGunCounter = false;
        }
        if (randomAngle >= 20.0 && randomAngle < 30.0) {
            randomGunAngle = wave;
            waveGunCounter = true;
            directGunCounter = false;
            predictGunCounter = false;
            distanceWaveCounter = false;
            randomGunCounter = false;
        }
        if (randomAngle > 30.0 && randomAngle < 40.0) {
            randomGunAngle = distanceWave2;
            distanceWaveCounter = true;
            randomGunCounter = false;
            directGunCounter = false;
            predictGunCounter = false;
            waveGunCounter = false;
        }
        if (randomAngle >= 40.0) {
            randomGunAngle = random;
            randomGunCounter = true;
            distanceWaveCounter = false;
            directGunCounter = false;
            predictGunCounter = false;
            waveGunCounter = false;
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        double goalDirection;
        if (e.getVelocity() == 0.0) {
            randomGunAngle = 15.0;
        } else {
            this.randomGun(e);
        }
        double absoluteBearing = e.getBearingRadians() + this.getHeadingRadians();
        double latVel = e.getVelocity() * Math.sin(e.getHeadingRadians() - absoluteBearing);
        this.setTurnRadarRightRadians(Utils.normalRelativeAngle((double)(absoluteBearing - this.getRadarHeadingRadians())) * 2.0);
        this.gunTurn = Utils.normalRelativeAngle((double)(absoluteBearing - this.getGunHeadingRadians() + latVel / randomGunAngle));
        this.setTurnGunRightRadians(this.gunTurn);
        this.goTo(e);
        this.gun();
        this.randomGun(e);
        this.corner(e);
        this.bulletManage();
        if (e.getEnergy() < 5.0) {
            this.fire(this.sBulletPower);
        } else {
            this.fire(this.bulletPower);
        }
        double changeInEnergy = this.previousEnergy - e.getEnergy();
        if (changeInEnergy > 0.0) {
            this.setAhead(100.0 * moveDirection);
            if (Math.random() > 24.0) {
                moveDirection *= -1.0;
            }
        }
        this.previousEnergy = e.getEnergy();
        if (this.wallRunning) {
            goalDirection = e.getBearing() - 90.0;
            this.setTurnRightRadians(this.getWallSmoothedTurn(Math.toRadians(goalDirection)));
        }
        if (this.wallReversing) {
            double turn;
            this.wallStick = 120.0 + Math.random() * 40.0;
            goalDirection = absoluteBearing - 1.5707963267948966 * moveDirection;
            goalDirection += (Math.random() - 0.5) * (Math.random() * 2.0 + 1.0);
            double x = this.getX();
            double y = this.getY();
            double smooth = 0.0;
            Rectangle2D.Double fieldRect = new Rectangle2D.Double(18.0, 18.0, this.getBattleFieldWidth() - 36.0, this.getBattleFieldHeight() - 36.0);
            while (!fieldRect.contains(x + Math.sin(goalDirection) * this.wallStick, y + Math.cos(goalDirection) * this.wallStick)) {
                goalDirection += moveDirection * 0.1;
                smooth += 0.1;
            }
            if (smooth > 0.5 + Math.random() * 0.125) {
                moveDirection = -moveDirection;
            }
            if (Math.abs(turn = Utils.normalRelativeAngle((double)(goalDirection - this.getHeadingRadians()))) > 1.5707963267948966) {
                turn = Utils.normalRelativeAngle((double)(turn + Math.PI));
                this.setBack(100.0);
            } else {
                this.setAhead(100.0);
            }
            this.setTurnRightRadians(turn);
        }
    }

    public double getWallSmoothedTurn(double t) {
        double wSD = 20.0;
        double turn = t;
        double predictiveDistance = 100.0;
        double ourHeading = this.getHeadingRadians();
        if (moveDirection == -1.0) {
            ourHeading += Math.PI;
        }
        Rectangle2D.Double bounds = new Rectangle2D.Double(wSD, wSD, this.getBattleFieldWidth() - 2.0 * wSD, this.getBattleFieldHeight() - 2.0 * wSD);
        while (true) {
            double finishY;
            double totalTurn = turn + ourHeading;
            double dXTravel = Math.sin(totalTurn) * predictiveDistance;
            double dYTravel = Math.cos(totalTurn) * predictiveDistance;
            double finishX = this.getX() + dXTravel;
            if (bounds.contains(finishX, finishY = this.getY() + dYTravel)) {
                return turn;
            }
            turn += 0.1 * moveDirection;
        }
    }

    public void goTo(ScannedRobotEvent e) {
        Graphics2D g = this.getGraphics();
        g.setColor(Color.green);
        double x = this.getX();
        double y = this.getY();
        double changeInEnergy = this.previousEnergy - e.getEnergy();
        if (Math.random() > 0.92) {
            moveDirection *= -1.0;
        }
        if (changeInEnergy >= 0.1 && changeInEnergy <= 3.0) {
            this.myLocation = new Point2D.Double(x, y);
            double predictedX = (x + 100.0) * moveDirection;
            double predictedY = (y + 100.0) * moveDirection;
            this.predictedLocation = new Point2D.Double(predictedX, predictedY);
            this.setAhead(this.moveAmount);
            if (Math.random() > reversePercentage) {
                moveDirection *= -1.0;
            }
        }
        this.previousEnergy = e.getEnergy();
    }

    public void onHitByBullet(HitByBulletEvent e) {
        if (Math.random() > reversePercentage) {
            moveDirection *= -1.0;
        }
        turnDirection *= -1.0;
        this.turn += 1.0;
    }

    public double myX(double X) {
        X = this.getX();
        return X;
    }

    public double myY(double Y) {
        Y = this.getY();
        return Y;
    }

    public void corner(ScannedRobotEvent e) {
    }

    public void onDeath(DeathEvent e) {
        newRandomGun = true;
        this.changingFactors();
        deathCount += 1.0;
        stableRoundsDeath += 1.0;
        if (stableRoundsDeath < 2.0) {
            this.out.println("ERROR : calculations unstable ");
            this.out.println("3 battles until calculations are stable");
        } else {
            this.out.println("------battle Predictions-------");
            this.battleOutCome();
        }
    }

    public void onWin(WinEvent e) {
        newRandomGun = true;
        this.turnRight(30.0);
        this.turnLeft(30.0);
        double myHitPercentage = this.myHitCount / this.myMissCount * 100.0;
        if (myHitPercentage > 100.0) {
            myHitPercentage = 100.0;
        }
        this.out.println("-------status-------");
        this.out.println("hit by bullet " + totalHit + "   my hit count " + this.myHitCount + "   my hit percentage  " + ((double)Math.round(myHitPercentage) - this.turn) + "%");
        if (this.getEnergy() <= 20.0) {
            this.changingFactors();
        }
        winCount += 1.0;
        if ((stableRoundsWin += 1.0) < 2.0) {
            this.out.println("ERROR : calculations unstable ");
            this.out.println("3 battles until calculations are stable");
        } else {
            this.out.println("------battle Predictions-------");
            this.battleOutCome();
        }
    }

    public void incrementMoving() {
        double hitFormula = this.turn;
        this.out.println("getting hit percentage  " + Math.round(hitFormula));
        if (hitFormula >= 7.0) {
            this.moveAmount -= 20.0 * moveDirection;
            if (this.moveAmount <= 10.0) {
                this.moveAmount = 20.0 * moveDirection;
                this.moveAmount += 20.0;
            }
            if (this.moveAmount >= 200.0) {
                this.moveAmount = 190.0 * moveDirection;
                this.moveAmount -= 20.0;
            }
        } else {
            this.moveAmount -= 5.0 * moveDirection;
            if (this.moveAmount <= 10.0) {
                this.moveAmount = 20.0 * moveDirection;
                this.moveAmount += 5.0;
            }
            if (this.moveAmount >= 200.0) {
                this.moveAmount = 190.0 * moveDirection;
                this.moveAmount -= 5.0;
            }
        }
    }

    public void changingFactors() {
        double myHitFormula = this.myHitCount / this.myMissCount * 100.0;
        double outComeFormula = myHitFormula / (double)this.getNumRounds() * 100.0;
        if (Math.round(outComeFormula) > 100L) {
            outComeFormula = 100.0;
        }
        if (outComeFormula >= 50.0) {
            this.out.println("keeping Factors()");
        } else {
            this.out.println("moveAmount = " + this.moveAmount);
            this.out.println("bulletPower = " + this.bulletPower);
            this.moveAmount -= 20.0 * moveDirection;
            if (this.moveAmount <= 10.0) {
                this.moveAmount = 20.0 * moveDirection;
                b = 0.0;
                this.moveAmount += 20.0;
                reversePercentage += 1.0;
            }
            if (this.moveAmount >= 200.0) {
                this.moveAmount = 190.0 * moveDirection;
                this.moveAmount -= 20.0;
                reversePercentage -= 1.0;
                b = 3.0;
            } else {
                this.moveAmount -= 5.0 * moveDirection;
                if (this.moveAmount <= 10.0) {
                    this.moveAmount = 20.0 * moveDirection;
                    this.moveAmount += 5.0;
                    b = -3.0;
                    reversePercentage += 1.0;
                }
                if (this.moveAmount >= 200.0) {
                    this.moveAmount = 190.0 * moveDirection;
                    this.moveAmount -= 5.0;
                    b = -1.0;
                    reversePercentage -= 1.0;
                }
            }
            this.bulletManage();
            this.out.println("Changing Factors() moveAmount" + this.moveAmount + " changed bulletPower" + this.bulletPower);
        }
    }

    public void battleOutCome() {
        double myHitFormula = this.myHitCount / this.myMissCount * 100.0;
        double outComeFormula = myHitFormula / (double)this.getNumRounds() * 100.0;
        if (Math.round(outComeFormula) > 100L) {
            outComeFormula = 100.0;
        }
        if (outComeFormula >= 50.0) {
            this.out.println("outCome for match  " + Math.round(outComeFormula) + " %    winner = me");
        } else {
            this.out.println("outCome for match  " + Math.round(outComeFormula) + " %    winner = enemy");
        }
    }

    public void bulletManage() {
        if (this.getEnergy() < 5.0) {
            b = -1.0;
        }
        if (b == 0.0) {
            this.bulletPower = 1.5;
        }
        if (b == 1.0) {
            this.bulletPower = 2.0;
        }
        if (b == 2.0) {
            this.bulletPower = 2.5;
        }
        if (b == 3.0) {
            this.bulletPower = 3.0;
        }
        if (b == -1.0) {
            this.bulletPower = 1.0;
        }
        if (b == -2.0) {
            this.bulletPower = 1.5;
        }
        if (b == -3.0) {
            this.bulletPower = 2.0;
        }
    }

    public void onBulletHit(BulletHitEvent e) {
        this.myHitCount += 1.0;
        totalHit += 1.0;
        this.bulletManage();
        b += 2.0;
        if (predictGunCounter) {
            predictCount += 1.0;
        }
        if (directGunCounter) {
            directCount += 1.0;
        }
        if (waveGunCounter) {
            waveCount += 1.0;
        }
        if (distanceWaveCounter) {
            distanceCount += 1.0;
        }
        if (randomGunCounter) {
            randomCount += 1.0;
        }
    }

    public void onBulletMissed(BulletMissedEvent e) {
        this.myMissCount += 1.0;
        totalMiss += 1.0;
        this.bulletManage();
        b -= 0.5;
    }

    public void onHitWall(HitWallEvent e) {
        moveDirection *= -1.0;
    }

    public class directGun {
        public directGun(ScannedRobotEvent e) {
            directCount = 0.0;
        }

        public boolean returningDirectCount(double predictCount, double waveCount, double distanceCount) {
            return directCount > predictCount && directCount > waveCount && directCount > distanceCount && directCount > randomCount;
        }
    }

    public class distanceWave {
        double distanceCount = 0.0;

        public distanceWave(ScannedRobotEvent e) {
        }

        public boolean returningDistanceCount(double predictCount, double directCount, double waveCount) {
            return this.distanceCount > predictCount && this.distanceCount > waveCount && this.distanceCount > directCount && this.distanceCount > randomCount;
        }
    }

    public class predictGun {
        double predictCount = 0.0;

        public predictGun(ScannedRobotEvent e) {
        }

        public boolean returningPredictCount(double directCount, double waveCount, double distanceCount) {
            return this.predictCount > directCount && this.predictCount > waveCount && this.predictCount > distanceCount && this.predictCount > randomCount;
        }
    }

    public class randomGun {
        double randomCount = 0.0;

        public randomGun(ScannedRobotEvent e) {
        }

        public boolean returningRandomCount(double predictCount, double directCount, double distanceCount, double waveCount) {
            return this.randomCount > predictCount && this.randomCount > waveCount && this.randomCount > distanceCount && this.randomCount > directCount;
        }
    }

    public class waveGun {
        double waveCount = 0.0;

        public waveGun(ScannedRobotEvent e) {
        }

        public boolean returningWaveCount(double predictCount, double directCount, double distanceCount) {
            return this.waveCount > predictCount && this.waveCount > directCount && this.waveCount > distanceCount && this.waveCount > randomCount;
        }
    }
}

