/*
 * Decompiled with CFR 0.152.
 */
package ch.rhj.rbc;

import java.awt.geom.Point2D;
import java.util.Random;
import robocode.AdvancedRobot;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class RHJ1
extends AdvancedRobot {
    public static final double ANGLE01 = Math.PI / 180;
    public static final double ANGLE45 = 0.7853981633974483;
    public static final double MAX_VELOCITY = 2.5;
    private Random random = new Random(System.currentTimeMillis());
    private Me me = new Me();
    private Enemy enemy = null;
    private int changeMove = 0;
    private double direction = 1.0;

    public void run() {
        this.setMaxVelocity(2.5);
        while (true) {
            this.me.update();
            this.updateMove();
            if (this.enemy != null) {
                this.enemy.guess();
            }
            this.updateRadar();
            this.updateGun();
            this.execute();
        }
    }

    private void updateMove() {
        --this.changeMove;
        if (this.changeMove > 0) {
            return;
        }
        double da = (this.random.nextDouble() - 0.5) * Math.PI;
        this.setTurnRightRadians(da);
        this.setAhead(this.direction * 50.0 * 2.5);
        this.changeMove = 50;
    }

    private void updateRadar() {
        if (this.enemy == null || this.enemy.guessing > 5) {
            this.setTurnRadarRightRadians(0.7853981633974483);
            return;
        }
        double cda = Utils.normalRelativeAngle((double)(this.enemy.angle - this.getRadarHeadingRadians()));
        double bda = Math.atan2(18.0, this.enemy.distance);
        double da = Utils.normalRelativeAngle((double)(cda + bda * (double)(cda < 0.0 ? -1 : 1)));
        this.setTurnRadarRightRadians(da);
    }

    private void updateGun() {
        if (this.enemy == null) {
            return;
        }
        Enemy en = this.enemy;
        double fp = 0.0;
        double dt = 0.0;
        int i = 0;
        while (i < 3) {
            fp = Math.min(3.0, Math.max(0.1, 3.0 / Math.sqrt(Math.max(1.0, en.distance - 100.0))));
            dt = en.distance / (20.0 - 3.0 * fp);
            en = this.enemy.guess(dt);
            ++i;
        }
        double da = Utils.normalRelativeAngle((double)(en.angle - this.getGunHeadingRadians()));
        this.setTurnGunRightRadians(da);
        if (this.getGunHeat() > 0.0) {
            return;
        }
        this.setFire(fp);
    }

    public void onScannedRobot(ScannedRobotEvent event) {
        if (this.enemy == null) {
            this.enemy = new Enemy();
        }
        this.enemy.update(event);
    }

    public void onRobotDeath(RobotDeathEvent event) {
        this.enemy = null;
    }

    public void onHitRobot(HitRobotEvent event) {
        this.direction = -this.direction;
        this.changeMove = 0;
    }

    public void onHitWall(HitWallEvent event) {
        this.direction = -this.direction;
        this.changeMove = 0;
    }

    private class Me {
        public Point2D.Double pos = new Point2D.Double();
        public double heading;

        Me() {
        }

        public void update() {
            this.pos.setLocation(RHJ1.this.getX(), RHJ1.this.getY());
            this.heading = RHJ1.this.getHeadingRadians();
        }
    }

    private class Enemy {
        public int guessing;
        public Point2D.Double pos = new Point2D.Double();
        public Point2D.Double speed = new Point2D.Double();
        public double distance;
        public double angle;

        public Enemy() {
        }

        public Enemy(Enemy enemy) {
            this.guessing = enemy.guessing;
            this.pos.setLocation(enemy.pos.x, enemy.pos.y);
            this.speed.setLocation(enemy.speed.x, enemy.speed.y);
            this.distance = enemy.distance;
            this.angle = enemy.angle;
        }

        public void update(ScannedRobotEvent event) {
            double a = ((RHJ1)RHJ1.this).me.heading + event.getBearingRadians();
            double d = event.getDistance();
            double v = event.getVelocity();
            double h = event.getHeadingRadians();
            this.guessing = -1;
            this.pos.setLocation(((RHJ1)RHJ1.this).me.pos.x + d * Math.sin(a), ((RHJ1)RHJ1.this).me.pos.y + d * Math.cos(a));
            this.speed.setLocation(v * Math.sin(h), v * Math.cos(h));
            this.updateDerived();
        }

        public void guess() {
            ++this.guessing;
            if (this.guessing == 0) {
                return;
            }
            this.pos.setLocation(this.pos.x + this.speed.x, this.pos.y + this.speed.y);
            this.updateDerived();
        }

        public Enemy guess(double dt) {
            Enemy enemy = new Enemy(this);
            enemy.guessing += (int)Math.round(dt);
            enemy.pos.setLocation(this.pos.x + dt * this.speed.x, this.pos.y + dt * this.speed.y);
            enemy.updateDerived();
            return enemy;
        }

        private void updateDerived() {
            double dx = this.pos.x - ((RHJ1)RHJ1.this).me.pos.x;
            double dy = this.pos.y - ((RHJ1)RHJ1.this).me.pos.y;
            this.distance = Math.max(1.0, Math.sqrt(dx * dx + dy * dy));
            this.angle = Utils.normalAbsoluteAngle((double)Math.atan2(dx, dy));
        }
    }
}

