/*
 * Decompiled with CFR 0.152.
 */
package et;

import et.CircularDbuf;
import et.EtMath;
import et.EtRobot;
import et.IncomingBullets;
import et.IncomingFire;
import et.Location;
import et.Predator;
import et.Tensor;
import et.TensorCBuf;
import robocode.ScannedRobotEvent;

public final class Enemy
extends TensorCBuf {
    private static Predator thePredator;
    public boolean ramIt = false;
    private String name;
    private double bearing = 0.0;
    private double life = 100.0;
    private double distance = 0.0;
    private long time = -100L;
    private Location estimatedPos;
    private double shots = 0.0;
    private double hits = 0.0;
    private double hitMe = 0.0;
    private double maxHitsOnMe = 10000.0;
    private double sit = 0.0;
    private double totalTimesHit = 0.0;
    private long lastReverse = 0L;
    private long timeBetweenReverse = 0L;
    private double reverseFactor = 0.05;
    private CircularDbuf energy = new CircularDbuf(2);
    private IncomingBullets incomingBullets;
    public double totSucTf = 0.0;
    public double nextTf = 10.0;
    public double avgSucTf = 10.0;

    public Enemy(String string, Predator predator) {
        this.energy.put(100.0, 0L);
        this.energy.put(100.0, 0L);
        thePredator = predator;
        this.name = string;
        this.estimatedPos = new Location(this.getX(), this.getY());
        this.incomingBullets = new IncomingBullets();
    }

    public Enemy(ScannedRobotEvent scannedRobotEvent, Predator predator) {
        this(scannedRobotEvent.getName(), predator);
        this.setInfo(scannedRobotEvent);
    }

    private void setInfo(double d, double d2, double d3, double d4, double d5, long l) {
        this.bearing = d2;
        this.life = d5;
        this.distance = d4;
        this.energy.put(d5, l);
        if (thePredator.getOthers() == 1 && this.energy.delta() <= -0.1 && this.energy.delta() >= -3.0) {
            double d6 = 0.0;
            d6 = -this.energy.delta();
            this.incomingBullets.add(new IncomingFire(this, l, d6, thePredator));
        }
        this.put(new Tensor(this.calculatePosition(), d, d3), l);
        this.time = l;
    }

    private Location calculatePosition() {
        double d = Math.toRadians(EtMath.normalRelativeAngle(thePredator.getHeading(false) + this.bearing));
        double d2 = Math.sin(d) * this.distance;
        double d3 = Math.cos(d) * this.distance;
        double d4 = thePredator.getX() + d2;
        double d5 = thePredator.getY() + d3;
        return new Location(d4, d5);
    }

    public final void setInfo(ScannedRobotEvent scannedRobotEvent) {
        this.setInfo(scannedRobotEvent.getHeading(), scannedRobotEvent.getBearing(), scannedRobotEvent.getVelocity(), scannedRobotEvent.getDistance(), scannedRobotEvent.getEnergy(), scannedRobotEvent.getTime());
    }

    public IncomingBullets getIncomingBullets() {
        return this.incomingBullets;
    }

    public final void reset(double d) {
        this.maxHitsOnMe = d;
        this.time = -100L;
        this.lastReverse = 0L;
        this.incomingBullets.clear();
        this.timeBetweenReverse = 0L;
        if (this.totalTimesHit > 0.0) {
            this.avgSucTf = this.totSucTf / this.hits;
        }
        this.ramIt = false;
        this.energy.put(100.0, 0L);
        this.energy.put(100.0, 0L);
    }

    public String getStats() {
        if (this.shots < 1.0) {
            return "NOT ENOUGH DATA.";
        }
        return EtMath.percent(this.getHitRate()) + "   " + EtMath.percent(this.getThreat()) + "   " + this.avgSucTf;
    }

    private final long getTimeToReverse() {
        return Math.max(this.timeBetweenReverse + this.lastReverse - this.time, 0L);
    }

    public final void setFiredAt(double d) {
        this.shots += d;
        this.nextTf = EtMath.rand(this.avgSucTf / 10.0, this.avgSucTf * 1.9);
    }

    public final void setHit(double d, double d2) {
        this.hits += d;
        this.totalTimesHit += 1.0;
        this.totSucTf += d2 * d;
    }

    public final void setHitMe(double d) {
        this.hitMe += d;
    }

    public final double getHitRate() {
        if (this.shots < 1.0) {
            return 0.3;
        }
        return this.hits / this.shots;
    }

    public final double getHitsOnMe() {
        return this.hitMe;
    }

    public final double getThreat() {
        if (thePredator.getRoundNum() < 5) {
            return 1.0;
        }
        return this.getHitsOnMe() / this.maxHitsOnMe;
    }

    public final double getBearing() {
        return this.bearing;
    }

    public final double getBearingToGun() {
        return EtMath.normalRelativeAngle(thePredator.getHeading(false) + this.bearing - thePredator.getGunHeading());
    }

    public final double getEnergy() {
        return this.life;
    }

    public final String getName() {
        return this.name;
    }

    public final double getDistance() {
        return this.distance(thePredator.getPosition());
    }

    public final double getUpdateTime() {
        return this.time;
    }

    public final double getTimeSinceUpdate() {
        return thePredator.getTime() - this.time;
    }

    public final boolean isUpdated(double d) {
        return this.getTimeSinceUpdate() < d;
    }

    public final boolean isUpdated() {
        return this.isUpdated(13.0);
    }

    public Location getEstimatedPosition(double d) {
        if (this.getEnergy() < 0.1) {
            return this;
        }
        double d2 = d + this.getTimeSinceUpdate();
        double d3 = Math.sqrt(d2) / this.nextTf;
        double d4 = this.deltaH(d3 * d2);
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = this.getVelocity();
        double d8 = this.getAvgVelocity(d3 * d2);
        double d9 = 8.0 * d2 - Math.pow(d7, 2.0) / 2.0 + 8.0 * Math.abs(d7) - 32.0;
        if (Math.abs(d8) > d9) {
            d8 = d9 * (double)EtMath.sign(d8);
        }
        if (d8 < 4.0) {
            d7 = d8;
        }
        double d10 = Math.abs(d7);
        if (Math.abs(d4) >= 4.0) {
            double d11 = 180.0 * d10 / (Math.PI * Math.abs(d4));
            double d12 = EtMath.counterClockwiseAngle(this.getHeading(true));
            double d13 = this.getX() - (double)EtMath.sign(d4) * Math.cos(Math.toRadians(d12 + 90.0)) * d11;
            double d14 = this.getY() - (double)EtMath.sign(d4) * Math.sin(Math.toRadians(d12 + 90.0)) * d11;
            d5 = d13 + (double)EtMath.sign(d4) * Math.cos(Math.toRadians(d12 - d4 * d2 + 90.0)) * d11;
            d6 = d14 + (double)EtMath.sign(d4) * Math.sin(Math.toRadians(d12 - d4 * d2 + 90.0)) * d11;
            this.estimatedPos.setLocation(d5, d6);
            boolean bl = false;
            while (EtRobot.battleField.relativeToLocation(this.estimatedPos, 20.0) != 0 && d2 > -d) {
                bl = true;
                d5 = d13 + (double)EtMath.sign(d4) * Math.cos(Math.toRadians(d12 - d4 * (d2 -= 1.0) + 90.0)) * d11;
                d6 = d14 + (double)EtMath.sign(d4) * Math.sin(Math.toRadians(d12 - d4 * d2 + 90.0)) * d11;
                this.estimatedPos.setLocation(d5, d6);
            }
        } else {
            d10 = Math.abs(d7);
            double d15 = 0.0;
            double d16 = 0.0;
            double d17 = this.getAvgHeading(d2 * d3);
            double d18 = 1.0;
            double d19 = 1.0;
            if (this.getVelocity() < 0.0) {
                d18 = -1.0;
                d19 = -1.0;
            }
            double d20 = 0.0;
            if (d17 >= 0.0 && d17 <= 90.0) {
                d20 = 90.0 - d17;
            } else if (d17 > 90.0 && d17 <= 180.0) {
                d20 = d17 - 90.0;
                d19 *= -1.0;
            } else if (d17 > 180.0 && d17 <= 270.0) {
                d20 = 270.0 - d17;
                d18 *= -1.0;
                d19 *= -1.0;
            } else if (d17 > 270.0 && d17 <= 360.0) {
                d20 = d17 - 270.0;
                d18 *= -1.0;
            }
            double d21 = Math.toRadians(d20);
            d15 = d18 * d10 * Math.cos(d21);
            d16 = d19 * d10 * Math.sin(d21);
            d5 = this.getX() + d15 * d2;
            d6 = this.getY() + d16 * d2;
            this.estimatedPos.setLocation(d5, d6);
            if (EtRobot.battleField.relativeToLocation(this.estimatedPos, 17.0) != 0) {
                double d22 = 0.0;
                double d23 = 0.0;
                if (d5 > EtRobot.battleField.getWidth() - 17.0 && d15 != 0.0) {
                    d22 = (d5 - EtRobot.battleField.getWidth() + 17.0) / Math.abs(d15);
                } else if (d5 < 17.0 && d15 != 0.0) {
                    d22 = (17.0 - d5) / Math.abs(d15);
                }
                if (d6 > EtRobot.battleField.getHeight() - 17.0 && d16 != 0.0) {
                    d23 = (d6 - EtRobot.battleField.getHeight() + 17.0) / Math.abs(d16);
                } else if (d6 < 17.0 && d16 != 0.0) {
                    d23 = (17.0 - d6) / Math.abs(d16);
                }
                double d24 = Math.max(d22, d23);
                d5 -= d15 * d24;
                d6 -= d16 * d24;
            }
        }
        this.estimatedPos.setLocation(d5, d6);
        if (EtRobot.battleField.relativeToLocation(this.estimatedPos, 17.0) != 0) {
            return this;
        }
        return this.estimatedPos;
    }

    public double getEstimatedDistance(double d) {
        return this.getEstimatedPosition(d).distance(thePredator.getPosition());
    }

    public final boolean isOnMyWall() {
        return this.isOnMyWall(EtRobot.battleField, thePredator);
    }

    public final boolean isRammable() {
        if (thePredator.getOthers() > 1) {
            return thePredator.getEnergy() > 50.0 && this.getEnergy() < 1.0;
        }
        return thePredator.getEnergy() / (this.getEnergy() + 0.1) > 8.0;
    }
}

