/*
 * Decompiled with CFR 0.152.
 */
package ags.muse.recon;

import ags.muse.base.Rules;
import ags.muse.recon.ExtendedEnemyInfo;
import ags.muse.recon.SelfStatus;
import ags.util.points.AbsolutePoint;
import ags.util.points.RelativePoint;
import java.util.List;
import robocode.Event;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class Enemy {
    public final String name;
    private AbsolutePoint location;
    private RelativePoint velocity;
    private double energy;
    private int scanAge;
    public final ExtendedEnemyInfo ext;

    public Enemy(Rules rules, String name) {
        this.ext = new ExtendedEnemyInfo(rules);
        this.name = name;
    }

    public void handleEvents(List<Event> events, SelfStatus status) {
        ++this.scanAge;
        AbsolutePoint oldLocation = this.location;
        RelativePoint oldVelocity = this.velocity;
        double oldEnergy = this.energy;
        for (Event e : events) {
            ScannedRobotEvent s;
            if (!(e instanceof ScannedRobotEvent) || !(s = (ScannedRobotEvent)e).getName().equals(this.name)) continue;
            this.scanAge = 0;
            this.velocity = RelativePoint.fromDM(Utils.normalAbsoluteAngle((double)s.getHeadingRadians()), s.getVelocity());
            RelativePoint rel = RelativePoint.fromDM(status.status.getHeadingRadians() + s.getBearingRadians(), s.getDistance());
            this.location = status.getLocation().addRelativePoint(rel);
            this.energy = s.getEnergy();
            this.ext.update(status, this, events, oldLocation, oldVelocity, oldEnergy);
        }
    }

    public AbsolutePoint getLocation() {
        return this.location;
    }

    public RelativePoint getVelocity() {
        return this.velocity;
    }

    public double getEnergy() {
        return this.energy;
    }

    public int getScanAge() {
        return this.scanAge;
    }
}

