/*
 * Decompiled with CFR 0.152.
 */
package ags.muse.recon;

import ags.muse.physics.PhysicsEngine;
import ags.muse.physics.RobotSim;
import ags.util.points.AbsolutePoint;
import ags.util.points.RelativePoint;
import java.util.List;
import robocode.Event;
import robocode.HitByBulletEvent;
import robocode.RobotStatus;
import robocode.Rules;
import robocode.StatusEvent;

public class SelfStatus {
    private AbsolutePoint location;
    private AbsolutePoint nextLocation;
    private RelativePoint velocity;
    public RobotStatus status;
    public int t = 0;
    private double damageTaken = 0.0;

    public void handleEvents(List<Event> events) {
        for (Event e : events) {
            if (e instanceof StatusEvent) {
                this.update(((StatusEvent)e).getStatus());
            }
            if (!(e instanceof HitByBulletEvent)) continue;
            this.damageTaken += Rules.getBulletDamage((double)((HitByBulletEvent)e).getBullet().getPower());
        }
    }

    private void update(RobotStatus status) {
        this.location = AbsolutePoint.fromXY(status.getX(), status.getY());
        this.velocity = RelativePoint.fromDM(status.getHeadingRadians(), status.getVelocity());
        this.status = status;
        this.nextLocation = this.location;
        ++this.t;
    }

    public AbsolutePoint getLocation() {
        return this.location;
    }

    public AbsolutePoint getNextLocation() {
        return this.nextLocation;
    }

    public RelativePoint getVelocity() {
        return this.velocity;
    }

    public double getDamageTaken() {
        return this.damageTaken;
    }

    public void setIntention(ags.muse.base.Rules rules, double ahead, double turn) {
        RobotSim sim = new RobotSim();
        sim.location = this.location;
        sim.velocity = this.velocity;
        PhysicsEngine.simulateTick(rules, sim, ahead, turn, true);
        this.nextLocation = sim.location;
    }
}

