/*
 * Decompiled with CFR 0.152.
 */
package ags.util;

import ags.util.points.AbsolutePoint;
import ags.util.points.RelativePoint;
import robocode.util.Utils;

public class GFPerspective {
    public final double hotAngle;
    public final double lateralDir;
    public final double maxEscapeAngle;

    public GFPerspective(AbsolutePoint origin, AbsolutePoint targetLoc, RelativePoint targetVel, double lateralDir, double bulletSpeed) {
        this.hotAngle = RelativePoint.fromPP((AbsolutePoint)origin, (AbsolutePoint)targetLoc).direction;
        this.lateralDir = lateralDir;
        this.maxEscapeAngle = Math.asin(8.0 / bulletSpeed);
    }

    public double getGuessFactor(double angle) {
        return this.lateralDir * Utils.normalRelativeAngle((double)(angle - this.hotAngle)) / this.maxEscapeAngle;
    }

    public double getAngle(double guessfactor) {
        return Utils.normalAbsoluteAngle((double)(guessfactor * this.maxEscapeAngle / this.lateralDir + this.hotAngle));
    }
}

