/*
 * Decompiled with CFR 0.152.
 */
package vuen.fractal.data;

import vuen.fractal.FractalE;
import vuen.fractal.data.GenGL;
import vuen.fractal.data.Memory;
import vuen.fractal.data.Packet;

public class Gen {
    FractalE robot;
    Memory memory;
    GenGL gengl;
    public double[] power;
    public int[] powert;
    public double[] rpower;

    public Gen(FractalE robot, Memory memory) {
        this.robot = robot;
        this.memory = memory;
        this.power = new double[memory.totalbots + 1];
        this.powert = new int[memory.totalbots + 1];
        this.rpower = new double[memory.totalbots + 1];
        if (FractalE.glhud) {
            this.gengl = new GenGL(FractalE.renderer, memory, this);
        }
    }

    public void init() {
        if (FractalE.glhud) {
            this.gengl.init();
        }
    }

    public void go() {
        for (int i = 0; i <= this.memory.totalbots; ++i) {
            this.checkBulletFired(i);
        }
        if (FractalE.glhud) {
            this.gengl.draw();
        }
    }

    public double getAvgPower(int id) {
        return this.power[id] / (double)this.powert[id];
    }

    public double getPower(int id) {
        if (this.rpower[id] == 0.0) {
            return 2.5;
        }
        return this.rpower[id];
    }

    public void checkBulletFired(int i) {
        Packet now = this.memory.getPacket(i);
        Packet then = this.memory.getPacketOffset(i, -1);
        if (now == null || then == null) {
            return;
        }
        double ed = then.energy - now.energy;
        if (ed > 3.001 || ed < 0.009) {
            return;
        }
        Packet andthen = this.memory.getPacketOffset(i, -2);
        if (andthen != null && andthen.energy - then.energy > 0.0) {
            return;
        }
        this.bullet(i, ed);
    }

    public void bullet(int id, double p) {
        int n = id;
        this.power[n] = this.power[n] + p;
        int n2 = id;
        this.powert[n2] = this.powert[n2] + 1;
        if (this.rpower[id] > 0.0) {
            int n3 = id;
            this.rpower[n3] = this.rpower[n3] * 0.8;
            int n4 = id;
            this.rpower[n4] = this.rpower[n4] + p * 0.2;
        } else {
            this.rpower[id] = p;
        }
        if (FractalE.glhud) {
            this.gengl.updatePower(id);
        }
    }
}

