/*
 * Decompiled with CFR 0.152.
 */
package areb;

import areb.Util;
import robocode.Bullet;

public class BulletNode {
    private Bullet bullet;
    private int eDist;
    private int eVel;
    private int eAccel;
    private int bPower;
    private int fwDist;
    private int bwDist;
    private double fireX;
    private double fireY;
    private double enemyX;
    private double enemyY;
    private double eHeading;
    private double eBearing;
    private double projection;
    private boolean waveAlreadyIntersected;
    private double actualShotFraction;

    public BulletNode(Bullet bullet, int n, int n2, int n3, int n4, int n5, int n6, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        this.bullet = bullet;
        this.eDist = n;
        this.eVel = n2;
        this.eAccel = n3;
        this.bPower = n4;
        this.fwDist = n5;
        this.bwDist = n6;
        this.fireX = d;
        this.fireY = d2;
        this.enemyX = d3;
        this.enemyY = d4;
        this.eHeading = d5;
        this.eBearing = d6;
        this.projection = d7;
        this.waveAlreadyIntersected = false;
        this.actualShotFraction = d8;
    }

    public Bullet getBullet() {
        return this.bullet;
    }

    public int getEDist() {
        return this.eDist;
    }

    public int getEVel() {
        return this.eVel;
    }

    public int getEAccel() {
        return this.eAccel;
    }

    public int getBPower() {
        return this.bPower;
    }

    public int getFwDist() {
        return this.fwDist;
    }

    public int getBwDist() {
        return this.bwDist;
    }

    public double getFireX() {
        return this.fireX;
    }

    public double getFireY() {
        return this.fireY;
    }

    public double getEnemyX() {
        return this.enemyX;
    }

    public double getEnemyY() {
        return this.enemyY;
    }

    public boolean hasWaveAlreadyIntersected() {
        return this.waveAlreadyIntersected;
    }

    public double getActualShotFraction() {
        return this.actualShotFraction;
    }

    public void setWaveIntersected(boolean bl) {
        this.waveAlreadyIntersected = bl;
    }

    public boolean hasWaveIntersected(double d, double d2) {
        try {
            this.waveAlreadyIntersected = Util.distance(this.fireX, this.fireY, this.bullet.getX(), this.bullet.getY()) >= Util.distance(this.fireX, this.fireY, d, d2) - 18.0;
        }
        catch (NullPointerException nullPointerException) {
            this.waveAlreadyIntersected = true;
        }
        return this.waveAlreadyIntersected;
    }

    public double calculateWaveIntersect(double d, double d2) {
        double d3 = Util.getBearing(this.fireX, this.fireY, d, d2);
        d3 = Util.getRelativeAngle(this.eBearing, d3);
        double d4 = d3 / this.projection;
        return d4;
    }
}

