//--------------------------------------------------------------------------
// $Id: AbstractBot.java,v 1.1 2003/08/29 09:16:22 erning Exp $
//--------------------------------------------------------------------------
// Copyright (c) 2000-2003 Dragon Software Corp. All rights reserved.
//
// Please refer to COPYRIGHT for notices regarding the confidential
// and proprietary nature of this source code.
//--------------------------------------------------------------------------

package net.dragonsoft.robocoding;

import robocode.AdvancedRobot;
import robocode.Bullet;
import net.dragonsoft.robocoding.util.Position;
import net.dragonsoft.robocoding.util.Rectangle;

public abstract class AbstractBot extends AdvancedRobot
{
    public AbstractBot()
    {
    }

    // wheel

    public void move(double x, double y)
    {
        double distance = Position.calcDistance(getX(), getY(), x, y);
        double angle = Position.calcAngle(getX(), getY(), x, y);
        double turnAngle = angle - getHeadingRadians();

        double direction = 1;
        if (Math.abs(turnAngle) > Math.PI / 2 )
        {
            turnAngle  = robocode.util.Utils.normalRelativeAngle(turnAngle  + Math.PI);
            direction = -1;
        }

        setTurnRightRadians(turnAngle);
        setAhead(direction * distance);
    }

    public void move(Position p)
    {
        move(p.x, p.y);
    }

    public void turnAt(double x, double y)
    {
        double angle = Position.calcAngle(getX(), getY(), x, y);
        turnAt(angle);
    }

    public void turnAt(Position p)
    {
        turnAt(p.x, p.y);
    }

    public void turnAt(double angle)
    {
        double turnAngle = angle - getHeadingRadians();
        turnAngle = robocode.util.Utils.normalRelativeAngle(turnAngle);
        setTurnRightRadians(turnAngle);
    }

    /*
    public void turnAt90(double x, double y)
    {
        double angle = Position.calcAngle(getX(), getY(), x, y);
        turnAt90(angle);
    }

    public void turnAt90(Position p)
    {
        turnAt90(p.x, p.y);
    }

    public void turnAt90(double angle)
    {
        double turnAngle = angle - getHeadingRadians() + Math.PI / 2;
        turnAngle = robocode.util.Utils.normalRelativeAngle(turnAngle);
        setTurnRightRadians(turnAngle);
    }

    public void brake()
    {
        setAhead(0.0d);
    }
    */

    // radar

    public void focus(double angle)
    {
        double turnAngle = Math.sin(angle - getRadarHeadingRadians());

        while (turnAngle == 0d)
        {   // keep the radar active
            turnAngle += Math.toRadians(Math.random() - 0.5d);
        }
        setTurnRadarRightRadians(turnAngle);
    }

    public void focus(double x, double y)
    {
        double angle = Position.calcAngle(getX(), getY(), x, y);
        focus(angle);
    }

    public void focus(Position p)
    {
        double angle = Position.calcAngle(getX(), getY(), p.x, p.y);
        focus(angle);
    }

    // gun

    public void aimAt(double x, double y)
    {
        double angle = Position.calcAngle(getX(), getY(), x, y);
        aimAt(angle);
    }

    public void aimAt(Position p)
    {
        aimAt(p.x, p.y);
    }

    public void aimAt(double angle)
    {
        double turnAngle = angle - getGunHeadingRadians();
        turnAngle = robocode.util.Utils.normalRelativeAngle(turnAngle);
        setTurnGunRightRadians(turnAngle);
    }

    public Bullet shoot(double power)
    {
        return setFireBullet(power);
    }

    //

    public boolean isOutOfField(double x, double y)
    {
        if (_movingFieldRect == null)
            _movingFieldRect = new Rectangle(20, 20, getBattleFieldWidth() - 21, getBattleFieldHeight() - 21);
        return !_movingFieldRect.contains(x, y);
    }

    public boolean isOutOfField(Position p)
    {
        return isOutOfField(p.x, p.y);
    }

    public boolean isOutOfField(double x, double y, double angle, double distance)
    {
        return isOutOfField(Position.calcPosition(x, y, angle, distance));
    }

    public double distanceToWall(double x, double y)
    {
        if (_fullFieldRect == null)
            _fullFieldRect = new Rectangle(0, 0, getBattleFieldWidth() - 1, getBattleFieldHeight() - 1);

        return Math.min(Math.min(x, y), Math.min(_fullFieldRect.getWidth() - x, _fullFieldRect.getHeight() - y));
    }

    public double distanceToWall(Position p)
    {
        return distanceToWall(p.x, p.y);
    }

    public double distanceToCenter(double x, double y)
    {
        if (_fullFieldRect == null)
            _fullFieldRect = new Rectangle(0, 0, getBattleFieldWidth() - 1, getBattleFieldHeight() - 1);

        return Position.calcDistance(x, y, _fullFieldRect.getWidth() / 2, _fullFieldRect.getHeight() / 2);
    }

    public double distanceToCenter(Position p)
    {
        return distanceToCenter(p.x, p.y);
    }

    protected Rectangle _movingFieldRect = null;
    protected Rectangle _fullFieldRect = null;
}
