package sgp;
import robocode.*;
import java.util.*;
import java.awt.Color;

/**
 * Strategy - a class by Simon Parker
 */
public class Strategy
{
	private AdvancedRobot robot;
	protected StrategyManager strategyManager;
	protected DrunkenStrategyManager dStrategyManager;

	protected final int NUM_POSITIONS = 4;
	protected double velocity[] = new double[NUM_POSITIONS];
	protected double turnRight[] = new double[NUM_POSITIONS];
	protected double goodness[] = new double[NUM_POSITIONS];
	private final double MAX_VELOCITY = 8;
	private final double MAX_ANGULAR_VELOCITY_DEG_PER_FRAME = 10;


	public Strategy (AdvancedRobot theRobot, StrategyManager theStrategyManager)
	{
		robot = theRobot;
		strategyManager = theStrategyManager;
		velocity[0] = 1.0;		turnRight[0] = 1.0;
		velocity[1] = -2.0;		turnRight[1] = 1.0;
		velocity[2] = 1.0;		turnRight[2] = -1.0;
		velocity[3] = -2.0;		turnRight[3] = -1.0;
	}

	public Strategy (AdvancedRobot theRobot, DrunkenStrategyManager theStrategyManager)
	{
		robot = theRobot;
		dStrategyManager = theStrategyManager;
		velocity[0] = 1.0;		turnRight[0] = 1.0;
		velocity[1] = -2.0;		turnRight[1] = 1.0;
		velocity[2] = 1.0;		turnRight[2] = -1.0;
		velocity[3] = -2.0;		turnRight[3] = -1.0;
	}

	public void startTurn()
	{

	}

	public void setScan(){} //control the radar motion
	public void setGunRotation(){} //control the gun motion and fires if neccessary
	public void endTurn(){}
	public void onScannedRobot(ScannedRobotEvent e){}
	public void onHitByBullet(HitByBulletEvent e){}
	public void onDeath(DeathEvent event){}
	public void onHitWall(HitWallEvent e){}
	public void onHitRobot(HitRobotEvent e) {}

	// Helper function
	static public double normalRelativeAngle(double angle)
	{
		if (angle > -180 && angle <= 180)
			return angle;
		double fixedAngle = angle;
		while (fixedAngle <= -180)
			fixedAngle += 360;
		while (fixedAngle > 180)
			fixedAngle -= 360;
		return fixedAngle;
	}

	public void onRobotDeath(RobotDeathEvent e)
	{
		//Victory dance
		if (robot.getOthers() == 0)
		{
			robot.setAhead(0);
			robot.turnRight(36000);
		}
	}

	public void reset()
	{
	}


	public void onBulletHit(BulletHitEvent event)
	{
	}

	public void onBulletMissed(BulletMissedEvent event)
	{
	}

	public void onWin(WinEvent event)
	{
	}

	public void setMovement() //sets the turning angle and the ahead/back movement
	{
		//compare the 4 positions for ahead/back left/right

		int maxIndex = 0;

		for (int i = 0; i < NUM_POSITIONS; i++)
		{
			double nextDeltaHeading = (MAX_ANGULAR_VELOCITY_DEG_PER_FRAME - 0.75 * robot.getVelocity()) * turnRight[i];
			double nextVelocity = robot.getVelocity() + velocity[i];

			Coordinate currentPosition = new Coordinate(robot.getX(), robot.getY());
			Coordinate nextPosition = currentPosition.getNextPosition
			(
				robot.getHeading(),
				nextVelocity,
				nextDeltaHeading
			);
			goodness[i] = evaluateGoodness(nextPosition, robot.getHeading() + nextDeltaHeading, MAX_VELOCITY);
			if (goodness[i] > goodness[maxIndex]) maxIndex = i;
		}

		if (velocity[maxIndex] > 0)
		{
			robot.setAhead(100);
		}
		else
		{
			robot.setBack(100);
		}

		robot.setTurnRight(turnRight[maxIndex] * 360);
	}

	public double evaluateGoodness(Coordinate robotPosition, double robotHeading, double robotVelocity)
	{
		return Math.random();
	}

	public void onMessageReceived(MessageEvent e)
	{
	}

	public double evaluateWallGoodness(Coordinate robotPosition)
	{
		double WALL_DISTANCE_WEIGHT = robot.getOthers() * robot.getOthers() * 20.0;
		double WALL_DEFLECTION_DISTANCE = 45.0;

		double wallGoodnessX = 0;
		double wallGoodnessY = 0;
		if (robotPosition.x < WALL_DEFLECTION_DISTANCE)
		{
			wallGoodnessX = -WALL_DISTANCE_WEIGHT * (WALL_DEFLECTION_DISTANCE - robotPosition.x);
		}

		if (robotPosition.y < WALL_DEFLECTION_DISTANCE)
		{
			wallGoodnessY = -WALL_DISTANCE_WEIGHT * (WALL_DEFLECTION_DISTANCE - robotPosition.y);
		}

		if (robotPosition.x > (robot.getBattleFieldWidth()-WALL_DEFLECTION_DISTANCE))
		{
			wallGoodnessX = WALL_DISTANCE_WEIGHT * (robot.getBattleFieldWidth()-WALL_DEFLECTION_DISTANCE - robotPosition.x);
		}

		if (robotPosition.y > (robot.getBattleFieldHeight()-WALL_DEFLECTION_DISTANCE))
		{
			wallGoodnessY = WALL_DISTANCE_WEIGHT * (robot.getBattleFieldHeight()-WALL_DEFLECTION_DISTANCE - robotPosition.y);
		}

		return wallGoodnessX + wallGoodnessY;
	}

	static public Coordinate limitToBattleField(Coordinate position)
	{
		final double ROBOT_RADIUS = 20;
		Coordinate result = new Coordinate(position);

		result.x = Math.max(result.x, ROBOT_RADIUS);
		result.y = Math.max(result.y, ROBOT_RADIUS);
		result.x = Math.min(result.x, Environment.getRobot().getBattleFieldWidth() - ROBOT_RADIUS);
		result.y = Math.min(result.y, Environment.getRobot().getBattleFieldHeight() - ROBOT_RADIUS);

		return result;
	}

}
