package com.timothyveletta.states;

import com.timothyveletta.*;

public class AvoidWall extends State {
	private double averageSize;

	public AvoidWall(FuzzyBot obj) {
		super(obj);
	}
	
	@Override
	public void Init() {
		averageSize = (object.battleFieldWidth + object.battleFieldHeight) / 2;
	}

	@Override
	public void Update() {
		super.Update();
		
		ForceVector vec;
		
		switch(AIControl.closestWall) {
			case TOP:
				vec = new ForceVector(0.0, -activationLevel);
				break;
			case BOTTOM:
				vec = new ForceVector(0.0, activationLevel);
				break;
			case LEFT:
				vec = new ForceVector(activationLevel, 0);
				break;
			case RIGHT:
				vec = new ForceVector(-activationLevel, 0);
				break;
			default:
				vec = new ForceVector(0,0);
				break;
		}
		
		object.applyForce(vec);
	}

	@Override
	public void CalculateActivation() {
		activationLevel = 1 - (AIControl.nearestWallDist / averageSize);
	}
}
