package ahr.ice.Pilot;
import robocode.*;
import robocode.util.Utils;
import java.awt.Color;
import java.awt.geom.*;
import java.util.*;
import java.math.*;
import ahr.ice.Math.*;
import ahr.ice.*;
/**
 * MyClass - a class by (your name here)
 */
public class MinimumRiskMover extends Movement
{
	public Rectangle2D.Double safeBattlefield;
	long bulletDodgeTime = 0;
	PointEvaluator PE;
	public void move(){

		if(this.battlefield==null){
			this.battlefield = r.getBattleField();
			safeBattlefield = new Rectangle2D.Double(battlefield.getX()+20,battlefield.getY()+20,battlefield.getWidth()-40,battlefield.getHeight()-40);
		}
		long time = r.getTime();	
		PointGenerator pg = new PointGenerator(r,battlefield);
		if(time-r.mrTimeToNextSpot>=0 || r.getVelocity()==0){
			r.PE.averagePosition(new Point2D.Double(r.getX(),r.getY()),r.averagePosition);
			Point2D.Double best= pg.generatePoint(safeBattlefield);
			double 	thisRating 			= 	0,
					lastRating 			= 	0;
			int 	counter 			= 	0;
			while(counter<=50){
				Point2D.Double 	ran = pg.generatePoint(safeBattlefield);
				double pX 	=	r.getX() + Math.sin(r.getHeadingRadians()) * r.position().distance(ran),
					   pY 	= 	r.getY() + Math.cos(r.getHeadingRadians()) * r.position().distance(ran);
				thisRating = PE.pointEval(r.me,r.virtualBullets,r.getName(),ran,r.targets,r.averagePosition);
				if(thisRating>=lastRating){
					best= ran;	
					lastRating=thisRating;
				} 
				counter++;
			}
			r.goTo(best.x,best.y);
			r.mrTimeToNextSpot = time + (long)r.position().distance(best)/(long)8;
			r.execute();
		}
	}
	public void wallClose(){
			r.setTurnRightRadians(math.calculateBearingToXYRadians(r.getX(), r.getY(),
									r.getHeadingRadians(), r.middle.x, r.middle.y));
			r.setAhead(200);
			r.setMaxVelocity(40/r.getTurnRemaining());
			r.execute();
	}
	public void robotClose(){
			if(r.getTime()-r.timeSinceLastHRE>100){
				r.mrTimeToNextSpot=r.getTime();
			}
	}
	public void bulletClose(){
		if(r.getTime()-bulletDodgeTime>=30){
			r.mrTimeToNextSpot = r.getTime();
			move();
			bulletDodgeTime=r.getTime();
		}
	}
	public MinimumRiskMover(final AHRBot r){
		this.r = r;
		this.PE = new PointEvaluator(r);
	}
}
