package cyragia;
import robocode.*;
import robocode.util.*;
import java.awt.Color;
import java.awt.Graphics2D;

public class Bot extends AdvancedRobot {

	EnemyBot enemy = new EnemyBot();
	double previousEnergy = 100;
	int movementDirection = 1;
	
	public void run() {
		// Set colors
		setBodyColor(new Color(255, 255, 0));//Yellow
		setGunColor(new Color(255, 255, 255));//Black
		setRadarColor(new Color(127, 127, 127));//Grey
		setBulletColor(new Color(255, 0, 0));//Red

		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		setAdjustRadarForRobotTurn(true);
		
		enemy.reset();
		
		setTurnRadarRight(Double.POSITIVE_INFINITY);
		
		// Loop forever
		while(true){
			
			if(!enemy.none()){
				doMove(enemy);
				doFire(enemy);
			}
		
			execute();
			scan();
		}
	}
	public void doMove(EnemyBot e){
		setTurnRight(e.getBearing() + 90 - Math.min( ((e.getDistance()-150)/3), 90 )*movementDirection);

		//dodge
		double changeInEnergy = previousEnergy-e.getEnergy();
    	if ( (changeInEnergy>0 && changeInEnergy<=3) && (Utils.getRandom().nextInt(3) == 0) ) {
			movementDirection *= -1;
     	}
		if ( Utils.getRandom().nextInt(50) == 0 ) {
			movementDirection *= -1;
     	}
		setMaxVelocity( Utils.getRandom().nextInt( (int)Rules.MAX_VELOCITY - 4 ) + 5);
		
		setAhead((e.getDistance() / 4 ) * movementDirection);
		previousEnergy = e.getEnergy();
	}
	public void doFire(EnemyBot e){
		double firePower = Math.min(3-e.getDistance()/200, 3);
		/*double bulletSpeed = 20 - firePower * 3;
		long time = (long)(enemy.getDistance() / bulletSpeed);
		
		double futureX = enemy.getFutureX(time);
		double futureY = enemy.getFutureY(time);
		double absDeg = absoluteBearing(getX(), getY(), futureX, futureY);
		setTurnGunRight(Utils.normalRelativeAngleDegrees(absDeg - getGunHeading()));*/
		
		//FireAngle = Utils.normalRelativeAngleDegrees( e.getBearing() + (getHeading() - getRadarHeading()) + (getRadarHeading() - getGunHeading()) );
		//setTurnGunRight(FireAngle);
		setTurnGunRight(Utils.normalRelativeAngleDegrees(LinearTargeting.getAngle(e, this, firePower, 20) - getGunHeading()));
		if( Math.abs(getGunTurnRemaining()) <= 1.5*((180/Math.PI)*Math.atan(18/e.getDistance())) ){
			setFire(firePower);
		}
	}
	public void onPaint(Graphics2D g) {
    	g.setColor(Color.RED);
		g.fillOval((int)enemy.getX() - 5, 600 - (int)enemy.getY() - 5, 10, 10);
		
 	}
	public void onScannedRobot(ScannedRobotEvent e) {
		double radarTurn = getHeadingRadians() + e.getBearingRadians() - getRadarHeadingRadians();
 		setTurnRadarRightRadians(1.9 * Utils.normalRelativeAngle(radarTurn));

		if (enemy.none() || e.getName().equals(enemy.getName())) {
			enemy.update(e, this);
		}
	}
	public void onRobotDeath(RobotDeathEvent e) {
		if (e.getName().equals(enemy.getName())) {
			enemy.reset();
		}
	}
	public void onHitByBullet(HitByBulletEvent e){
		
	}
	public void onHitRobot(HitRobotEvent e) {
		
	}
	public void onHitWall(HitWallEvent e){
		movementDirection *= -1;
	}
}
																														