package sch;

import robocode.*;
import java.util.*;

public class WinStrategy extends Strategy implements Constants {

	private final String strategyName="Win Strategy";
	private int direction;
	private double fieldHeight;
	private double fieldWidth;
	
	public WinStrategy () {
		super();
		direction=1;
		
	}
	public void initialize () {
		fieldHeight=myBot.getBattleFieldHeight();
		fieldWidth=myBot.getBattleFieldWidth();
	}
	
	public void reinitialize () {
		direction=1;
		fieldHeight=myBot.getBattleFieldHeight();
		fieldWidth=myBot.getBattleFieldWidth();
	}
	
	
	public String getName() {return strategyName;}
	
	public void setMovement() {
		goTo(fieldWidth/2,fieldHeight/2);
	}

	public void setScan() {
	
		if (myBot.getRadarTurnRemaining()==0){
			myBot.setTurnRadarRightRadians(2*PI);
			}
	}
	
	public double getGoodness() {
		if (myBot.getOthers()==0)
			return 100.0;
		else
			return 0.0;
		}
	
	public void setGunRotation() {

		if (myBot.getGunTurnRemaining()==0){
			direction*=-1;
			myBot.setTurnGunRightRadians(direction*PI/3);
		}
	}
}