package bayen.nut;
import robocode.*;
import java.util.*;
import robocode.util.*;
import java.awt.geom.*;
import java.awt.Color;
import java.awt.Graphics2D;

class GFGun5 extends Gun {
	public String getName(){return "Anti Surfer GF gun";}
	public Color getColor(){return Color.green;}
	ScannedRobotEvent en;
	private static double BULLET_POWER = 3.0;
	
	private static double lateralDirection;
	private static double lastEnemyVelocity;
	public void onScannedRobot(ScannedRobotEvent e) {
		BULLET_POWER = (Squirrel.getEnergy() / (e.getDistance() / 25));
		if(BULLET_POWER < 0.1)
		BULLET_POWER = 0.1;
		if(BULLET_POWER > 3.0)
		BULLET_POWER = 3.0;
		en = e;
		double enemyAbsoluteBearing = Squirrel.getHeadingRadians() + en.getBearingRadians();
		double enemyDistance = en.getDistance();
		double enemyVelocity = en.getVelocity();
		if (enemyVelocity != 0) {
			lateralDirection = GFTUtils.sign(enemyVelocity * Math.sin(en.getHeadingRadians() - enemyAbsoluteBearing));
		}
		GFTWave5 wave = new GFTWave5(Squirrel);
		wave.gunLocation = new Point2D.Double(Squirrel.getX(), Squirrel.getY());
		GFTWave5.targetLocation = GFTUtils.project(wave.gunLocation, enemyAbsoluteBearing, enemyDistance);
		wave.lateralDirection = lateralDirection;
		wave.bulletPower = BULLET_POWER;
		wave.setSegmentations(enemyDistance, enemyVelocity, lastEnemyVelocity);
		lastEnemyVelocity = enemyVelocity;
		wave.bearing = enemyAbsoluteBearing;
		wave.realWave = false;
		//if (Squirrel.getGunHeat() == 1 + bulletpower / 5) {
			Squirrel.addCustomEvent(wave);
	}
	public double getFiringAngle(double bulletpower) {
		double enemyAbsoluteBearing = Squirrel.getHeadingRadians() + en.getBearingRadians();
		double enemyDistance = en.getDistance();
		double enemyVelocity = en.getVelocity();
		if (enemyVelocity != 0) {
			lateralDirection = GFTUtils.sign(enemyVelocity * Math.sin(en.getHeadingRadians() - enemyAbsoluteBearing));
		}
		GFTWave5 wave = new GFTWave5(Squirrel);
		wave.gunLocation = new Point2D.Double(Squirrel.getX(), Squirrel.getY());
		GFTWave5.targetLocation = GFTUtils.project(wave.gunLocation, enemyAbsoluteBearing, enemyDistance);
		wave.lateralDirection = lateralDirection;
		wave.bulletPower = bulletpower;
		wave.setSegmentations(enemyDistance, enemyVelocity, lastEnemyVelocity);
		lastEnemyVelocity = enemyVelocity;
		wave.bearing = enemyAbsoluteBearing;
		wave.realWave = (Squirrel.getGunHeat() == 1 + bulletpower / 5);
		//if (Squirrel.getGunHeat() == 1 + bulletpower / 5) {
			//Squirrel.addCustomEvent(wave);
			//System.out.println("Fired Wave at " + Squirrel.getTime());
		//}
		return Utils.normalRelativeAngle(enemyAbsoluteBearing + wave.mostVisitedBearingOffset());
	}
	public void shoot(double bulletpower) {
		BULLET_POWER = bulletpower;
		double enemyAbsoluteBearing = Squirrel.getHeadingRadians() + en.getBearingRadians();
		double enemyDistance = en.getDistance();
		double enemyVelocity = en.getVelocity();
		if (enemyVelocity != 0) {
			lateralDirection = GFTUtils.sign(enemyVelocity * Math.sin(en.getHeadingRadians() - enemyAbsoluteBearing));
		}
		GFTWave5 wave = new GFTWave5(Squirrel);
		wave.gunLocation = new Point2D.Double(Squirrel.getX(), Squirrel.getY());
		GFTWave5.targetLocation = GFTUtils.project(wave.gunLocation, enemyAbsoluteBearing, enemyDistance);
		wave.lateralDirection = lateralDirection;
		wave.bulletPower = BULLET_POWER;
		wave.setSegmentations(enemyDistance, enemyVelocity, lastEnemyVelocity);
		lastEnemyVelocity = enemyVelocity;
		wave.bearing = enemyAbsoluteBearing;
		wave.realWave = true;
		//if (Squirrel.getGunHeat() == 1 + bulletpower / 5) {
			Squirrel.addCustomEvent(wave);
	}
	public void run(AdvancedRobot bot) {
		Squirrel = bot;
		lateralDirection = 1;
		lastEnemyVelocity = 0;
	}
	public void onBulletHit(BulletHitEvent e){
		GFTWave5 wave = new GFTWave5(Squirrel);
		wave.bulletHitTrue();
		//System.out.println("Said it's a real bullet");
	}
}