package kvk.Gun;
import kvk.Bots.Bot;
import kvk.ExtendedRobot;
import kvk.Utils.C;
import kvk.Utils.Fct;
import kvk.Utils.Manager;
import robocode.*;

/**
 *  Classe de gestion des canons
 *
 * @author     Ssin.le.Terrible
 * @created    14 janvier 2004
 */
public class GunManager extends Manager {
	private  Bot    bot;
	private  Gun[]  gunList;
	private  int    currentGun;

	public GunManager(ExtendedRobot er) {
		super(er);
	}

	public GunManager(ExtendedRobot er, Bot bot) {
		super(er);
		Aim  aim;

		gunList = new Gun[C.GUN_MODES];
		//Initialisation des canons
		aim = new AimDirectShoot(myBot, C.GUN_NAMES[C.GUN_DIRECT_SHOOT], C.GUN_DIRECT_SHOOT);
		gunList[C.GUN_DIRECT_SHOOT] = new Gun(myBot, bot, aim);
		aim = new AimNimrodStyle(myBot, C.GUN_NAMES[C.GUN_NIMROD_STYLE], C.GUN_NIMROD_STYLE);
		gunList[C.GUN_NIMROD_STYLE] = new Gun(myBot, bot, aim);
		aim = new AimPatternMatcher(myBot, C.GUN_NAMES[C.GUN_PATTERN_MATCHER], C.GUN_PATTERN_MATCHER);
		gunList[C.GUN_PATTERN_MATCHER] = new Gun(myBot, bot, aim);
		//Initialisation du canon courant;
		currentGun = C.GUN_NIMROD_STYLE;
	}

	public void action() {
		Bot           target        = myBot.getTarget();
		double        energy        = myBot.getEnergy();
		FireSolution  fireSolution  = null;
		double        firePower;
		double        offsetAngle;

		//Test si tirs interdits
		if (!myBot.canFire) {
			return;
		}

		if (target != null) {
			double  tEnergy   = target.getEnergy();
			// Calcul de la puissance du tir et choix du canon
			firePower = Math.min(tEnergy / 5d, Math.min(C.MAX_BULLET_POWER, 100d / target.getDistance() * energy));

			currentGun = C.GUN_NIMROD_STYLE;
			//if (target.getPatternSize() > (int)(target.getDistance / Fct.bulletSpeed(firePower)+C.PATTERN_SIZE_MIN)  *2) {
			//if (target.getPatternSize() > 100) {
			//	currentGun = C.GUN_PATTERN_MATCHER;
			//}
			if (target.getDistance() < 50d) {
				firePower = C.MAX_BULLET_POWER;
				currentGun = C.GUN_DIRECT_SHOOT;
			}
			if (target.isDisabled() || !target.isMoving()) {
				firePower = C.MIN_BULLET_POWER;
				currentGun = C.GUN_DIRECT_SHOOT;
			}

			//Ajuste la puissance au strict minimum
			double  maxPower  = myBot.maxFirePowerLimit;
			if (tEnergy == 0d) {
				maxPower = C.MIN_BULLET_POWER;
			}
			else if (tEnergy <= 4) {
				maxPower = tEnergy / 4d;
			}
			else if (tEnergy <= 16) {
				maxPower = (tEnergy + 2d) / 6d;
			}
			//Vrifie les limites de la puissance de feu du fichier de configuration
			firePower = Fct.limite(firePower, myBot.minFirePowerLimit, maxPower);

			// Calcul de la solution de tir
			offsetAngle = target.getAbsBearing();                                        // valeur par dfaut pour suivre la cible
			if (myBot.getGunHeat() < myBot.getGunCoolingRate() * 3d) {
				fireSolution = gunList[currentGun].getFireSolution(firePower);
				if (fireSolution != null) {
					firePower = fireSolution.getFirePower();
					offsetAngle = fireSolution.getGunOffsetAngle();
				}
			}

			// Rotation du canon
			myBot.setTurnGunLeftRadians(robocode.util.Utils.normalRelativeAngle(myBot.getGunHeadingRadians() - offsetAngle));

			// Tir sur la cible
			if (gunList[currentGun].canShoot(fireSolution)) {
				myBot.setFire(firePower);
				//myBot.print(true, "Fire:" + firePower + " at " + Math.toDegrees(offsetAngle));//DEBUG

			}
		}
	}

	public void reinitialise() {
	}
}

